/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDocumentAnalyzer
extends DefaultDocumentAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(CMSDocumentAnalyzer.class);
    protected CMSSignedData cmsSignedData;

    CMSDocumentAnalyzer() {
    }

    public CMSDocumentAnalyzer(CMSSignedData cmsSignedData) {
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentAnalyzer(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
        this.cmsSignedData = this.toCMSSignedData(document);
    }

    private CMSSignedData toCMSSignedData(DSSDocument document) {
        try {
            return DSSUtils.toCMSSignedData((DSSDocument)document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("A CMS file is expected : %s", e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return !DSSUtils.isTimestampToken((DSSDocument)dssDocument) && !EvidenceRecordAnalyzerFactory.isSupportedDocument((DSSDocument)dssDocument);
        }
        return false;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            for (SignerInformation signerInformation : this.cmsSignedData.getSignerInfos().getSigners()) {
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation);
                if (this.document != null) {
                    cadesSignature.setFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setContainerContents(this.containerContents);
                cadesSignature.setManifestFile(this.manifestFile);
                cadesSignature.setSigningCertificateSource(this.signingCertificateSource);
                cadesSignature.initBaselineRequirementsChecker(this.certificateVerifier);
                this.validateSignaturePolicy((AdvancedSignature)cadesSignature);
                signatures.add((AdvancedSignature)cadesSignature);
            }
        }
        return signatures;
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
        try {
            return Collections.singletonList(cadesSignature.getOriginalDocument());
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }
}

