/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignaturePolicyStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignaturePolicyStoreBuilder.class);
    private DSSResourcesHandlerBuilder resourcesHandlerBuilder;

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        CMS originalCmsSignedData = CMSUtils.parseToCMS((DSSDocument)signatureDocument);
        CMS newCmsSignedData = this.extendCMS(originalCmsSignedData, signaturePolicyStore);
        newCmsSignedData = CMSUtils.populateDigestAlgorithmSet((CMS)newCmsSignedData, (Collection)originalCmsSignedData.getDigestAlgorithmIDs());
        return CMSUtils.writeToDSSDocument((CMS)newCmsSignedData, (DSSResourcesHandlerBuilder)this.resourcesHandlerBuilder);
    }

    public CMS extendCMS(CMS cms, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(cms, "CMS must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        CMSDocumentAnalyzer documentAnalyzer = new CMSDocumentAnalyzer(cms);
        List signatures = documentAnalyzer.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException("Unable to extend the document! No signatures found.");
        }
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        boolean signaturePolicyStoreAdded = false;
        for (AdvancedSignature signature : signatures) {
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            SignerInformation newSignerInformation = this.addSignaturePolicyStoreIfDigestMatch(cadesSignature, signaturePolicyStore);
            if (cadesSignature.getSignerInformation() != newSignerInformation) {
                signaturePolicyStoreAdded = true;
            }
            newSignerInformationList.add(newSignerInformation);
        }
        if (!signaturePolicyStoreAdded) {
            throw new IllegalInputException("The process did not find a signature to add SignaturePolicyStore!");
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        return CMSUtils.replaceSigners((CMS)cms, (SignerInformationStore)newSignerStore);
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore, String signatureId) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        CMS originalCmsSignedData = CMSUtils.parseToCMS((DSSDocument)signatureDocument);
        CMS newCmsSignedData = this.extendCMS(originalCmsSignedData, signaturePolicyStore, signatureId);
        newCmsSignedData = CMSUtils.populateDigestAlgorithmSet((CMS)newCmsSignedData, (Collection)originalCmsSignedData.getDigestAlgorithmIDs());
        return CMSUtils.writeToDSSDocument((CMS)newCmsSignedData, (DSSResourcesHandlerBuilder)this.resourcesHandlerBuilder);
    }

    public CMS extendCMS(CMS cms, SignaturePolicyStore signaturePolicyStore, String signatureId) {
        Objects.requireNonNull(cms, "CMS must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        CMSDocumentAnalyzer documentAnalyzer = new CMSDocumentAnalyzer(cms);
        AdvancedSignature signature = documentAnalyzer.getSignatureById(signatureId);
        if (signature == null) {
            throw new IllegalInputException(String.format("Unable to find a signature with Id : %s!", signatureId));
        }
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (AdvancedSignature currentSignature : documentAnalyzer.getSignatures()) {
            CAdESSignature cadesSignature = (CAdESSignature)currentSignature;
            if (signature.equals((Object)cadesSignature)) {
                SignerInformation newSignerInformation = this.addSignaturePolicyStoreIfDigestMatch(cadesSignature, signaturePolicyStore);
                if (cadesSignature.getSignerInformation() == newSignerInformation) {
                    throw new IllegalInputException(String.format("The process was not able to add SignaturePolicyStore to a signature with Id : %s!", signatureId));
                }
                newSignerInformationList.add(newSignerInformation);
                continue;
            }
            newSignerInformationList.add(cadesSignature.getSignerInformation());
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        return CMSUtils.replaceSigners((CMS)cms, (SignerInformationStore)newSignerStore);
    }

    protected SignerInformation addSignaturePolicyStoreIfDigestMatch(CAdESSignature cadesSignature, SignaturePolicyStore signaturePolicyStore) {
        SignerInformation signerInformation = cadesSignature.getSignerInformation();
        this.assertSignaturePolicyStoreExtensionPossible(signerInformation);
        SignerInformation newSignerInformation = signerInformation;
        if (this.checkDigest(cadesSignature, signaturePolicyStore)) {
            newSignerInformation = this.addSignaturePolicyStore(signerInformation, signaturePolicyStore);
        }
        return newSignerInformation;
    }

    protected boolean checkDigest(CAdESSignature cadesSignature, SignaturePolicyStore signaturePolicyStore) {
        SignaturePolicy signaturePolicy = cadesSignature.getSignaturePolicy();
        if (signaturePolicy == null) {
            LOG.warn("signature-policy-identifier is not defined for a signature with Id : {}", (Object)cadesSignature.getId());
            return false;
        }
        Digest expectedDigest = signaturePolicy.getDigest();
        if (expectedDigest == null) {
            LOG.warn("signature-policy-identifier digest is not found for a signature with Id : {}", (Object)cadesSignature.getId());
            return false;
        }
        DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
        if (signaturePolicyContent == null) {
            LOG.info("No policy document has been provided. Digests are not checked!");
            return true;
        }
        signaturePolicy.setPolicyContent(signaturePolicyContent);
        SignaturePolicyValidator validator = new DefaultSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
        Digest computedDigest = validator.getComputedDigest(signaturePolicyContent, expectedDigest.getAlgorithm());
        boolean digestMatch = expectedDigest.equals((Object)computedDigest);
        if (!digestMatch) {
            LOG.warn("Signature policy's digest {} doesn't match the digest extracted from document {} for signature with Id : {}", new Object[]{computedDigest, expectedDigest, cadesSignature.getId()});
        }
        return digestMatch;
    }

    private SignerInformation addSignaturePolicyStore(SignerInformation signerInformation, SignaturePolicyStore signaturePolicyStore) {
        AttributeTable unsignedAttributes = CAdESUtils.getUnsignedAttributes(signerInformation);
        ASN1Sequence sigPolicyStore = this.getSignaturePolicyStore(signaturePolicyStore);
        AttributeTable unsignedAttributesWithPolicyStore = unsignedAttributes.add(OID.id_aa_ets_sigPolicyStore, (ASN1Encodable)sigPolicyStore);
        return CMSUtils.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributesWithPolicyStore);
    }

    private ASN1Sequence getSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        String sigPolDocLocalURI;
        ASN1EncodableVector sigPolicyStore = new ASN1EncodableVector();
        sigPolicyStore.add((ASN1Encodable)DSSASN1Utils.buildSPDocSpecificationId((String)signaturePolicyStore.getSpDocSpecification().getId()));
        DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
        if (signaturePolicyContent != null) {
            sigPolicyStore.add((ASN1Encodable)new DEROctetString(DSSUtils.toByteArray((DSSDocument)signaturePolicyStore.getSignaturePolicyContent())));
        }
        if ((sigPolDocLocalURI = signaturePolicyStore.getSigPolDocLocalURI()) != null) {
            sigPolicyStore.add((ASN1Encodable)new DERIA5String(sigPolDocLocalURI));
        }
        return new DERSequence(sigPolicyStore);
    }

    private void assertConfigurationValid(SignaturePolicyStore signaturePolicyStore) {
        boolean sigPolDocLocalURIPresent;
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        boolean signaturePolicyContentPresent = signaturePolicyStore.getSignaturePolicyContent() != null;
        boolean bl = sigPolDocLocalURIPresent = signaturePolicyStore.getSigPolDocLocalURI() != null;
        if (!(signaturePolicyContentPresent ^ sigPolDocLocalURIPresent)) {
            throw new IllegalArgumentException("SignaturePolicyStore shall contain either SignaturePolicyContent document or sigPolDocLocalURI!");
        }
    }

    private void assertSignaturePolicyStoreExtensionPossible(SignerInformation signerInformation) {
        if (CAdESUtils.containsATSTv2(signerInformation)) {
            throw new IllegalInputException("Cannot add signature policy store to a CAdES containing an archiveTimestampV2");
        }
        if (CAdESUtils.containsEvidenceRecord(signerInformation)) {
            throw new IllegalInputException("Cannot add signature policy store to a CMS containing an evidence record unsigned attribute.");
        }
    }
}

