/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.scope.EvidenceRecordMasterSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.EvidenceRecordScopeFinder;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;

public class CAdESEvidenceRecordScopeFinder
extends EvidenceRecordScopeFinder {
    private final AdvancedSignature signature;

    public CAdESEvidenceRecordScopeFinder(EvidenceRecord evidenceRecord, AdvancedSignature signature) {
        super(evidenceRecord);
        this.signature = signature;
    }

    public List<SignatureScope> findEvidenceRecordScope() {
        List evidenceRecordScopes = super.findEvidenceRecordScope();
        if (this.isSignatureEmbeddedAndValid(this.evidenceRecord) && this.isSignatureCovered(this.evidenceRecord, this.signature)) {
            evidenceRecordScopes.add(new EvidenceRecordCAdESSignatureScope(this.signature, this.getCAdESSignatureDocument(this.signature)));
        }
        return evidenceRecordScopes;
    }

    private boolean isSignatureCovered(EvidenceRecord evidenceRecord, AdvancedSignature signature) {
        CAdESSignature masterSignature = (CAdESSignature)evidenceRecord.getMasterSignature();
        CAdESSignature cadesSignature = (CAdESSignature)signature;
        return masterSignature.getCMS() == cadesSignature.getCMS();
    }

    private DSSDocument getCAdESSignatureDocument(AdvancedSignature signature) {
        CAdESSignature cadesSignature = (CAdESSignature)signature;
        byte[] derEncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)cadesSignature.getSignerInformation().toASN1Structure());
        return this.createInMemoryDocument(derEncoded);
    }

    private static class EvidenceRecordCAdESSignatureScope
    extends EvidenceRecordMasterSignatureScope {
        private static final long serialVersionUID = -1583386221534165955L;

        public EvidenceRecordCAdESSignatureScope(AdvancedSignature masterSignature, DSSDocument originalDocument) {
            super(masterSignature, originalDocument);
        }

        public String getDescription(TokenIdentifierProvider tokenIdentifierProvider) {
            return String.format("Signature with Id : %s", tokenIdentifierProvider.getIdAsString((IdentifierBasedObject)this.masterSignature));
        }
    }
}

