/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms.object;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSSignedDocument;
import eu.europa.esig.dss.cms.ICMSUtils;
import eu.europa.esig.dss.cms.object.CMSSignedDataObject;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSObjectUtils
implements ICMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CMSObjectUtils.class);

    public CMS parseToCMS(DSSDocument document) {
        CMSSignedDataObject cMSSignedDataObject;
        block9: {
            if (document instanceof CMSSignedDocument) {
                return new CMSSignedDataObject(((CMSSignedDocument)document).getCMSSignedData());
            }
            InputStream is = document.openStream();
            try {
                CMSSignedData cmsSignedData = new CMSSignedData(is);
                cMSSignedDataObject = new CMSSignedDataObject(cmsSignedData);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CMSException e) {
                    throw new DSSException("Not a valid CAdES file", e);
                }
            }
            is.close();
        }
        return cMSSignedDataObject;
    }

    public CMS parseToCMS(byte[] binaries) {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(binaries);
            return new CMSSignedDataObject(cmsSignedData);
        }
        catch (CMSException e) {
            throw new DSSException("Not a valid CAdES file", (Throwable)e);
        }
    }

    public DSSDocument writeToDSSDocument(CMS cms, DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        CMSSignedDataObject cmsSignedDataObject = CMSObjectUtils.toCMSSignedDataObject(cms);
        return new CMSSignedDocument(cmsSignedDataObject.getCMSSignedData());
    }

    public SignerInformation recomputeSignerInformation(CMS cms, SignerId signerId, DigestCalculatorProvider digestCalculatorProvider, DSSResourcesHandlerBuilder resourcesHandlerBuilder) throws CMSException {
        CMSSignedDataParser cmsSignedDataParser = new CMSSignedDataParser(digestCalculatorProvider, cms.getDEREncoded());
        return cmsSignedDataParser.getSignerInfos().get(signerId);
    }

    public CMS replaceSigners(CMS cms, SignerInformationStore newSignerStore) {
        try {
            CMSSignedDataObject cmsSignedDataObject = CMSObjectUtils.toCMSSignedDataObject(cms);
            CMSSignedData cmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)cmsSignedDataObject.getCMSSignedData(), (SignerInformationStore)newSignerStore);
            return new CMSSignedDataObject(cmsSignedData);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to replace signerInfo of CMS SignedData. Corrupted content has been provided. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public CMS replaceCertificatesAndCRLs(CMS cms, Store<X509CertificateHolder> certificates, Store<X509AttributeCertificateHolder> attributeCertificates, Store<X509CRLHolder> crls, Store<?> ocspResponsesStore, Store<?> ocspBasicStore) {
        CMSSignedDataObject cmsSignedDataObject = CMSObjectUtils.toCMSSignedDataObject(cms);
        try {
            Store<Encodable> newCRLStore = CMSObjectUtils.toCRLsStore(crls, ocspResponsesStore, ocspBasicStore);
            CMSSignedData cmsSignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)cmsSignedDataObject.getCMSSignedData(), certificates, attributeCertificates, newCRLStore);
            return new CMSSignedDataObject(cmsSignedData);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to replace validation content of CMS SignedData. Corrupted content has been provided. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static Store<Encodable> toCRLsStore(Store<X509CRLHolder> crls, Store<?> ocspResponses, Store<?> ocspBasicResponses) {
        LinkedHashSet<OtherRevocationInfoFormat> newCrlsStore = new LinkedHashSet<OtherRevocationInfoFormat>(crls.getMatches(null));
        for (Object ocsp : ocspResponses.getMatches(null)) {
            newCrlsStore.add(new OtherRevocationInfoFormat(CMSObjectIdentifiers.id_ri_ocsp_response, (ASN1Encodable)ocsp));
        }
        for (Object ocsp : ocspBasicResponses.getMatches(null)) {
            newCrlsStore.add(new OtherRevocationInfoFormat(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1Encodable)ocsp));
        }
        return new CollectionStore(newCrlsStore);
    }

    public CMS populateDigestAlgorithmSet(CMS cms, Collection<AlgorithmIdentifier> digestAlgorithmsToAdd) {
        try {
            CMSSignedDataObject cmsSignedDataObject = CMSObjectUtils.toCMSSignedDataObject(cms);
            CMSSignedData cmsSignedData = cmsSignedDataObject.getCMSSignedData();
            for (AlgorithmIdentifier asn1ObjectIdentifier : digestAlgorithmsToAdd) {
                if (cmsSignedData.getDigestAlgorithmIDs().contains(asn1ObjectIdentifier)) continue;
                cmsSignedData = CMSSignedData.addDigestAlgorithm((CMSSignedData)cmsSignedData, (AlgorithmIdentifier)asn1ObjectIdentifier);
            }
            return new CMSSignedDataObject(cmsSignedData);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to populate digest algorithms within CMS SignedData. Corrupted content has been provided. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private static CMSSignedDataObject toCMSSignedDataObject(CMS cms) {
        if (cms instanceof CMSSignedDataObject) {
            return (CMSSignedDataObject)cms;
        }
        throw new IllegalStateException("Only CMSSignedDataObject implementation is supported in 'dss-cms-object' module!");
    }

    public CMS toCMS(TimeStampToken timeStampToken) {
        return new CMSSignedDataObject(timeStampToken.toCMSSignedData());
    }

    public String getContentInfoEncoding(CMS cms) {
        CMSSignedDataObject cmsSignedDataObject = CMSObjectUtils.toCMSSignedDataObject(cms);
        ContentInfo contentInfo = cmsSignedDataObject.getCMSSignedData().toASN1Structure();
        if (contentInfo.isDefiniteLength()) {
            return "DL";
        }
        return "BER";
    }

    public void writeSignedDataDigestAlgorithmsEncoded(CMS cms, OutputStream os) throws IOException {
        SignedData signedData = CMSObjectUtils.getSignedData(cms);
        ASN1Set digestAlgorithms = signedData.getDigestAlgorithms();
        digestAlgorithms.encodeTo(os);
    }

    public void writeContentInfoEncoded(CMS cms, OutputStream os) throws IOException {
        SignedData signedData = CMSObjectUtils.getSignedData(cms);
        ContentInfo content = signedData.getEncapContentInfo();
        byte[] contentInfoBytes = content.getContent() instanceof BEROctetString ? DSSASN1Utils.getBEREncoded((ASN1Encodable)content) : DSSASN1Utils.getDEREncoded((ASN1Encodable)content);
        if (LOG.isTraceEnabled()) {
            LOG.trace("ContentInfo: {}", (Object)DSSUtils.toHex((byte[])contentInfoBytes));
        }
        os.write(contentInfoBytes);
    }

    public void writeSignedDataCertificatesEncoded(CMS cms, OutputStream os) throws IOException {
        SignedData signedData = CMSObjectUtils.getSignedData(cms);
        ASN1Set certificates = signedData.getCertificates();
        if (certificates != null) {
            byte[] certificatesBytes;
            try {
                certificatesBytes = certificates instanceof BERSet ? new BERTaggedObject(false, 0, (ASN1Encodable)new BERSequence(certificates.toArray())).getEncoded() : new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(certificates.toArray())).getEncoded();
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred on reading SignedData.certificates field : %s", e.getMessage()), (Throwable)e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Certificates: {}", (Object)DSSUtils.toHex((byte[])certificatesBytes));
            }
            os.write(certificatesBytes);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Certificates are not present in the SignedData.");
        }
    }

    public void writeSignedDataCRLsEncoded(CMS cms, OutputStream os) throws IOException {
        SignedData signedData = CMSObjectUtils.getSignedData(cms);
        ASN1Set crLs = signedData.getCRLs();
        if (crLs != null) {
            byte[] crlBytes;
            try {
                crlBytes = signedData.getCRLs() instanceof BERSet ? new BERTaggedObject(false, 1, (ASN1Encodable)new BERSequence(crLs.toArray())).getEncoded() : new DERTaggedObject(false, 1, (ASN1Encodable)new DERSequence(crLs.toArray())).getEncoded();
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred on reading SignedData.crls field : %s", e.getMessage()), (Throwable)e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("CRLs: {}", (Object)DSSUtils.toHex((byte[])crlBytes));
            }
            os.write(crlBytes);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("CRLs are not present in the SignedData.");
        }
    }

    public void writeSignedDataSignerInfosEncoded(CMS cms, OutputStream os) throws IOException {
        SignedData signedData = CMSObjectUtils.getSignedData(cms);
        SignerInformationStore signerInfos = cms.getSignerInfos();
        if (signerInfos != null) {
            byte[] signerInfosBytes;
            try {
                ASN1EncodableVector signerInfosVector = new ASN1EncodableVector();
                for (SignerInformation signerInformation : cms.getSignerInfos()) {
                    signerInfosVector.add((ASN1Encodable)signerInformation.toASN1Structure());
                }
                signerInfosBytes = signedData.getSignerInfos() instanceof BERSet ? new BERSet(signerInfosVector).getEncoded() : new DERSet(signerInfosVector).getEncoded();
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred on reading SignedData.signerInfos field : %s", e.getMessage()), (Throwable)e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("SignerInfos: {}", (Object)DSSUtils.toHex((byte[])signerInfosBytes));
            }
            os.write(signerInfosBytes);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("SignerInfos are not present in the SignedData.");
        }
    }

    public static SignedData getSignedData(CMS cms) {
        CMSSignedDataObject cmsSignedDataObject = CMSObjectUtils.toCMSSignedDataObject(cms);
        ContentInfo contentInfo = cmsSignedDataObject.getCMSSignedData().toASN1Structure();
        return SignedData.getInstance((Object)contentInfo.getContent());
    }

    public CMSTypedData toCMSEncapsulatedContent(DSSDocument document) {
        CMSAbsentContent content;
        Objects.requireNonNull(document, "Document to be signed is missing");
        if (document instanceof DigestDocument) {
            content = new CMSAbsentContent();
        } else if (document instanceof FileDocument) {
            FileDocument fileDocument = (FileDocument)document;
            content = new CMSProcessableFile(fileDocument.getFile());
        } else {
            content = new CMSProcessableByteArray(DSSUtils.toByteArray((DSSDocument)document));
        }
        return content;
    }

    public DSSResourcesHandlerBuilder getDSSResourcesHandlerBuilder(DSSResourcesHandlerBuilder dssResourcesHandlerBuilder) {
        throw new UnsupportedOperationException("Usage of DSSResourcesHandlerBuilder is not supported within the 'dss-cms-object' module! Remove the setter to use in-memory processing, or switch to 'dss-cms-stream' implementation.");
    }

    public SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable unsignedAttributes) {
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
    }

    public void assertATSv2AugmentationSupported() {
    }

    public void assertEvidenceRecordEmbeddingSupported() {
    }
}

