/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.OrphanCertificateTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanRevocationTokenWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEncapsulationType;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificateToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.CertificateStatus;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiagnosticData {
    private final XmlDiagnosticData wrapped;
    private List<SignatureWrapper> foundSignatures;
    private List<CertificateWrapper> usedCertificates;
    private List<TimestampWrapper> usedTimestamps;
    private List<EvidenceRecordWrapper> foundEvidenceRecords;

    public DiagnosticData(XmlDiagnosticData wrapped) {
        this.wrapped = wrapped;
    }

    public String getDocumentName() {
        return this.wrapped.getDocumentName();
    }

    public List<String> getSignatureIdList() {
        ArrayList<String> signatureIds = new ArrayList<String>();
        List<XmlSignature> signatures = this.wrapped.getSignatures();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                signatureIds.add(xmlSignature.getId());
            }
        }
        return signatureIds;
    }

    public String getFirstSignatureId() {
        SignatureWrapper firstSignature = this.getFirstSignatureNullSafe();
        return firstSignature.getId();
    }

    public Date getFirstSignatureDate() {
        SignatureWrapper firstSignature = this.getFirstSignatureNullSafe();
        return firstSignature.getClaimedSigningTime();
    }

    public Date getSignatureDate(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getClaimedSigningTime();
    }

    public SignatureLevel getFirstSignatureFormat() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getSignatureFormat();
    }

    public SignatureLevel getSignatureFormat(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getSignatureFormat();
    }

    public List<XmlSignerRole> getSignedAssertionsInFirstSignature() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getSignedAssertions();
    }

    public List<XmlSignerRole> getSignedAssertions(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getSignedAssertions();
    }

    public DigestAlgorithm getFirstSignatureDigestAlgorithm() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getDigestAlgorithm();
    }

    public DigestAlgorithm getSignatureDigestAlgorithm(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getDigestAlgorithm();
    }

    public EncryptionAlgorithm getFirstSignatureEncryptionAlgorithm() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getEncryptionAlgorithm();
    }

    public EncryptionAlgorithm getSignatureEncryptionAlgorithm(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getEncryptionAlgorithm();
    }

    @Deprecated
    public MaskGenerationFunction getSignatureMaskGenerationFunction(String signatureId) {
        EncryptionAlgorithm encryptionAlgorithm = this.getSignatureEncryptionAlgorithm(signatureId);
        if (EncryptionAlgorithm.RSASSA_PSS == encryptionAlgorithm) {
            return MaskGenerationFunction.MGF1;
        }
        return null;
    }

    public String getSigningCertificateId(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        if (signature.getSigningCertificate() != null) {
            return signature.getSigningCertificate().getId();
        }
        return null;
    }

    public boolean isSigningCertificateIdentified(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.isSigningCertificateIdentified();
    }

    public List<String> getSignatureCertificateChain(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        ArrayList<String> result = new ArrayList<String>();
        for (CertificateWrapper certWrapper : signature.getCertificateChain()) {
            result.add(certWrapper.getId());
        }
        return result;
    }

    public String getFirstPolicyId() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getPolicyId();
    }

    public String getPolicyId(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getPolicyId();
    }

    public String getPolicyDescription(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getPolicyDescription();
    }

    public List<String> getPolicyDocumentationReferences(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getPolicyDocumentationReferences();
    }

    public List<String> getTimestampIdList() {
        List<TimestampWrapper> timestampList = this.getTimestampList();
        ArrayList<String> timestampIdList = new ArrayList<String>();
        if (timestampList != null) {
            for (TimestampWrapper timestampWrapper : timestampList) {
                timestampIdList.add(timestampWrapper.getId());
            }
        }
        return timestampIdList;
    }

    public List<String> getTimestampIdList(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getTimestampIdsList();
    }

    public List<TimestampWrapper> getTimestampList(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getTimestampList();
    }

    public boolean isBLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.isBLevelTechnicallyValid();
    }

    public boolean isThereTLevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereTLevel();
    }

    public boolean isTLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isTLevelTechnicallyValid();
    }

    public boolean isThereXLevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereXLevel();
    }

    public boolean isXLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isXLevelTechnicallyValid();
    }

    public boolean isThereALevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereALevel();
    }

    public boolean isALevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isALevelTechnicallyValid();
    }

    public List<SignerDataWrapper> getSignerDocuments(String signatureId) {
        ArrayList<SignerDataWrapper> result = new ArrayList<SignerDataWrapper>();
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        List<XmlSignatureScope> signatureScopes = signatureWrapper.getSignatureScopes();
        if (signatureScopes != null && !signatureScopes.isEmpty()) {
            for (XmlSignatureScope xmlSignatureScope : signatureScopes) {
                XmlSignerData signerData = xmlSignatureScope.getSignerData();
                if (signerData.getParent() != null) continue;
                result.add(new SignerDataWrapper(signerData));
            }
        }
        return result;
    }

    public String getTimestampSigningCertificateId(String timestampId) {
        TimestampWrapper timestamp = this.getTimestampByIdNullSafe(timestampId);
        return timestamp.getSigningCertificate().getId();
    }

    public TimestampType getTimestampType(String timestampId) {
        TimestampWrapper timestamp = this.getTimestampByIdNullSafe(timestampId);
        return timestamp.getType();
    }

    public List<TimestampWrapper> getTimestampsByType(TimestampType timestampType) {
        ArrayList<TimestampWrapper> result = new ArrayList<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : this.getTimestampList()) {
            if (timestampType == null || timestampType != timestampWrapper.getType()) continue;
            result.add(timestampWrapper);
        }
        return result;
    }

    public boolean isValidCertificate(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        boolean signatureValid = certificate.isSignatureValid();
        CertificateRevocationWrapper latestRevocationData = this.getLatestRevocationDataForCertificate(certificate);
        boolean revocationValid = latestRevocationData != null && latestRevocationData.getStatus().isGood();
        boolean trusted = certificate.isTrusted();
        return signatureValid && (trusted || revocationValid);
    }

    public String getCertificateDN(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getCertificateDN();
    }

    public String getCertificateIssuerDN(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getCertificateIssuerDN();
    }

    public String getCertificateSerialNumber(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getSerialNumber();
    }

    public RevocationType getCertificateRevocationSource(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return this.getLatestRevocationDataForCertificate(certificate).getRevocationType();
        }
        return null;
    }

    public CertificateStatus getCertificateRevocationStatus(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return this.getLatestRevocationDataForCertificate(certificate).getStatus();
        }
        return CertificateStatus.UNKNOWN;
    }

    public RevocationReason getCertificateRevocationReason(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return this.getLatestRevocationDataForCertificate(certificate).getReason();
        }
        return null;
    }

    public String getErrorMessage(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getErrorMessage();
    }

    private SignatureWrapper getFirstSignatureNullSafe() {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (signatures != null && !signatures.isEmpty()) {
            return signatures.get(0);
        }
        return new SignatureWrapper(new XmlSignature());
    }

    public SignatureWrapper getSignatureById(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (signatures != null) {
            for (SignatureWrapper xmlSignature : signatures) {
                if (!id.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    private SignatureWrapper getSignatureByIdNullSafe(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (signatures != null) {
            for (SignatureWrapper xmlSignature : signatures) {
                if (!id.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return new SignatureWrapper(new XmlSignature());
    }

    private TimestampWrapper getTimestampByIdNullSafe(String id) {
        TimestampWrapper timestamp = this.getTimestampById(id);
        if (timestamp != null) {
            return timestamp;
        }
        return new TimestampWrapper(new XmlTimestamp());
    }

    public TimestampWrapper getTimestampById(String id) {
        List<TimestampWrapper> allTimestamps = this.getTimestampList();
        for (TimestampWrapper timestampWrapper : allTimestamps) {
            if (!id.equals(timestampWrapper.getId())) continue;
            return timestampWrapper;
        }
        return null;
    }

    public CertificateWrapper getUsedCertificateByIdNullSafe(String id) {
        CertificateWrapper cert = this.getUsedCertificateById(id);
        if (cert != null) {
            return cert;
        }
        return new CertificateWrapper(new XmlCertificate());
    }

    public CertificateWrapper getUsedCertificateById(String id) {
        List<CertificateWrapper> certificates = this.getUsedCertificates();
        if (certificates != null) {
            for (CertificateWrapper certificate : certificates) {
                if (!id.equals(certificate.getId())) continue;
                return certificate;
            }
        }
        return null;
    }

    public OrphanCertificateTokenWrapper getOrphanCertificateById(String id) {
        List<OrphanCertificateTokenWrapper> orphanCertificates = this.getAllOrphanCertificateObjects();
        if (orphanCertificates != null) {
            for (OrphanCertificateTokenWrapper certificate : orphanCertificates) {
                if (!id.equals(certificate.getId())) continue;
                return certificate;
            }
        }
        return null;
    }

    public List<CertificateWrapper> getCertificatesFromSource(CertificateSourceType certificateSourceType) {
        ArrayList<CertificateWrapper> certificates = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper certificate : this.getUsedCertificates()) {
            if (!certificate.getSources().contains(certificateSourceType)) continue;
            certificates.add(certificate);
        }
        return certificates;
    }

    public List<OrphanCertificateTokenWrapper> getAllOrphanCertificateObjects() {
        ArrayList<OrphanCertificateTokenWrapper> orphanCertificateValues = new ArrayList<OrphanCertificateTokenWrapper>();
        if (this.wrapped.getOrphanTokens() != null) {
            for (XmlOrphanCertificateToken orphanToken : this.wrapped.getOrphanTokens().getOrphanCertificates()) {
                OrphanCertificateTokenWrapper orphanCertificate = new OrphanCertificateTokenWrapper(orphanToken);
                if (!XmlEncapsulationType.BINARIES.equals((Object)orphanToken.getEncapsulationType()) || orphanCertificateValues.contains(orphanCertificate)) continue;
                orphanCertificateValues.add(orphanCertificate);
            }
        }
        return orphanCertificateValues;
    }

    public List<OrphanCertificateTokenWrapper> getAllOrphanCertificateReferences() {
        ArrayList<OrphanCertificateTokenWrapper> orphanCertificateRefs = new ArrayList<OrphanCertificateTokenWrapper>();
        if (this.wrapped.getOrphanTokens() != null) {
            for (XmlOrphanCertificateToken orphanToken : this.wrapped.getOrphanTokens().getOrphanCertificates()) {
                OrphanCertificateTokenWrapper orphanCertificate = new OrphanCertificateTokenWrapper(orphanToken);
                if (!XmlEncapsulationType.REFERENCE.equals((Object)orphanToken.getEncapsulationType()) || orphanCertificateRefs.contains(orphanCertificate)) continue;
                orphanCertificateRefs.add(orphanCertificate);
            }
        }
        return orphanCertificateRefs;
    }

    public List<OrphanRevocationTokenWrapper> getAllOrphanRevocationObjects() {
        ArrayList<OrphanRevocationTokenWrapper> orphanRevocationValues = new ArrayList<OrphanRevocationTokenWrapper>();
        if (this.wrapped.getOrphanTokens() != null) {
            for (XmlOrphanRevocationToken orphanToken : this.wrapped.getOrphanTokens().getOrphanRevocations()) {
                OrphanRevocationTokenWrapper orphanRevocation = new OrphanRevocationTokenWrapper(orphanToken);
                if (!XmlEncapsulationType.BINARIES.equals((Object)orphanToken.getEncapsulationType()) || orphanRevocationValues.contains(orphanRevocation)) continue;
                orphanRevocationValues.add(orphanRevocation);
            }
        }
        return orphanRevocationValues;
    }

    public List<OrphanRevocationTokenWrapper> getAllOrphanRevocationReferences() {
        ArrayList<OrphanRevocationTokenWrapper> orphanRevocationRefs = new ArrayList<OrphanRevocationTokenWrapper>();
        if (this.wrapped.getOrphanTokens() != null) {
            for (XmlOrphanRevocationToken orphanToken : this.wrapped.getOrphanTokens().getOrphanRevocations()) {
                OrphanRevocationTokenWrapper orphanRevocation = new OrphanRevocationTokenWrapper(orphanToken);
                if (!XmlEncapsulationType.REFERENCE.equals((Object)orphanToken.getEncapsulationType()) || orphanRevocationRefs.contains(orphanRevocation)) continue;
                orphanRevocationRefs.add(orphanRevocation);
            }
        }
        return orphanRevocationRefs;
    }

    public List<CertificateWrapper> getCrossCertificates(CertificateWrapper certificate) {
        ArrayList<CertificateWrapper> crossCertificates = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper candidate : this.getEquivalentCertificates(certificate)) {
            if (certificate.getCertificateDN().equals(candidate.getCertificateDN()) && certificate.getCertificateIssuerDN().equals(candidate.getCertificateIssuerDN())) continue;
            crossCertificates.add(candidate);
        }
        return crossCertificates;
    }

    public List<OrphanCertificateTokenWrapper> getOrphanCrossCertificates(CertificateWrapper certificate) {
        ArrayList<OrphanCertificateTokenWrapper> crossCertificates = new ArrayList<OrphanCertificateTokenWrapper>();
        for (OrphanCertificateTokenWrapper candidate : this.getOrphanEquivalentCertificates(certificate)) {
            if (certificate.getCertificateDN().equals(candidate.getCertificateDN()) && certificate.getCertificateIssuerDN().equals(candidate.getCertificateIssuerDN())) continue;
            crossCertificates.add(candidate);
        }
        return crossCertificates;
    }

    public List<CertificateWrapper> getEquivalentCertificates(CertificateWrapper certificate) {
        ArrayList<CertificateWrapper> equivalentCertificates = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper candidate : this.getUsedCertificates()) {
            if (certificate.equals(candidate) || !certificate.getEntityKey().equals(candidate.getEntityKey())) continue;
            equivalentCertificates.add(candidate);
        }
        return equivalentCertificates;
    }

    public List<OrphanCertificateTokenWrapper> getOrphanEquivalentCertificates(CertificateWrapper certificate) {
        ArrayList<OrphanCertificateTokenWrapper> equivalentCertificates = new ArrayList<OrphanCertificateTokenWrapper>();
        for (OrphanCertificateTokenWrapper candidate : this.getAllOrphanCertificateObjects()) {
            if (certificate.getId().equals(candidate.getId()) || !certificate.getEntityKey().equals(candidate.getEntityKey())) continue;
            equivalentCertificates.add(candidate);
        }
        return equivalentCertificates;
    }

    public List<SignatureWrapper> getSignatures() {
        if (this.foundSignatures == null) {
            this.foundSignatures = new ArrayList<SignatureWrapper>();
            List<XmlSignature> xmlSignatures = this.wrapped.getSignatures();
            if (xmlSignatures != null) {
                for (XmlSignature xmlSignature : xmlSignatures) {
                    this.foundSignatures.add(new SignatureWrapper(xmlSignature));
                }
            }
        }
        return this.foundSignatures;
    }

    public List<TimestampWrapper> getTimestampList() {
        if (this.usedTimestamps == null) {
            this.usedTimestamps = new ArrayList<TimestampWrapper>();
            List<XmlTimestamp> xmlTimestamps = this.wrapped.getUsedTimestamps();
            if (xmlTimestamps != null) {
                for (XmlTimestamp xmlTimestamp : xmlTimestamps) {
                    this.usedTimestamps.add(new TimestampWrapper(xmlTimestamp));
                }
            }
        }
        return this.usedTimestamps;
    }

    public List<TimestampWrapper> getNonEvidenceRecordTimestamps() {
        ArrayList<TimestampWrapper> result = new ArrayList<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : this.getTimestampList()) {
            if (timestampWrapper.getType().isEvidenceRecordTimestamp()) continue;
            result.add(timestampWrapper);
        }
        return result;
    }

    public List<EvidenceRecordWrapper> getEvidenceRecords() {
        if (this.foundEvidenceRecords == null) {
            this.foundEvidenceRecords = new ArrayList<EvidenceRecordWrapper>();
            List<XmlEvidenceRecord> xmlEvidenceRecords = this.wrapped.getEvidenceRecords();
            if (xmlEvidenceRecords != null) {
                for (XmlEvidenceRecord xmlEvidenceRecord : xmlEvidenceRecords) {
                    this.foundEvidenceRecords.add(new EvidenceRecordWrapper(xmlEvidenceRecord));
                }
            }
        }
        return this.foundEvidenceRecords;
    }

    public EvidenceRecordWrapper getEvidenceRecordById(String id) {
        List<EvidenceRecordWrapper> evidenceRecords = this.getEvidenceRecords();
        for (EvidenceRecordWrapper evidenceRecord : evidenceRecords) {
            if (!id.equals(evidenceRecord.getId())) continue;
            return evidenceRecord;
        }
        return null;
    }

    public List<CertificateWrapper> getUsedCertificates() {
        if (this.usedCertificates == null) {
            this.usedCertificates = new ArrayList<CertificateWrapper>();
            List<XmlCertificate> xmlCertificates = this.wrapped.getUsedCertificates();
            if (xmlCertificates != null) {
                for (XmlCertificate certificate : xmlCertificates) {
                    this.usedCertificates.add(new CertificateWrapper(certificate));
                }
            }
        }
        return this.usedCertificates;
    }

    public Set<SignatureWrapper> getAllSignatures() {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (signatureWrapper.getParent() != null) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<SignatureWrapper> getAllCounterSignatures() {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (signatureWrapper.getParent() == null) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<SignatureWrapper> getAllCounterSignaturesForMasterSignature(SignatureWrapper masterSignatureWrapper) {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (signatureWrapper.getParent() == null || !signatureWrapper.getParent().equals(masterSignatureWrapper)) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<RevocationWrapper> getAllRevocationData() {
        HashSet<RevocationWrapper> revocationData = new HashSet<RevocationWrapper>();
        for (XmlRevocation xmlRevocation : this.wrapped.getUsedRevocations()) {
            revocationData.add(new RevocationWrapper(xmlRevocation));
        }
        return revocationData;
    }

    public CertificateRevocationWrapper getLatestRevocationDataForCertificate(CertificateWrapper certificate) {
        RevocationWrapper latest = null;
        List<CertificateRevocationWrapper> certificateRevocationData = certificate.getCertificateRevocationData();
        for (CertificateRevocationWrapper certRevoc : certificateRevocationData) {
            if (latest != null && (latest.getProductionDate() == null || certRevoc == null || certRevoc.getProductionDate() == null || !latest.getProductionDate().before(certRevoc.getProductionDate()))) continue;
            latest = certRevoc;
        }
        return latest;
    }

    public CertificateWrapper getCertificateById(String id) {
        for (CertificateWrapper certificateWrapper : this.getUsedCertificates()) {
            if (!id.equals(certificateWrapper.getId())) continue;
            return certificateWrapper;
        }
        return null;
    }

    public RevocationWrapper getRevocationById(String id) {
        for (RevocationWrapper revocationWrapper : this.getAllRevocationData()) {
            if (!id.equals(revocationWrapper.getId())) continue;
            return revocationWrapper;
        }
        return null;
    }

    public List<SignerDataWrapper> getOriginalSignerDocuments() {
        ArrayList<SignerDataWrapper> signerDocuments = new ArrayList<SignerDataWrapper>();
        for (SignatureWrapper signatureWrapper : this.getSignatures()) {
            for (XmlSignatureScope signatureScope : signatureWrapper.getSignatureScopes()) {
                SignerDataWrapper wrappedSignedData;
                XmlSignerData signerData = signatureScope.getSignerData();
                if (signerData == null || signerDocuments.contains(wrappedSignedData = new SignerDataWrapper(signerData))) continue;
                signerDocuments.add(wrappedSignedData);
            }
        }
        return signerDocuments;
    }

    public List<SignerDataWrapper> getAllSignerDocuments() {
        ArrayList<SignerDataWrapper> signerDocuments = new ArrayList<SignerDataWrapper>();
        for (XmlSignerData signerData : this.wrapped.getOriginalDocuments()) {
            signerDocuments.add(new SignerDataWrapper(signerData));
        }
        return signerDocuments;
    }

    public XmlDiagnosticData getJaxbModel() {
        return this.wrapped;
    }

    public boolean isContainerInfoPresent() {
        return this.wrapped.getContainerInfo() != null;
    }

    public ASiCContainerType getContainerType() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getContainerType();
        }
        return null;
    }

    public String getZipComment() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getZipComment();
        }
        return null;
    }

    public boolean isMimetypeFilePresent() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.isMimeTypeFilePresent();
        }
        return false;
    }

    public String getMimetypeFileContent() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getMimeTypeContent();
        }
        return null;
    }

    public XmlContainerInfo getContainerInfo() {
        return this.wrapped.getContainerInfo();
    }

    public boolean isPDFAValidationPerformed() {
        return this.wrapped.getPDFAInfo() != null;
    }

    public String getPDFAProfileId() {
        if (this.wrapped.getPDFAInfo() != null) {
            return this.wrapped.getPDFAInfo().getProfileId();
        }
        return null;
    }

    public boolean isPDFACompliant() {
        if (this.wrapped.getPDFAInfo() != null) {
            return this.wrapped.getPDFAInfo().isCompliant();
        }
        return false;
    }

    public Collection<String> getPDFAValidationErrors() {
        if (this.wrapped.getPDFAInfo() != null) {
            return this.wrapped.getPDFAInfo().getValidationMessages();
        }
        return Collections.emptyList();
    }

    public List<XmlTrustedList> getTrustedLists() {
        ArrayList<XmlTrustedList> result = new ArrayList<XmlTrustedList>();
        List<XmlTrustedList> trustedLists = this.wrapped.getTrustedLists();
        for (XmlTrustedList xmlTrustedList : trustedLists) {
            if (xmlTrustedList.isLOTL()) continue;
            result.add(xmlTrustedList);
        }
        return result;
    }

    public List<XmlTrustedList> getListOfTrustedLists() {
        ArrayList<XmlTrustedList> result = new ArrayList<XmlTrustedList>();
        List<XmlTrustedList> trustedLists = this.wrapped.getTrustedLists();
        for (XmlTrustedList xmlTrustedList : trustedLists) {
            if (!xmlTrustedList.isLOTL()) continue;
            result.add(xmlTrustedList);
        }
        return result;
    }

    public Date getValidationDate() {
        return this.wrapped.getValidationDate();
    }
}

