/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature.resources;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.signature.resources.AbstractResourcesHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class InMemoryResourcesHandler
extends AbstractResourcesHandler {
    @Override
    protected ByteArrayOutputStream buildOutputStream() {
        return new ByteArrayOutputStream();
    }

    @Override
    public DSSDocument writeToDSSDocument() throws IOException {
        try (OutputStream os = this.getOutputStream();){
            if (!(os instanceof ByteArrayOutputStream)) {
                throw new IllegalStateException("The OutputStream shall be an implementation of ByteArrayOutputStream class!");
            }
            InMemoryDocument inMemoryDocument = new InMemoryDocument(((ByteArrayOutputStream)os).toByteArray());
            return inMemoryDocument;
        }
    }
}

