/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class TimestampTokenComparator
implements Comparator<TimestampToken>,
Serializable {
    private static final long serialVersionUID = 3404578959761631884L;

    @Override
    public int compare(TimestampToken tst1, TimestampToken tst2) {
        int result = this.compareByGenerationTime(tst1, tst2);
        if (result == 0) {
            result = this.compareByTokenType(tst1, tst2);
        }
        if (result == 0) {
            result = this.compareByManifest(tst1, tst2);
        }
        if (result == 0) {
            result = this.compareByCoverage(tst1, tst2);
        }
        if (result == 0) {
            result = this.compareByTimestampedReferences(tst1, tst2);
        }
        return result;
    }

    private int compareByGenerationTime(TimestampToken tst1, TimestampToken tst2) {
        return tst1.getGenerationTime().compareTo(tst2.getGenerationTime());
    }

    private int compareByTokenType(TimestampToken tst1, TimestampToken tst2) {
        TimestampType tst1Type = tst1.getTimeStampType();
        TimestampType tst2Type = tst2.getTimeStampType();
        return tst1Type.compare(tst2Type);
    }

    private int compareByManifest(TimestampToken tst1, TimestampToken tst2) {
        ManifestFile tst1ManifestFile = tst1.getManifestFile();
        ManifestFile tst2ManifestFile = tst2.getManifestFile();
        if (tst1ManifestFile != null && tst1ManifestFile.isDocumentCovered(tst2.getFileName())) {
            return 1;
        }
        if (tst2ManifestFile != null && tst2ManifestFile.isDocumentCovered(tst1.getFileName())) {
            return -1;
        }
        return 0;
    }

    private int compareByCoverage(TimestampToken tst1, TimestampToken tst2) {
        if (this.isCoveredByTimestamp(tst1, tst2)) {
            return -1;
        }
        if (this.isCoveredByTimestamp(tst2, tst1)) {
            return 1;
        }
        return 0;
    }

    private boolean isCoveredByTimestamp(TimestampToken tst1, TimestampToken tst2) {
        List<TimestampedReference> tst2References = tst2.getTimestampedReferences();
        for (TimestampedReference timestampedReference : tst2References) {
            if (!tst1.getDSSIdAsString().equals(timestampedReference.getObjectId())) continue;
            return true;
        }
        return false;
    }

    private int compareByTimestampedReferences(TimestampToken tst1, TimestampToken tst2) {
        List<TimestampedReference> tst1References = tst1.getTimestampedReferences();
        List<TimestampedReference> tst2References = tst2.getTimestampedReferences();
        if (tst1References != null && tst2References != null) {
            if (tst1References.size() < tst2References.size()) {
                return -1;
            }
            if (tst1References.size() > tst2References.size()) {
                return 1;
            }
        }
        return 0;
    }
}

