/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.OriginalIdentifierProvider;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.SignedDocumentDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecordValidator;
import eu.europa.esig.dss.validation.executor.DocumentProcessExecutor;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.executor.signature.DefaultSignatureProcessExecutor;
import eu.europa.esig.dss.validation.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.scope.EvidenceRecordScopeFinder;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected DocumentProcessExecutor processExecutor = null;
    protected DSSDocument document;
    protected List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    protected List<DSSDocument> detachedEvidenceRecordDocuments = new ArrayList<DSSDocument>();
    protected List<DSSDocument> containerContents;
    protected ManifestFile manifestFile;
    protected CertificateSource signingCertificateSource;
    private Date validationTime;
    protected CertificateVerifier certificateVerifier;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private TokenIdentifierProvider tokenIdentifierProvider = new OriginalIdentifierProvider();
    private boolean includeSemantics = false;
    private SignaturePolicyProvider signaturePolicyProvider;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private Locale locale = Locale.getDefault();
    private boolean enableEtsiValidationReport = true;
    protected boolean skipValidationContextExecution = false;
    private List<AdvancedSignature> signatures;
    private List<TimestampToken> detachedTimestamps;
    private List<EvidenceRecord> evidenceRecords;

    protected SignedDocumentValidator() {
    }

    @Deprecated
    protected SignedDocumentValidator(SignatureScopeFinder<?> signatureScopeFinder) {
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentValidatorFactory> serviceLoaders = ServiceLoader.load(DocumentValidatorFactory.class);
        for (DocumentValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    public abstract boolean isSupported(DSSDocument var1);

    @Override
    public void setSigningCertificateSource(CertificateSource signingCertificateSource) {
        this.signingCertificateSource = signingCertificateSource;
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    protected TokenIdentifierProvider getTokenIdentifierProvider() {
        return this.tokenIdentifierProvider;
    }

    @Override
    public void setTokenIdentifierProvider(TokenIdentifierProvider tokenIdentifierProvider) {
        Objects.requireNonNull(tokenIdentifierProvider);
        this.tokenIdentifierProvider = tokenIdentifierProvider;
    }

    @Override
    public void setIncludeSemantics(boolean include) {
        this.includeSemantics = include;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public void setDetachedEvidenceRecordDocuments(List<DSSDocument> detachedEvidenceRecordDocuments) {
        this.detachedEvidenceRecordDocuments = detachedEvidenceRecordDocuments;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    protected DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.certificateVerifier.getDefaultDigestAlgorithm();
    }

    @Override
    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    protected Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((InputStream)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        Reports reports;
        block9: {
            if (validationPolicyURL == null) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = validationPolicyURL.openStream();
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy with URL '%s'. Reason : %s", validationPolicyURL, e.getMessage()), e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        Reports reports;
        block9: {
            if (policyResourcePath == null) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = this.getClass().getResourceAsStream(policyResourcePath);
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy from path '%s'. Reason : %s", policyResourcePath, e.getMessage()), e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(File policyFile) {
        Reports reports;
        block9: {
            if (policyFile == null || !policyFile.exists()) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = DSSUtils.toByteArrayInputStream((File)policyFile);
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy from file '%s'. Reason : %s", policyFile, e.getMessage()), e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(DSSDocument policyDocument) {
        Reports reports;
        block8: {
            InputStream is = policyDocument.openStream();
            try {
                reports = this.validateDocument(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException(String.format("Unable to read policy file: %s", e.getMessage()), (Throwable)e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        ValidationPolicy validationPolicy;
        try {
            if (policyDataStream == null) {
                LOG.debug("No provided validation policy : use the default policy");
                validationPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
            } else {
                validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(policyDataStream);
            }
        }
        catch (Exception e) {
            throw new IllegalInputException("Unable to load the policy", e);
        }
        return this.validateDocument(validationPolicy);
    }

    @Override
    public Reports validateDocument(ConstraintsParameters validationPolicyJaxb) {
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validateDocument((ValidationPolicy)validationPolicy);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        this.assertConfigurationValid();
        XmlDiagnosticData diagnosticData = this.getDiagnosticData();
        return this.processValidationPolicy(diagnosticData, validationPolicy);
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "Document is not provided to the validator");
    }

    public final XmlDiagnosticData getDiagnosticData() {
        return this.prepareDiagnosticDataBuilder().build();
    }

    protected DiagnosticDataBuilder prepareDiagnosticDataBuilder() {
        List<AdvancedSignature> allSignatures = this.getAllSignatures();
        List<TimestampToken> detachedTimestamps = this.getDetachedTimestamps();
        List<EvidenceRecord> detachedEvidenceRecords = this.getDetachedEvidenceRecords();
        CertificateVerifier certificateVerifierForValidation = new CertificateVerifierBuilder(this.certificateVerifier).buildCompleteCopyForValidation();
        ValidationContext validationContext = this.prepareValidationContext(allSignatures, detachedTimestamps, detachedEvidenceRecords, certificateVerifierForValidation);
        if (!this.skipValidationContextExecution) {
            this.validateContext(validationContext);
        }
        return this.createDiagnosticDataBuilder(validationContext, allSignatures, detachedEvidenceRecords);
    }

    @Deprecated
    protected <T extends AdvancedSignature> ValidationContext prepareValidationContext(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps, CertificateVerifier certificateVerifier) {
        return this.prepareValidationContext(signatures, detachedTimestamps, Collections.emptyList(), certificateVerifier);
    }

    protected <T extends AdvancedSignature> ValidationContext prepareValidationContext(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps, Collection<EvidenceRecord> detachedEvidenceRecords, CertificateVerifier certificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(certificateVerifier);
        this.prepareSignatureValidationContext(validationContext, signatures);
        this.prepareDetachedTimestampValidationContext(validationContext, detachedTimestamps);
        this.prepareDetachedEvidenceRecordValidationContext(validationContext, detachedEvidenceRecords);
        return validationContext;
    }

    protected SignedDocumentDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new SignedDocumentDiagnosticDataBuilder();
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures) {
        return this.getValidationData(signatures, Collections.emptyList());
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        if (Utils.isCollectionEmpty(signatures) && Utils.isCollectionEmpty(detachedTimestamps)) {
            throw new DSSException("At least one signature or a timestamp shall be provided to extract the validation data!");
        }
        ValidationContext validationContext = this.prepareValidationContext(signatures, detachedTimestamps, this.certificateVerifier);
        this.validateContext(validationContext);
        this.assertSignaturesValid(signatures, validationContext);
        ValidationDataContainer validationDataContainer = this.instantiateValidationDataContainer();
        for (AdvancedSignature signature : signatures) {
            ValidationData signatureValidationData = validationContext.getValidationData(signature);
            validationDataContainer.addValidationData(signature, signatureValidationData);
            for (TimestampToken timestampToken : signature.getAllTimestamps()) {
                ValidationData timestampValidationData = validationContext.getValidationData(timestampToken);
                validationDataContainer.addValidationData(timestampToken, timestampValidationData);
            }
            for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
                ValidationData counterSignatureValidationData = validationContext.getValidationData(counterSignature);
                validationDataContainer.addValidationData(counterSignature, counterSignatureValidationData);
            }
        }
        for (TimestampToken detachedTimestamp : detachedTimestamps) {
            ValidationData timestampValidationData = validationContext.getValidationData(detachedTimestamp);
            validationDataContainer.addValidationData(detachedTimestamp, timestampValidationData);
        }
        return validationDataContainer;
    }

    protected ValidationDataContainer instantiateValidationDataContainer() {
        return new ValidationDataContainer();
    }

    private <T extends AdvancedSignature> void assertSignaturesValid(Collection<T> signatures, ValidationContext validationContext) {
        validationContext.checkAllTimestampsValid();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkAllPOECoveredByRevocationData();
        for (AdvancedSignature signature : signatures) {
            validationContext.checkSignatureNotExpired(signature);
            validationContext.checkCertificatesNotRevoked(signature);
            validationContext.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signature);
        }
    }

    @Deprecated
    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext, List<AdvancedSignature> signatures) {
        return this.createDiagnosticDataBuilder(validationContext, signatures, Collections.emptyList());
    }

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext, List<AdvancedSignature> signatures, List<EvidenceRecord> detachedEvidenceRecords) {
        return ((SignedDocumentDiagnosticDataBuilder)((SignedDocumentDiagnosticDataBuilder)this.initializeDiagnosticDataBuilder().document(this.document).foundSignatures(signatures).usedTimestamps(validationContext.getProcessedTimestamps()).foundEvidenceRecords(this.getAllEvidenceRecords(signatures, detachedEvidenceRecords)).allCertificateSources(validationContext.getAllCertificateSources()).documentCertificateSource(validationContext.getDocumentCertificateSource()).documentCRLSource(validationContext.getDocumentCRLSource()).documentOCSPSource(validationContext.getDocumentOCSPSource()).signaturePolicyProvider(this.getSignaturePolicyProvider()).signaturePolicyValidatorLoader(this.getSignaturePolicyValidatorLoader()).usedCertificates((Set)validationContext.getProcessedCertificates())).usedRevocations((Set)validationContext.getProcessedRevocations())).defaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm()).tokenExtractionStrategy(this.tokenExtractionStrategy).tokenIdentifierProvider(this.tokenIdentifierProvider).validationDate(this.getValidationTime());
    }

    private List<EvidenceRecord> getAllEvidenceRecords(List<AdvancedSignature> signatures, List<EvidenceRecord> detachedEvidenceRecords) {
        ArrayList<EvidenceRecord> result = new ArrayList<EvidenceRecord>();
        for (AdvancedSignature signature : signatures) {
            result.addAll(signature.getEmbeddedEvidenceRecords());
        }
        result.addAll(detachedEvidenceRecords);
        return result;
    }

    protected <T extends AdvancedSignature> void prepareSignatureValidationContext(ValidationContext validationContext, Collection<T> allSignatures) {
        this.prepareSignatureForVerification(validationContext, allSignatures);
        this.processSignaturesValidation(allSignatures);
    }

    protected <T extends AdvancedSignature> void prepareSignatureForVerification(ValidationContext validationContext, Collection<T> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            validationContext.addSignatureForVerification(signature);
        }
    }

    protected void prepareDetachedTimestampValidationContext(ValidationContext validationContext, Collection<TimestampToken> timestamps) {
        for (TimestampToken timestampToken : timestamps) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    protected void prepareDetachedEvidenceRecordValidationContext(ValidationContext validationContext, Collection<EvidenceRecord> evidenceRecords) {
        for (EvidenceRecord evidenceRecord : evidenceRecords) {
            validationContext.addEvidenceRecordForVerification(evidenceRecord);
        }
    }

    protected void validateContext(ValidationContext validationContext) {
        validationContext.validate();
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    protected SignaturePolicyProvider getSignaturePolicyProvider() {
        if (this.signaturePolicyProvider == null) {
            LOG.info("Default SignaturePolicyProvider instantiated with NativeHTTPDataLoader.");
            this.signaturePolicyProvider = new SignaturePolicyProvider();
            this.signaturePolicyProvider.setDataLoader((DataLoader)new NativeHTTPDataLoader());
        }
        return this.signaturePolicyProvider;
    }

    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        return new DefaultSignaturePolicyValidatorLoader();
    }

    @Override
    public void setProcessExecutor(DocumentProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    protected DocumentProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public DocumentProcessExecutor getDefaultProcessExecutor() {
        return new DefaultSignatureProcessExecutor();
    }

    protected final Reports processValidationPolicy(XmlDiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        DocumentProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        executor.setIncludeSemantics(this.includeSemantics);
        executor.setEnableEtsiValidationReport(this.enableEtsiValidationReport);
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (Reports)executor.execute();
    }

    protected List<AdvancedSignature> getAllSignatures() {
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : this.getSignatures()) {
            allSignatureList.add(signature);
            this.appendCounterSignatures(allSignatureList, signature);
        }
        this.appendExternalEvidenceRecords(allSignatureList);
        return allSignatureList;
    }

    protected void appendCounterSignatures(List<AdvancedSignature> allSignatureList, AdvancedSignature signature) {
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            counterSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
            allSignatureList.add(counterSignature);
            this.appendCounterSignatures(allSignatureList, counterSignature);
        }
    }

    protected void appendExternalEvidenceRecords(List<AdvancedSignature> allSignatureList) {
        List<EvidenceRecord> detachedEvidenceRecords = this.getDetachedEvidenceRecords();
        if (Utils.isCollectionNotEmpty(detachedEvidenceRecords) && Utils.isCollectionNotEmpty(allSignatureList)) {
            for (AdvancedSignature signature : allSignatureList) {
                for (EvidenceRecord evidenceRecord : detachedEvidenceRecords) {
                    if (!this.coversSignature(signature, evidenceRecord)) continue;
                    signature.addExternalEvidenceRecord(evidenceRecord);
                }
            }
        }
    }

    protected boolean coversSignature(AdvancedSignature signature, EvidenceRecord evidenceRecord) {
        return true;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures == null) {
            this.signatures = this.buildSignatures();
        }
        return this.signatures;
    }

    protected List<AdvancedSignature> buildSignatures() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        if (this.detachedTimestamps == null) {
            this.detachedTimestamps = this.buildDetachedTimestamps();
        }
        return this.detachedTimestamps;
    }

    protected List<TimestampToken> buildDetachedTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        if (this.evidenceRecords == null) {
            this.evidenceRecords = this.buildDetachedEvidenceRecords();
        }
        return this.evidenceRecords;
    }

    protected List<EvidenceRecord> buildDetachedEvidenceRecords() {
        if (Utils.isCollectionNotEmpty(this.detachedEvidenceRecordDocuments)) {
            ArrayList<EvidenceRecord> result = new ArrayList<EvidenceRecord>();
            for (DSSDocument evidenceRecordDocument : this.detachedEvidenceRecordDocuments) {
                EvidenceRecord evidenceRecord = this.buildEvidenceRecord(evidenceRecordDocument);
                if (evidenceRecord == null) continue;
                result.add(evidenceRecord);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected EvidenceRecord buildEvidenceRecord(DSSDocument evidenceRecordDocument) {
        try {
            try {
                EvidenceRecordValidator evidenceRecordValidator = EvidenceRecordValidator.fromDocument(evidenceRecordDocument);
                evidenceRecordValidator.setDetachedContents(this.getSignatureEvidenceRecordDetachedContents());
                evidenceRecordValidator.setCertificateVerifier(this.certificateVerifier);
                return this.getEvidenceRecord(evidenceRecordValidator);
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("An error occurred on attempt to read an evidence record document with name '{}' : {}Please ensure the corresponding module is loaded.", (Object)evidenceRecordDocument.getName(), (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred on attempt to read an evidence record document with name '{}' : {}", new Object[]{evidenceRecordDocument.getName(), e.getMessage(), e});
        }
        return null;
    }

    private List<DSSDocument> getSignatureEvidenceRecordDetachedContents() {
        ArrayList<DSSDocument> erDetachedContents = new ArrayList<DSSDocument>();
        erDetachedContents.add(this.document);
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            erDetachedContents.addAll(this.detachedContents);
        }
        return erDetachedContents;
    }

    protected EvidenceRecord getEvidenceRecord(EvidenceRecordValidator evidenceRecordValidator) {
        EvidenceRecord evidenceRecord = evidenceRecordValidator.getEvidenceRecord();
        if (evidenceRecord != null) {
            List<SignatureScope> evidenceRecordScopes = this.getEvidenceRecordScopes(evidenceRecord);
            evidenceRecord.setEvidenceRecordScopes(evidenceRecordScopes);
            evidenceRecord.setTimestampedReferences(this.getTimestampedReferences(evidenceRecordScopes));
            return evidenceRecord;
        }
        return null;
    }

    protected List<SignatureScope> getEvidenceRecordScopes(EvidenceRecord evidenceRecord) {
        return new EvidenceRecordScopeFinder(evidenceRecord).findEvidenceRecordScope();
    }

    @Override
    public <T extends AdvancedSignature> void processSignaturesValidation(Collection<T> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            signature.checkSignatureIntegrity();
        }
    }

    @Override
    @Deprecated
    public <T extends AdvancedSignature> void findSignatureScopes(Collection<T> currentValidatorSignatures) {
        LOG.warn("Use of deprecated method! Use eu.europa.esig.dss.validation.AdvancedSignature.getSignatureScopes() method instead.");
    }

    protected List<TimestampedReference> getTimestampedReferences(List<SignatureScope> signatureScopes) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (SignatureScope signatureScope : signatureScopes) {
                if (!this.addReference(signatureScope)) continue;
                timestampedReferences.add(new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return timestampedReferences;
    }

    protected boolean addReference(SignatureScope signatureScope) {
        return true;
    }

    public void setSkipValidationContextExecution(boolean skipValidationContextExecution) {
        this.skipValidationContextExecution = skipValidationContextExecution;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        AdvancedSignature advancedSignature = this.getSignatureById(signatureId);
        if (advancedSignature != null) {
            return this.getOriginalDocuments(advancedSignature);
        }
        return Collections.emptyList();
    }

    public AdvancedSignature getSignatureById(String signatureId) {
        Objects.requireNonNull(signatureId, "Signature Id cannot be null!");
        for (AdvancedSignature advancedSignature : this.getSignatures()) {
            AdvancedSignature signature = this.findSignatureRecursively(advancedSignature, signatureId);
            if (signature == null) continue;
            return signature;
        }
        return null;
    }

    private AdvancedSignature findSignatureRecursively(AdvancedSignature signature, String signatureId) {
        if (this.doesIdMatch(signature, signatureId)) {
            return signature;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            AdvancedSignature advancedSignature = this.findSignatureRecursively(counterSignature, signatureId);
            if (advancedSignature == null) continue;
            return advancedSignature;
        }
        return null;
    }

    private boolean doesIdMatch(AdvancedSignature signature, String signatureId) {
        return signatureId.equals(signature.getId()) || signatureId.equals(signature.getDAIdentifier()) || signatureId.equals(this.tokenIdentifierProvider.getIdAsString((IdentifierBasedObject)signature));
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

