/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import java.util.List;

public enum AdditionalServiceInformation {
    FOR_ESIGNATURES("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures"),
    FOR_ESEALS("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals"),
    FOR_WEB_AUTHENTICATION("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication");

    private final String uri;

    private AdditionalServiceInformation(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static AdditionalServiceInformation getByUri(String uri) {
        if (uri != null) {
            for (AdditionalServiceInformation serviceQualification : AdditionalServiceInformation.values()) {
                if (!uri.equals(serviceQualification.getUri())) continue;
                return serviceQualification;
            }
        }
        return null;
    }

    public static boolean isForeSignatures(String additionalServiceInfo) {
        return FOR_ESIGNATURES.getUri().equals(additionalServiceInfo);
    }

    public static boolean isForeSeals(String additionalServiceInfo) {
        return FOR_ESEALS.getUri().equals(additionalServiceInfo);
    }

    public static boolean isForWebAuth(String additionalServiceInfo) {
        return FOR_WEB_AUTHENTICATION.getUri().equals(additionalServiceInfo);
    }

    public static boolean isForeSignatures(List<String> additionalServiceInfos) {
        return additionalServiceInfos.contains(FOR_ESIGNATURES.getUri());
    }

    public static boolean isForeSeals(List<String> additionalServiceInfos) {
        return additionalServiceInfos.contains(FOR_ESEALS.getUri());
    }

    public static boolean isForWebAuth(List<String> additionalServiceInfos) {
        return additionalServiceInfos.contains(FOR_WEB_AUTHENTICATION.getUri());
    }

    public static boolean isForeSignaturesOnly(List<String> additionalServiceInfos) {
        return additionalServiceInfos != null && additionalServiceInfos.size() == 1 && AdditionalServiceInformation.isForeSignatures(additionalServiceInfos);
    }

    public static boolean isForeSealsOnly(List<String> additionalServiceInfos) {
        return additionalServiceInfos != null && additionalServiceInfos.size() == 1 && AdditionalServiceInformation.isForeSeals(additionalServiceInfos);
    }

    public static boolean isForWebAuthOnly(List<String> additionalServiceInfos) {
        return additionalServiceInfos != null && additionalServiceInfos.size() == 1 && AdditionalServiceInformation.isForWebAuth(additionalServiceInfos);
    }
}

