/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidDescription;

public enum CertificateExtensionEnum implements OidDescription
{
    AUTHORITY_KEY_IDENTIFIER("authorityKeyIdentifier", "2.5.29.35"),
    SUBJECT_KEY_IDENTIFIER("subjectKeyIdentifier", "2.5.29.14"),
    KEY_USAGE("keyUsage", "2.5.29.15"),
    PRIVATE_KEY_USAGE_PERIOD("privateKeyUsagePeriod", "2.5.29.16"),
    CERTIFICATE_POLICIES("certificatePolicies", "2.5.29.32"),
    POLICY_MAPPINGS("policyMappings", "2.5.29.33"),
    SUBJECT_ALTERNATIVE_NAME("subjectAlternativeName", "2.5.29.17"),
    ISSUER_ALTERNATIVE_NAME("issuerAlternativeName", "2.5.29.18"),
    SUBJECT_DIRECTORY_ATTRIBUTES("subjectDirectoryAttributes", "2.5.29.9"),
    BASIC_CONSTRAINTS("basicConstraints", "2.5.29.19"),
    NAME_CONSTRAINTS("nameConstraints", "2.5.29.30"),
    POLICY_CONSTRAINTS("policyConstraints", "2.5.29.36"),
    EXTENDED_KEY_USAGE("extendedKeyUsage", "2.5.29.37"),
    CRL_DISTRIBUTION_POINTS("CRLDistributionPoints", "2.5.29.31"),
    INHIBIT_ANY_POLICY("inhibitAnyPolicy", "2.5.29.54"),
    FRESHEST_CRL("freshestCRL", "2.5.29.46"),
    AUTHORITY_INFORMATION_ACCESS("authorityInfoAccess", "1.3.6.1.5.5.7.1.1"),
    SUBJECT_INFORMATION_ACCESS("subjectInfoAccess", "1.3.6.1.5.5.7.1.11"),
    OCSP_NOCHECK("id_pkix_ocsp_nocheck", "1.3.6.1.5.5.7.48.1.5"),
    VALIDITY_ASSURED_SHORT_TERM("id_etsi_ext_valassured_ST_certs", "0.4.0.194121.2.1"),
    BIOMETRIC_INFORMATION("biometricInfo", "1.3.6.1.5.5.7.1.2"),
    QC_STATEMENTS("QCStatements", "1.3.6.1.5.5.7.1.3"),
    NO_REVOCATION_AVAILABLE("noRevAvail", "2.5.29.56");

    private final String description;
    private final String oid;

    private CertificateExtensionEnum(String description, String oid) {
        this.description = description;
        this.oid = oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    public static CertificateExtensionEnum forOid(String oid) {
        for (CertificateExtensionEnum value : CertificateExtensionEnum.values()) {
            if (!oid.equals(value.oid)) continue;
            return value;
        }
        return null;
    }
}

