/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import java.util.Objects;

public enum EvidenceRecordTypeEnum {
    XML_EVIDENCE_RECORD("XML Evidence Record"),
    ASN1_EVIDENCE_RECORD("ASN.1 Evidence Record");

    private final String label;

    private EvidenceRecordTypeEnum(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public static EvidenceRecordTypeEnum fromLabel(String label) {
        Objects.requireNonNull(label, "Label cannot be null!");
        for (EvidenceRecordTypeEnum evidenceRecordEnum : EvidenceRecordTypeEnum.values()) {
            if (!label.equals(evidenceRecordEnum.label)) continue;
            return evidenceRecordEnum;
        }
        throw new UnsupportedOperationException(String.format("Evidence record of type '%s' is not supported!", label));
    }
}

