/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.MimeTypeLoader;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import java.util.ServiceLoader;

public interface MimeType
extends Serializable {
    public String getMimeTypeString();

    public String getExtension();

    public static MimeType fromMimeTypeString(String mimeTypeString) {
        Objects.requireNonNull(mimeTypeString, "The mimeTypeString cannot be null!");
        for (MimeTypeLoader mimeTypeLoader : MimeType.mimeTypeLoaders()) {
            MimeType mimeType = mimeTypeLoader.fromMimeTypeString(mimeTypeString);
            if (mimeType == null) continue;
            return mimeType;
        }
        return MimeTypeEnum.BINARY;
    }

    public static MimeType fromFileExtension(String fileExtension) {
        for (MimeTypeLoader mimeTypeLoader : MimeType.mimeTypeLoaders()) {
            MimeType mimeType = mimeTypeLoader.fromFileExtension(fileExtension);
            if (mimeType == null) continue;
            return mimeType;
        }
        return MimeTypeEnum.BINARY;
    }

    public static MimeType fromFileName(String fileName) {
        String fileExtension = MimeType.getFileExtension(fileName);
        if (fileExtension != null) {
            String lowerCaseExtension = fileExtension.toLowerCase();
            return MimeType.fromFileExtension(lowerCaseExtension);
        }
        return MimeTypeEnum.BINARY;
    }

    public static MimeType fromFile(File file) {
        Objects.requireNonNull(file, "The file cannot be null!");
        String fileName = file.getName();
        return MimeType.fromFileName(fileName);
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.trim().isEmpty()) {
            return null;
        }
        String extension = "";
        int lastIndexOf = fileName.lastIndexOf(46);
        if (lastIndexOf > 0) {
            extension = fileName.substring(lastIndexOf + 1);
        }
        return extension;
    }

    public static Iterable<MimeTypeLoader> mimeTypeLoaders() {
        return ServiceLoader.load(MimeTypeLoader.class);
    }
}

