/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.SignatureForm;

public enum SignatureLevel {
    XML_NOT_ETSI,
    XAdES_BES,
    XAdES_EPES,
    XAdES_T,
    XAdES_LT,
    XAdES_C,
    XAdES_X,
    XAdES_XL,
    XAdES_A,
    XAdES_ERS,
    XAdES_BASELINE_B,
    XAdES_BASELINE_T,
    XAdES_BASELINE_LT,
    XAdES_BASELINE_LTA,
    CMS_NOT_ETSI,
    CAdES_BES,
    CAdES_EPES,
    CAdES_T,
    CAdES_LT,
    CAdES_C,
    CAdES_X,
    CAdES_XL,
    CAdES_A,
    CAdES_ERS,
    CAdES_BASELINE_B,
    CAdES_BASELINE_T,
    CAdES_BASELINE_LT,
    CAdES_BASELINE_LTA,
    PDF_NOT_ETSI,
    PKCS7_B,
    PKCS7_T,
    PKCS7_LT,
    PKCS7_LTA,
    PAdES_BES,
    PAdES_EPES,
    PAdES_LTV,
    PAdES_BASELINE_B,
    PAdES_BASELINE_T,
    PAdES_BASELINE_LT,
    PAdES_BASELINE_LTA,
    JSON_NOT_ETSI,
    JAdES_BASELINE_B,
    JAdES_BASELINE_T,
    JAdES_BASELINE_LT,
    JAdES_BASELINE_LTA,
    UNKNOWN;


    public static SignatureLevel valueByName(String name) {
        return SignatureLevel.valueOf(name.replace('-', '_'));
    }

    public String toString() {
        return super.toString().replace('_', '-');
    }

    public SignatureForm getSignatureForm() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return SignatureForm.XAdES;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return SignatureForm.CAdES;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return SignatureForm.JAdES;
            }
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return SignatureForm.PAdES;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return SignatureForm.PKCS7;
            }
        }
        throw new UnsupportedOperationException(String.format("The signature level '%s' is not supported!", new Object[]{this}));
    }
}

