/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.jose4j.jwx.CompactSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWSCompactSerializationParser {
    private static final Logger LOG = LoggerFactory.getLogger(JWSCompactSerializationParser.class);
    private static final int NUMBER_DOTS = 2;
    private static final byte DOT_CHARACTER = 46;
    private final DSSDocument document;

    public JWSCompactSerializationParser(DSSDocument document) {
        this.document = document;
    }

    public JWS parse() {
        try (Scanner scanner = new Scanner(this.document.openStream(), StandardCharsets.UTF_8.name());){
            String compactSerialization = scanner.nextLine();
            String[] parts = CompactSerializer.deserialize((String)compactSerialization);
            JWS jWS = new JWS(parts);
            return jWS;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSupported() {
        if (!DSSJsonUtils.isAllowedSignatureDocumentType(this.document)) {
            return false;
        }
        int separatorCounter = 0;
        boolean ending = false;
        try (InputStream is = this.document.openStream();){
            int b;
            while ((b = is.read()) != -1) {
                byte currentByte = (byte)b;
                if (DSSUtils.isLineBreakByte((byte)currentByte)) {
                    ending = true;
                    continue;
                }
                if (ending) {
                    boolean bl = false;
                    return bl;
                }
                if (currentByte == 46) {
                    if (++separatorCounter <= 2) continue;
                    boolean bl = false;
                    return bl;
                }
                if (DSSJsonUtils.isBase64UrlEncoded(currentByte) || separatorCounter == 1 && DSSJsonUtils.isUrlSafe(currentByte)) continue;
                boolean bl = false;
                return bl;
            }
            if (separatorCounter != 2) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot read the document. Reason : %s", e.getMessage()), (Throwable)e);
        }
        if (!ending) return true;
        LOG.warn("Line break characters found within the JWS Compact Serialization signature document!");
        return true;
    }
}

