/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWSJsonSerializationGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JWSJsonSerializationGenerator.class);
    private final JWSJsonSerializationObject jwsJsonSerializationObject;
    private final JWSSerializationType output;

    public JWSJsonSerializationGenerator(JWSJsonSerializationObject jwsJsonSerializationObject, JWSSerializationType output) {
        this.jwsJsonSerializationObject = jwsJsonSerializationObject;
        this.output = output;
    }

    public DSSDocument generate() {
        JsonObject jsonSerialization;
        switch (this.output) {
            case JSON_SERIALIZATION: {
                jsonSerialization = this.buildJWSJsonSerialization();
                break;
            }
            case FLATTENED_JSON_SERIALIZATION: {
                jsonSerialization = this.buildFlattenedJwsJsonSerialization();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The JWSJsonSerializationGenerator does not support the given JWS Serialization Type '%s'", this.output));
            }
        }
        byte[] binaries = jsonSerialization.toJSONString().getBytes(StandardCharsets.UTF_8);
        return new InMemoryDocument(binaries);
    }

    private JsonObject buildJWSJsonSerialization() {
        if (JWSSerializationType.FLATTENED_JSON_SERIALIZATION.equals((Object)this.jwsJsonSerializationObject.getJWSSerializationType())) {
            LOG.warn("A flattened signature will be transformed to a Complete JWS JSON Serialization Format!");
        }
        LinkedHashMap<String, Object> jsonSerializationMap = new LinkedHashMap<String, Object>();
        String payload = this.jwsJsonSerializationObject.getPayload();
        if (Utils.isStringNotBlank((String)payload)) {
            jsonSerializationMap.put("payload", payload);
        }
        ArrayList<JsonObject> signatureList = new ArrayList<JsonObject>();
        for (JWS signature : this.jwsJsonSerializationObject.getSignatures()) {
            Map<String, Object> signatureMap = this.getSignatureJsonMap(signature);
            signatureList.add(new JsonObject(signatureMap));
        }
        jsonSerializationMap.put("signatures", new JSONArray(signatureList));
        return new JsonObject(jsonSerializationMap);
    }

    private JsonObject buildFlattenedJwsJsonSerialization() {
        List<JWS> signatures;
        LinkedHashMap<String, Object> flattenedJwsMap = new LinkedHashMap<String, Object>();
        String payload = this.jwsJsonSerializationObject.getPayload();
        if (Utils.isStringNotBlank((String)payload)) {
            flattenedJwsMap.put("payload", payload);
        }
        if (Utils.collectionSize(signatures = this.jwsJsonSerializationObject.getSignatures()) != 1) {
            throw new DSSException("JSON Flattened Serialization can only contain 1 signature (current : " + Utils.collectionSize(signatures) + ")");
        }
        JWS jws = signatures.iterator().next();
        Map<String, Object> signatureJsonMap = this.getSignatureJsonMap(jws);
        flattenedJwsMap.putAll(signatureJsonMap);
        return new JsonObject(flattenedJwsMap);
    }

    private Map<String, Object> getSignatureJsonMap(JWS signature) {
        Map<String, Object> unprotected;
        LinkedHashMap<String, Object> signatureMap = new LinkedHashMap<String, Object>();
        String encodedProtected = signature.getEncodedHeader();
        if (Utils.isStringNotBlank((String)encodedProtected)) {
            signatureMap.put("protected", encodedProtected);
        }
        if (Utils.isMapNotEmpty(unprotected = signature.getUnprotected())) {
            signatureMap.put("header", unprotected);
        }
        String encodedSignatureValue = signature.getEncodedSignature();
        signatureMap.put("signature", encodedSignatureValue);
        return signatureMap;
    }
}

