/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.jades.JAdESUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;

public class JWSJsonSerializationParser {
    private final DSSDocument document;

    public JWSJsonSerializationParser(DSSDocument document) {
        this.document = document;
    }

    public JWSJsonSerializationObject parse() {
        try {
            Object signaturesObject;
            Map rootStructure;
            Object payloadObject;
            String jsonDocument = new String(DSSUtils.toByteArray((DSSDocument)this.document));
            JWSJsonSerializationObject jwsJsonSerializationObject = new JWSJsonSerializationObject();
            List<String> structureValidationErrors = this.validateJWSStructure(jsonDocument);
            if (Utils.isCollectionNotEmpty(structureValidationErrors)) {
                jwsJsonSerializationObject.setStructuralValidationErrors(structureValidationErrors);
            }
            if ((payloadObject = (rootStructure = JsonUtil.parseJson((String)jsonDocument)).get("payload")) instanceof String) {
                String payload = (String)payloadObject;
                jwsJsonSerializationObject.setPayload(payload);
            }
            if ((signaturesObject = rootStructure.get("signatures")) != null) {
                jwsJsonSerializationObject.setJWSSerializationType(JWSSerializationType.JSON_SERIALIZATION);
                this.extractSignatures(jwsJsonSerializationObject, signaturesObject);
            } else {
                jwsJsonSerializationObject.setJWSSerializationType(JWSSerializationType.FLATTENED_JSON_SERIALIZATION);
                this.extractAndAddJWSSignature(jwsJsonSerializationObject, rootStructure);
            }
            return jwsJsonSerializationObject;
        }
        catch (JoseException e) {
            throw new IllegalInputException(String.format("Unable to parse document with name '%s'. Reason : %s", this.document.getName(), e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSupported() {
        return DSSJsonUtils.isJsonDocument(this.document);
    }

    private void extractSignatures(JWSJsonSerializationObject jwsJsonSerializationObject, Object signaturesObject) {
        List signaturesObjectList;
        if (signaturesObject instanceof List && Utils.isCollectionNotEmpty((Collection)(signaturesObjectList = (List)signaturesObject))) {
            for (Object signatureObject : signaturesObjectList) {
                if (!(signatureObject instanceof Map)) continue;
                Map signatureMap = (Map)signatureObject;
                this.extractAndAddJWSSignature(jwsJsonSerializationObject, signatureMap);
            }
        }
    }

    private void extractAndAddJWSSignature(JWSJsonSerializationObject jwsJsonSerializationObject, Map<String, Object> signatureMap) {
        try {
            Object headerObject;
            Object protectedObject;
            JWS signature = new JWS();
            Object signatureObject = signatureMap.get("signature");
            if (signatureObject == null) {
                return;
            }
            if (signatureObject instanceof String) {
                String signatureBase64Url = (String)signatureObject;
                if (Utils.isStringBlank((String)signatureBase64Url)) {
                    return;
                }
                signature.setSignature(DSSJsonUtils.fromBase64Url(signatureBase64Url));
            }
            if ((protectedObject = signatureMap.get("protected")) instanceof String) {
                String protectedBase64Url = (String)protectedObject;
                signature.setProtected(protectedBase64Url);
            }
            if ((headerObject = signatureMap.get("header")) instanceof Map) {
                Map header = (Map)headerObject;
                signature.setUnprotected(header);
            }
            if (signature.isRfc7797UnencodedPayload()) {
                signature.setPayloadBytes(jwsJsonSerializationObject.getPayload().getBytes(StandardCharsets.UTF_8));
            } else {
                signature.setPayloadBytes(DSSJsonUtils.fromBase64Url(jwsJsonSerializationObject.getPayload()));
            }
            signature.setJwsJsonSerializationObject(jwsJsonSerializationObject);
            jwsJsonSerializationObject.getSignatures().add(signature);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("Unable to parse a JWS signature. Reason : [%s]", e.getMessage()), (Throwable)e);
        }
    }

    private List<String> validateJWSStructure(String jsonDocument) {
        return JAdESUtils.getInstance().validateAgainstJWSSchema(jsonDocument);
    }
}

