/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.jades.JAdESSigningTimeType;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import java.util.Objects;

public class JAdESSignatureParameters
extends AbstractSignatureParameters<JAdESTimestampParameters> {
    private static final long serialVersionUID = -5937995983705731252L;
    private boolean includeCertificateChain = true;
    private boolean includeSignatureType = true;
    private boolean includeKeyIdentifier = true;
    private String x509Url;
    private boolean base64UrlEncodedPayload = true;
    private boolean base64UrlEncodedEtsiUComponents = true;
    private DigestAlgorithm signingCertificateDigestMethod = DigestAlgorithm.SHA512;
    private JWSSerializationType jwsSerializationType = JWSSerializationType.COMPACT_SERIALIZATION;
    private SigDMechanism sigDMechanism;
    private JAdESSigningTimeType jadesSigningTimeType = JAdESSigningTimeType.IAT;

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.JAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only JAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    public JAdESTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new JAdESTimestampParameters();
        }
        return (JAdESTimestampParameters)this.contentTimestampParameters;
    }

    public JAdESTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new JAdESTimestampParameters();
        }
        return (JAdESTimestampParameters)this.signatureTimestampParameters;
    }

    public JAdESTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new JAdESTimestampParameters();
        }
        return (JAdESTimestampParameters)this.archiveTimestampParameters;
    }

    public boolean isIncludeCertificateChain() {
        return this.includeCertificateChain;
    }

    public void setIncludeCertificateChain(boolean includeCertificateChain) {
        this.includeCertificateChain = includeCertificateChain;
    }

    public boolean isIncludeSignatureType() {
        return this.includeSignatureType;
    }

    public void setIncludeSignatureType(boolean includeSignatureType) {
        this.includeSignatureType = includeSignatureType;
    }

    public boolean isIncludeKeyIdentifier() {
        return this.includeKeyIdentifier;
    }

    public void setIncludeKeyIdentifier(boolean includeKeyIdentifier) {
        this.includeKeyIdentifier = includeKeyIdentifier;
    }

    public String getX509Url() {
        return this.x509Url;
    }

    public void setX509Url(String x509Url) {
        this.x509Url = x509Url;
    }

    public DigestAlgorithm getSigningCertificateDigestMethod() {
        return this.signingCertificateDigestMethod;
    }

    public void setSigningCertificateDigestMethod(DigestAlgorithm signingCertificateDigestMethod) {
        Objects.requireNonNull(signingCertificateDigestMethod, "SigningCertificateDigestMethod cannot be null!");
        this.signingCertificateDigestMethod = signingCertificateDigestMethod;
    }

    public JWSSerializationType getJwsSerializationType() {
        return this.jwsSerializationType;
    }

    public void setJwsSerializationType(JWSSerializationType jwsSerializationType) {
        Objects.requireNonNull(jwsSerializationType, "JWSSerializationType cannot be null!");
        this.jwsSerializationType = jwsSerializationType;
    }

    public SigDMechanism getSigDMechanism() {
        return this.sigDMechanism;
    }

    public void setSigDMechanism(SigDMechanism sigDMechanism) {
        this.sigDMechanism = sigDMechanism;
    }

    public JAdESSigningTimeType getJadesSigningTimeType() {
        return this.jadesSigningTimeType;
    }

    public void setJadesSigningTimeType(JAdESSigningTimeType jadesSigningTimeType) {
        this.jadesSigningTimeType = jadesSigningTimeType;
    }

    public boolean isBase64UrlEncodedPayload() {
        return this.base64UrlEncodedPayload;
    }

    public void setBase64UrlEncodedPayload(boolean base64EncodedPayload) {
        this.base64UrlEncodedPayload = base64EncodedPayload;
    }

    public boolean isBase64UrlEncodedEtsiUComponents() {
        return this.base64UrlEncodedEtsiUComponents;
    }

    public void setBase64UrlEncodedEtsiUComponents(boolean base64UrlEncodedEtsiUComponents) {
        this.base64UrlEncodedEtsiUComponents = base64UrlEncodedEtsiUComponents;
    }

    public String toString() {
        return "JAdESSignatureParameters [includeCertificateChain=" + this.includeCertificateChain + ", includeSignatureType=" + this.includeSignatureType + ", includeKeyIdentifier=" + this.includeKeyIdentifier + ", x509Url='" + this.x509Url + '\'' + ", base64UrlEncodedPayload=" + this.base64UrlEncodedPayload + ", base64UrlEncodedEtsiUComponents=" + this.base64UrlEncodedEtsiUComponents + ", signingCertificateDigestMethod=" + this.signingCertificateDigestMethod + ", jwsSerializationType=" + this.jwsSerializationType + ", sigDMechanism=" + this.sigDMechanism + ", jadesSigningTimeType=" + (Object)((Object)this.jadesSigningTimeType) + "] " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JAdESSignatureParameters that = (JAdESSignatureParameters)((Object)o);
        return this.includeCertificateChain == that.includeCertificateChain && this.includeSignatureType == that.includeSignatureType && this.includeKeyIdentifier == that.includeKeyIdentifier && this.base64UrlEncodedPayload == that.base64UrlEncodedPayload && this.base64UrlEncodedEtsiUComponents == that.base64UrlEncodedEtsiUComponents && Objects.equals(this.x509Url, that.x509Url) && this.signingCertificateDigestMethod == that.signingCertificateDigestMethod && this.jwsSerializationType == that.jwsSerializationType && this.sigDMechanism == that.sigDMechanism && this.jadesSigningTimeType == that.jadesSigningTimeType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.includeCertificateChain);
        result = 31 * result + Boolean.hashCode(this.includeSignatureType);
        result = 31 * result + Boolean.hashCode(this.includeKeyIdentifier);
        result = 31 * result + Objects.hashCode(this.x509Url);
        result = 31 * result + Boolean.hashCode(this.base64UrlEncodedPayload);
        result = 31 * result + Boolean.hashCode(this.base64UrlEncodedEtsiUComponents);
        result = 31 * result + Objects.hashCode(this.signingCertificateDigestMethod);
        result = 31 * result + Objects.hashCode(this.jwsSerializationType);
        result = 31 * result + Objects.hashCode(this.sigDMechanism);
        result = 31 * result + Objects.hashCode((Object)this.jadesSigningTimeType);
        return result;
    }
}

