/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JWSJsonSerializationObject
implements Serializable {
    private static final long serialVersionUID = -372703330907087721L;
    private String payload;
    private List<JWS> signatures;
    private JWSSerializationType jwsSerializationType;
    private List<String> structuralValidationErrors;

    public String getPayload() {
        if (this.payload == null) {
            this.payload = "";
        }
        return this.payload;
    }

    public void setPayload(String encodedPayload) {
        this.payload = encodedPayload;
    }

    public List<JWS> getSignatures() {
        if (this.signatures == null) {
            this.signatures = new ArrayList<JWS>();
        }
        return this.signatures;
    }

    public void setSignatures(List<JWS> signatures) {
        this.signatures = signatures;
    }

    public JWSSerializationType getJWSSerializationType() {
        return this.jwsSerializationType;
    }

    public void setJWSSerializationType(JWSSerializationType jwsSerializationType) {
        this.jwsSerializationType = jwsSerializationType;
    }

    public List<String> getStructuralValidationErrors() {
        if (Utils.isCollectionNotEmpty(this.structuralValidationErrors)) {
            return this.structuralValidationErrors;
        }
        return Collections.emptyList();
    }

    public void setStructuralValidationErrors(List<String> structuralValidationErrors) {
        this.structuralValidationErrors = structuralValidationErrors;
    }

    public boolean isValid() {
        return Utils.isCollectionEmpty(this.structuralValidationErrors);
    }
}

