/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.signature.AbstractJAdESBuilder;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import java.util.List;
import java.util.Objects;

public class JAdESCompactBuilder
extends AbstractJAdESBuilder {
    public JAdESCompactBuilder(CertificateVerifier certificateVerifier, JAdESSignatureParameters parameters, List<DSSDocument> documentsToSign) {
        super(certificateVerifier, parameters, documentsToSign);
    }

    @Override
    public DSSDocument build(SignatureValue signatureValue) {
        this.assertConfigurationValidity(this.parameters);
        JWS jws = new JWS();
        this.incorporateHeader(jws);
        if (!SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging())) {
            this.incorporatePayload(jws);
        }
        String payload = this.parameters.isBase64UrlEncodedPayload() ? jws.getEncodedPayload() : jws.getUnverifiedPayload();
        byte[] signatureValueBytes = DSSASN1Utils.ensurePlainSignatureValue((EncryptionAlgorithm)this.parameters.getEncryptionAlgorithm(), (byte[])signatureValue.getValue());
        String signatureString = DSSJsonUtils.concatenate(jws.getEncodedHeader(), payload, DSSJsonUtils.toBase64Url(signatureValueBytes));
        return new InMemoryDocument(signatureString.getBytes());
    }

    @Override
    public MimeType getMimeType() {
        return MimeTypeEnum.JOSE;
    }

    @Override
    protected void assertConfigurationValidity(JAdESSignatureParameters signatureParameters) {
        Objects.requireNonNull(signatureParameters.getSignaturePackaging(), "SignaturePackaging shall be defined!");
        Objects.requireNonNull(signatureParameters.getSignatureLevel(), "SignatureLevel shall be defined!");
        SignaturePackaging packaging = signatureParameters.getSignaturePackaging();
        if (!SignaturePackaging.ENVELOPING.equals((Object)packaging) && !SignaturePackaging.DETACHED.equals((Object)packaging)) {
            throw new IllegalArgumentException("Unsupported signature packaging for JAdES Compact Signature: " + packaging);
        }
        SignatureLevel signatureLevel = signatureParameters.getSignatureLevel();
        if (!SignatureLevel.JAdES_BASELINE_B.equals((Object)signatureLevel)) {
            throw new IllegalArgumentException("Only JAdES_BASELINE_B level is allowed for JAdES Compact Signature! Change JwsSerializationType in JAdESSignatureParameters in order to support extension!");
        }
    }
}

