/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.ValidationDataEncapsulationStrategy;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineT;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESLevelBaselineLT
extends JAdESLevelBaselineT {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESLevelBaselineLT.class);

    public JAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters params) {
        super.extendSignatures(signatures, params);
        List<AdvancedSignature> signaturesToExtend = this.getExtendToLTLevelSignatures(signatures, params);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        for (AdvancedSignature signature : signaturesToExtend) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            jadesSignature.resetCertificateSource();
            jadesSignature.resetRevocationSources();
            jadesSignature.resetTimestampSource();
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(params);
        if (SignatureLevel.JAdES_BASELINE_LT.equals((Object)params.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToLTLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForLTLevel(signaturesToExtend);
        ValidationDataContainer validationDataContainer = this.documentValidator.getValidationData(signatures);
        for (AdvancedSignature signature : signaturesToExtend) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            if (jadesSignature.hasLTAProfile()) continue;
            this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), params.isBase64UrlEncodedEtsiUComponents());
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            this.removeOldCertificateValues(jadesSignature, etsiUHeader);
            this.removeOldRevocationValues(jadesSignature, etsiUHeader);
            this.removeLastTimestampAndAnyValidationData(jadesSignature, etsiUHeader);
            ValidationData includedValidationData = this.incorporateValidationDataForSignature(validationDataContainer, signature, etsiUHeader, params);
            this.incorporateValidationDataForTimestamps(validationDataContainer, signature, etsiUHeader, params, includedValidationData);
        }
    }

    private void removeOldCertificateValues(JAdESSignature jadesSignature, JAdESEtsiUHeader etsiUHeader) {
        etsiUHeader.removeComponent("xVals");
        jadesSignature.resetCertificateSource();
    }

    private void removeOldRevocationValues(JAdESSignature jadesSignature, JAdESEtsiUHeader etsiUHeader) {
        etsiUHeader.removeComponent("rVals");
        jadesSignature.resetRevocationSources();
    }

    protected void removeLastTimestampAndAnyValidationData(JAdESSignature jadesSignature, JAdESEtsiUHeader etsiUHeader) {
        boolean resetSources = false;
        while (etsiUHeader.removeLastComponent("tstVD", "anyValData")) {
            resetSources = true;
        }
        if (resetSources) {
            jadesSignature.resetCertificateSource();
            jadesSignature.resetRevocationSources();
        }
    }

    private ValidationData incorporateValidationDataForSignature(ValidationDataContainer validationDataContainer, AdvancedSignature signature, JAdESEtsiUHeader etsiUHeader, JAdESSignatureParameters signatureParameters) {
        ValidationData validationDataForInclusion;
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = signatureParameters.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                validationDataForInclusion = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: {
                validationDataForInclusion = validationDataContainer.getValidationDataForSignatureForInclusion(signature);
                validationDataForInclusion.addValidationData(validationDataContainer.getValidationDataForCounterSignaturesForInclusion(signature));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", validationDataEncapsulationStrategy));
            }
        }
        Set certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
        Set crlsToAdd = validationDataForInclusion.getCrlTokens();
        Set ocspsToAdd = validationDataForInclusion.getOcspTokens();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: {
                this.incorporateXVals(etsiUHeader, certificateValuesToAdd, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                this.incorporateRVals(etsiUHeader, crlsToAdd, ocspsToAdd, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case ANY_VALIDATION_DATA_ONLY: {
                this.incorporateAnyValidationData(etsiUHeader, validationDataForInclusion, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", validationDataEncapsulationStrategy));
            }
        }
        return validationDataForInclusion;
    }

    private void incorporateValidationDataForTimestamps(ValidationDataContainer validationDataContainer, AdvancedSignature signature, JAdESEtsiUHeader etsiUHeader, JAdESSignatureParameters signatureParameters, ValidationData validationDataToExclude) {
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = signatureParameters.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature));
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateTstValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateTstValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                ValidationData counterSigTstValidationData = validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature);
                counterSigTstValidationData.excludeValidationData(validationData);
                counterSigTstValidationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(etsiUHeader, counterSigTstValidationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature));
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(etsiUHeader, validationData, signatureParameters.isBase64UrlEncodedEtsiUComponents());
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", validationDataEncapsulationStrategy));
            }
        }
    }

    protected JSONArray getXVals(Set<CertificateToken> certificateValuesToAdd) {
        JSONArray xValsArray = new JSONArray();
        for (CertificateToken certificateToken : certificateValuesToAdd) {
            xValsArray.add((Object)this.getX509CertObject(certificateToken));
        }
        return xValsArray;
    }

    private JSONObject getX509CertObject(CertificateToken certificateToken) {
        JSONObject pkiOb = new JSONObject();
        pkiOb.put((Object)"val", (Object)Utils.toBase64((byte[])certificateToken.getEncoded()));
        JSONObject x509Cert = new JSONObject();
        x509Cert.put((Object)"x509Cert", (Object)pkiOb);
        return x509Cert;
    }

    protected void incorporateXVals(JAdESEtsiUHeader etsiUHeader, Set<CertificateToken> certificateValuesToAdd, boolean base64UrlEncoded) {
        if (Utils.isCollectionNotEmpty(certificateValuesToAdd)) {
            JSONArray xVals = this.getXVals(certificateValuesToAdd);
            etsiUHeader.addComponent("xVals", xVals, base64UrlEncoded);
        }
    }

    protected JsonObject getRVals(Set<CRLToken> crlsToAdd, Set<OCSPToken> ocspsToAdd) {
        JsonObject rValsObject = new JsonObject();
        if (Utils.isCollectionNotEmpty(crlsToAdd)) {
            rValsObject.put("crlVals", (Object)this.getCrlVals(crlsToAdd));
        }
        if (Utils.isCollectionNotEmpty(ocspsToAdd)) {
            rValsObject.put("ocspVals", (Object)this.getOcspVals(ocspsToAdd));
        }
        return rValsObject;
    }

    private JSONArray getCrlVals(Set<CRLToken> crlsToAdd) {
        JSONArray array = new JSONArray();
        for (CRLToken crlToken : crlsToAdd) {
            JSONObject pkiOb = new JSONObject();
            pkiOb.put((Object)"val", (Object)Utils.toBase64((byte[])crlToken.getEncoded()));
            array.add((Object)pkiOb);
        }
        return array;
    }

    private JSONArray getOcspVals(Set<OCSPToken> ocspsToAdd) {
        JSONArray array = new JSONArray();
        for (OCSPToken ocspToken : ocspsToAdd) {
            JSONObject pkiOb = new JSONObject();
            pkiOb.put((Object)"val", (Object)Utils.toBase64((byte[])ocspToken.getEncoded()));
            array.add((Object)pkiOb);
        }
        return array;
    }

    protected void incorporateRVals(JAdESEtsiUHeader etsiUHeader, Set<CRLToken> crlsToAdd, Set<OCSPToken> ocspsToAdd, boolean base64UrlEncoded) {
        if (Utils.isCollectionNotEmpty(crlsToAdd) || Utils.isCollectionNotEmpty(ocspsToAdd)) {
            JsonObject rVals = this.getRVals(crlsToAdd, ocspsToAdd);
            etsiUHeader.addComponent("rVals", rVals, base64UrlEncoded);
        }
    }

    protected void incorporateTstValidationData(JAdESEtsiUHeader etsiUHeader, ValidationData validationDataForInclusion, boolean base64UrlEncoded) {
        this.incorporateValidationData(etsiUHeader, validationDataForInclusion, "tstVD", base64UrlEncoded);
    }

    protected void incorporateAnyValidationData(JAdESEtsiUHeader etsiUHeader, ValidationData validationDataForInclusion, boolean base64UrlEncoded) {
        this.incorporateValidationData(etsiUHeader, validationDataForInclusion, "anyValData", base64UrlEncoded);
    }

    protected void incorporateValidationData(JAdESEtsiUHeader etsiUHeader, ValidationData validationDataForInclusion, String headerName, boolean base64UrlEncoded) {
        if (!validationDataForInclusion.isEmpty()) {
            JsonObject tstVd = this.getTstVd(validationDataForInclusion);
            etsiUHeader.addComponent(headerName, tstVd, base64UrlEncoded);
        }
    }

    private JsonObject getTstVd(ValidationData validationDataForInclusion) {
        Set certificateTokens = validationDataForInclusion.getCertificateTokens();
        Set crlTokens = validationDataForInclusion.getCrlTokens();
        Set ocspTokens = validationDataForInclusion.getOcspTokens();
        JsonObject tstVd = new JsonObject();
        if (Utils.isCollectionNotEmpty((Collection)certificateTokens)) {
            JSONArray xVals = this.getXVals(certificateTokens);
            tstVd.put("xVals", (Object)xVals);
        }
        if (Utils.isCollectionNotEmpty((Collection)crlTokens) || Utils.isCollectionNotEmpty((Collection)ocspTokens)) {
            JsonObject rVals = this.getRVals(crlTokens, ocspTokens);
            tstVd.put("rVals", (Object)rVals);
        }
        return tstVd;
    }

    private List<AdvancedSignature> getExtendToLTLevelSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters parameters) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.ltLevelExtensionRequired(signature, parameters)) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }

    private boolean ltLevelExtensionRequired(AdvancedSignature signature, JAdESSignatureParameters parameters) {
        return SignatureLevel.JAdES_BASELINE_LT.equals((Object)parameters.getSignatureLevel()) || !signature.hasLTAProfile();
    }
}

