/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESExtensionBuilder;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineExtension;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWSDocumentAnalyzerFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.executor.CompleteValidationContextExecutor;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class JAdESLevelBaselineT
extends JAdESExtensionBuilder
implements JAdESLevelBaselineExtension {
    protected final CertificateVerifier certificateVerifier;
    protected TSPSource tspSource;
    protected AbstractJWSDocumentAnalyzer documentValidator;
    private SigningOperation operationKind;

    public JAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    @Override
    public void setOperationKind(SigningOperation signingOperation) {
        this.operationKind = signingOperation;
    }

    public DSSDocument extendSignatures(DSSDocument document, JAdESSignatureParameters params) {
        Objects.requireNonNull(document, "The document cannot be null");
        Objects.requireNonNull(this.tspSource, "The TSPSource cannot be null");
        JWSDocumentAnalyzerFactory documentValidatorFactory = new JWSDocumentAnalyzerFactory();
        this.documentValidator = documentValidatorFactory.create(document);
        this.documentValidator.setCertificateVerifier(this.certificateVerifier);
        this.documentValidator.setDetachedContents(params.getDetachedContents());
        this.documentValidator.setValidationContextExecutor((ValidationContextExecutor)CompleteValidationContextExecutor.INSTANCE);
        JWSJsonSerializationObject jwsJsonSerializationObject = this.documentValidator.getJwsJsonSerializationObject();
        this.assertJWSJsonSerializationObjectValid(jwsJsonSerializationObject);
        List<AdvancedSignature> signatures = this.documentValidator.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException("There is no signature to extend!");
        }
        List<AdvancedSignature> signaturesToExtend = signatures;
        if (SigningOperation.SIGN.equals((Object)this.operationKind)) {
            signaturesToExtend = Arrays.asList((AdvancedSignature)signatures.get(signatures.size() - 1));
        }
        this.extendSignatures(signaturesToExtend, params);
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, params.getJwsSerializationType());
        return generator.generate();
    }

    protected void extendSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters params) {
        List<AdvancedSignature> signaturesToExtend = this.getExtendToTLevelSignatures(signatures, params);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(params);
        signatureRequirementsChecker.assertExtendToTLevelPossible(signaturesToExtend);
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertSigningCertificateIsValid(signaturesToExtend);
        for (AdvancedSignature signature : signaturesToExtend) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), params.isBase64UrlEncodedEtsiUComponents());
            JAdESTimestampParameters signatureTimestampParameters = params.getSignatureTimestampParameters();
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            DSSMessageDigest messageDigest = jadesSignature.getTimestampSource().getSignatureTimestampData(timestampDigestAlgorithm);
            TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, messageDigest.getValue());
            JsonObject tstContainer = DSSJsonUtils.getTstContainer(Collections.singletonList(timeStampResponse), null);
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            etsiUHeader.addComponent("sigTst", tstContainer, params.isBase64UrlEncodedEtsiUComponents());
        }
    }

    protected SignatureRequirementsChecker getSignatureRequirementsChecker(JAdESSignatureParameters parameters) {
        return new SignatureRequirementsChecker(this.certificateVerifier, (AbstractSignatureParameters)parameters);
    }

    private List<AdvancedSignature> getExtendToTLevelSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters parameters) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.tLevelExtensionRequired(signature, parameters)) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }

    private boolean tLevelExtensionRequired(AdvancedSignature jadesSignature, JAdESSignatureParameters parameters) {
        return SignatureLevel.JAdES_BASELINE_T.equals((Object)parameters.getSignatureLevel()) || !jadesSignature.hasTProfile();
    }
}

