/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.validation.identifier.SignatureAttributeIdentifier;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jose4j.json.internal.json_simple.JSONValue;

public class JAdESAttributeIdentifier
extends SignatureAttributeIdentifier {
    private static final long serialVersionUID = -1421464221784448021L;

    JAdESAttributeIdentifier(byte[] data) {
        super(data);
    }

    public static JAdESAttributeIdentifier build(String headerName, Object value) {
        return JAdESAttributeIdentifier.build(headerName, value, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JAdESAttributeIdentifier build(String headerName, Object value, Integer order) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            JAdESAttributeIdentifier jAdESAttributeIdentifier;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (Utils.isStringNotEmpty((String)headerName)) {
                    dos.writeChars(headerName);
                }
                if (value != null) {
                    dos.writeChars(JSONValue.toJSONString((Object)value));
                }
                if (order != null) {
                    dos.writeInt(order);
                }
                dos.flush();
                jAdESAttributeIdentifier = new JAdESAttributeIdentifier(baos.toByteArray());
            }
            return jAdESAttributeIdentifier;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to build a JAdESAttributeIdentifier. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }
}

