/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import java.util.Map;
import org.bouncycastle.asn1.x509.IssuerSerial;

public final class JAdESCertificateRefExtractionUtils {
    private JAdESCertificateRefExtractionUtils() {
    }

    public static CertificateRef createCertificateRef(Map<?, ?> certificateRefMap) {
        IssuerSerial issuerSerial = DSSJsonUtils.getIssuerSerial((String)certificateRefMap.get("kid"));
        Digest digest = DSSJsonUtils.getDigest(certificateRefMap);
        if (digest != null) {
            CertificateRef certificateRef = new CertificateRef();
            certificateRef.setCertDigest(digest);
            if (issuerSerial != null) {
                certificateRef.setCertificateIdentifier(DSSASN1Utils.toSignerIdentifier((IssuerSerial)issuerSerial));
            }
            return certificateRef;
        }
        return null;
    }
}

