/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.enumerations.PKIEncoding;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESOCSPSource
extends OfflineOCSPSource {
    private static final long serialVersionUID = -6522217477882736259L;
    private static final Logger LOG = LoggerFactory.getLogger(JAdESOCSPSource.class);
    private final transient JAdESEtsiUHeader etsiUHeader;

    public JAdESOCSPSource(JAdESEtsiUHeader etsiUHeader) {
        Objects.requireNonNull(etsiUHeader, "etsiUHeader cannot be null");
        this.etsiUHeader = etsiUHeader;
        this.extractEtsiU();
    }

    private void extractEtsiU() {
        if (!this.etsiUHeader.isExist()) {
            return;
        }
        for (JAdESAttribute jAdESAttribute : this.etsiUHeader.getAttributes()) {
            this.extractRevocationValues(jAdESAttribute);
            this.extractAttributeRevocationValues(jAdESAttribute);
            this.extractTimestampValidationData(jAdESAttribute);
            this.extractAnyValidationData(jAdESAttribute);
            this.extractCompleteRevocationRefs(jAdESAttribute);
            this.extractAttributeRevocationRefs(jAdESAttribute);
        }
    }

    private void extractRevocationValues(JAdESAttribute attribute) {
        if ("rVals".equals(attribute.getHeaderName())) {
            this.extractOCSPValues(DSSJsonUtils.toMap(attribute.getValue(), "rVals"), RevocationOrigin.REVOCATION_VALUES);
        }
    }

    private void extractAttributeRevocationValues(JAdESAttribute attribute) {
        if ("arVals".equals(attribute.getHeaderName())) {
            this.extractOCSPValues(DSSJsonUtils.toMap(attribute.getValue(), "arVals"), RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
        }
    }

    private void extractTimestampValidationData(JAdESAttribute attribute) {
        this.extractValidationData(attribute, "tstVD", RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
    }

    private void extractAnyValidationData(JAdESAttribute attribute) {
        this.extractValidationData(attribute, "anyValData", RevocationOrigin.ANY_VALIDATION_DATA);
    }

    private void extractValidationData(JAdESAttribute attribute, String headerName, RevocationOrigin origin) {
        Map<?, ?> rVals;
        Map<?, ?> tstVd;
        if (headerName.equals(attribute.getHeaderName()) && Utils.isMapNotEmpty(tstVd = DSSJsonUtils.toMap(attribute.getValue(), headerName)) && Utils.isMapNotEmpty(rVals = DSSJsonUtils.getAsMap(tstVd, "rVals"))) {
            this.extractOCSPValues(rVals, origin);
        }
    }

    private void extractCompleteRevocationRefs(JAdESAttribute attribute) {
        if ("rRefs".equals(attribute.getHeaderName())) {
            this.extractOCSPReferences(DSSJsonUtils.toMap(attribute.getValue(), "rRefs"), RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        }
    }

    private void extractAttributeRevocationRefs(JAdESAttribute attribute) {
        if ("arRefs".equals(attribute.getHeaderName())) {
            this.extractOCSPReferences(DSSJsonUtils.toMap(attribute.getValue(), "arRefs"), RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        }
    }

    private void extractOCSPValues(Map<?, ?> rVals, RevocationOrigin origin) {
        List<?> ocspVals = DSSJsonUtils.getAsList(rVals, "ocspVals");
        if (Utils.isCollectionNotEmpty(ocspVals)) {
            for (Object item : ocspVals) {
                Map<?, ?> pkiOb = DSSJsonUtils.toMap(item, "pkiOb");
                this.extractOCSPFromPkiOb(pkiOb, origin);
            }
        }
    }

    private void extractOCSPFromPkiOb(Map<?, ?> pkiOb, RevocationOrigin origin) {
        if (Utils.isMapNotEmpty(pkiOb)) {
            String encoding = DSSJsonUtils.getAsString(pkiOb, "encoding");
            if (Utils.isStringEmpty((String)encoding) || Utils.areStringsEqual((String)PKIEncoding.DER.getUri(), (String)encoding)) {
                String val = DSSJsonUtils.getAsString(pkiOb, "val");
                if (Utils.isStringNotEmpty((String)val)) {
                    this.add(val, origin);
                }
            } else {
                LOG.warn("Unsupported encoding '{}'", (Object)encoding);
            }
        }
    }

    private void add(String ocspValueDerB64, RevocationOrigin origin) {
        try {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)DSSRevocationUtils.loadOCSPBase64Encoded((String)ocspValueDerB64)), origin);
        }
        catch (Exception e) {
            LOG.warn("Unable to extract OCSP from '{}'", (Object)ocspValueDerB64, (Object)e);
        }
    }

    private void extractOCSPReferences(Map<?, ?> rRefs, RevocationRefOrigin origin) {
        List<?> ocspRefs = DSSJsonUtils.getAsList(rRefs, "ocspRefs");
        if (Utils.isCollectionNotEmpty(ocspRefs)) {
            for (Object item : ocspRefs) {
                OCSPRef ocspRef;
                Map<?, ?> ocspRefMap = DSSJsonUtils.toMap(item);
                if (!Utils.isMapNotEmpty(ocspRefMap) || (ocspRef = JAdESRevocationRefExtractionUtils.createOCSPRef(ocspRefMap)) == null) continue;
                this.addRevocationReference((RevocationRef)ocspRef, origin);
            }
        }
    }
}

