/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JAdESRevocationRefExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESRevocationRefExtractionUtils.class);

    private JAdESRevocationRefExtractionUtils() {
    }

    public static OCSPRef createOCSPRef(Map<?, ?> ocpRef) {
        ResponderId responderId = null;
        Date producedAt = null;
        try {
            Digest digest;
            Map ocspId = (Map)ocpRef.get("ocspId");
            if (Utils.isMapNotEmpty((Map)ocspId)) {
                producedAt = DSSJsonUtils.getDate((String)ocspId.get("producedAt"));
                responderId = JAdESRevocationRefExtractionUtils.getResponderId(ocspId);
            }
            if ((digest = DSSJsonUtils.getDigest(ocpRef)) != null) {
                return new OCSPRef(digest, producedAt, responderId);
            }
            LOG.warn("Missing digest information in OCSPRef");
        }
        catch (Exception e) {
            LOG.warn("Unable to extract OCSPRef. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private static ResponderId getResponderId(Map<?, ?> ocspId) {
        Map responderIdMap = (Map)ocspId.get("responderId");
        if (Utils.isMapNotEmpty((Map)responderIdMap)) {
            String byKeyB64;
            X500Principal subjectX500Principal = null;
            byte[] ski = null;
            String byNameB64 = (String)responderIdMap.get("byName");
            if (Utils.isStringNotEmpty((String)byNameB64) && Utils.isBase64Encoded((String)byNameB64)) {
                subjectX500Principal = DSSASN1Utils.toX500Principal((X500Name)X500Name.getInstance((Object)Utils.fromBase64((String)byNameB64)));
            }
            if (Utils.isStringNotEmpty((String)(byKeyB64 = (String)responderIdMap.get("byKey"))) && Utils.isBase64Encoded((String)byKeyB64)) {
                ski = Utils.fromBase64((String)byKeyB64);
            }
            if (subjectX500Principal != null || Utils.isArrayNotEmpty(ski)) {
                return new ResponderId(subjectX500Principal, ski);
            }
        }
        return null;
    }

    public static CRLRef createCRLRef(Map<?, ?> crlRefMap) {
        X500Name crlIssuer = null;
        Date crlIssuedTime = null;
        BigInteger crlNumber = null;
        try {
            Digest digest;
            Map crlId = (Map)crlRefMap.get("crlId");
            if (Utils.isMapNotEmpty((Map)crlId)) {
                String crlNumberString;
                String issueTimeStr;
                String issuerB64 = (String)crlId.get("issuer");
                if (Utils.isStringNotEmpty((String)issuerB64) && Utils.isBase64Encoded((String)issuerB64)) {
                    crlIssuer = X500Name.getInstance((Object)Utils.fromBase64((String)issuerB64));
                }
                if (Utils.isStringNotEmpty((String)(issueTimeStr = (String)crlId.get("issueTime")))) {
                    crlIssuedTime = DSSJsonUtils.getDate(issueTimeStr);
                }
                if (Utils.isStringNotEmpty((String)(crlNumberString = (String)crlId.get("number")))) {
                    crlNumber = BigInteger.valueOf(Long.parseLong(crlNumberString));
                }
            }
            if ((digest = DSSJsonUtils.getDigest(crlRefMap)) != null) {
                CRLRef crlRef = new CRLRef(digest);
                crlRef.setCrlIssuer(crlIssuer);
                crlRef.setCrlIssuedTime(crlIssuedTime);
                crlRef.setCrlNumber(crlNumber);
                return crlRef;
            }
            LOG.warn("Missing digest information in CRLRef");
        }
        catch (Exception e) {
            LOG.warn("Unable to extract a CRLRef. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

