/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JWSJsonSerializationParser;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWSSerializationAnalyzerValidator
extends AbstractJWSDocumentAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(JWSSerializationAnalyzerValidator.class);

    public JWSSerializationAnalyzerValidator() {
    }

    public JWSSerializationAnalyzerValidator(DSSDocument document) {
        super(document);
    }

    public boolean isSupported(DSSDocument document) {
        JWSJsonSerializationParser jwsJsonSerializationParser = new JWSJsonSerializationParser(document);
        return jwsJsonSerializationParser.isSupported();
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        JWSJsonSerializationObject jwsJsonSerializationObject = this.getJwsJsonSerializationObject();
        List<JWS> foundSignatures = jwsJsonSerializationObject.getSignatures();
        LOG.info("{} signature(s) found", (Object)Utils.collectionSize(foundSignatures));
        for (JWS jws : foundSignatures) {
            JAdESSignature jadesSignature = new JAdESSignature(jws);
            jadesSignature.setFilename(this.document.getName());
            jadesSignature.setSigningCertificateSource(this.signingCertificateSource);
            jadesSignature.setDetachedContents(this.detachedContents);
            jadesSignature.initBaselineRequirementsChecker(this.certificateVerifier);
            this.validateSignaturePolicy((AdvancedSignature)jadesSignature);
            signatures.add((AdvancedSignature)jadesSignature);
        }
        return signatures;
    }

    @Override
    protected JWSJsonSerializationObject buildJwsJsonSerializationObject() {
        JWSJsonSerializationParser jwsJsonSerializationParser = new JWSJsonSerializationParser(this.document);
        if (jwsJsonSerializationParser.isSupported()) {
            return jwsJsonSerializationParser.parse();
        }
        throw new IllegalInputException("The given document is not supported by JWSSerializationDocumentValidator!");
    }
}

