/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.PKIEncoding;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.jades.validation.JAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JAdESSignedProperties;
import eu.europa.esig.dss.jades.validation.timestamp.JAdESTimestampMessageDigestBuilder;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.SignatureProperties;
import eu.europa.esig.dss.spi.validation.timestamp.SignatureTimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESTimestampSource
extends SignatureTimestampSource<JAdESSignature, JAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESTimestampSource.class);
    private final Map<TimestampToken, JAdESAttribute> timestampAttributeMap = new HashMap<TimestampToken, JAdESAttribute>();

    public JAdESTimestampSource(JAdESSignature signature) {
        super((AdvancedSignature)signature);
    }

    protected SignatureProperties<JAdESAttribute> buildSignedSignatureProperties() {
        return new JAdESSignedProperties(((JAdESSignature)this.signature).getJws().getHeaders());
    }

    protected SignatureProperties<JAdESAttribute> buildUnsignedSignatureProperties() {
        return ((JAdESSignature)this.signature).getEtsiUHeader();
    }

    protected boolean isContentTimestamp(JAdESAttribute signedAttribute) {
        return "adoTst".equals(signedAttribute.getHeaderName());
    }

    protected boolean isAllDataObjectsTimestamp(JAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isIndividualDataObjectsTimestamp(JAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isSignatureTimestamp(JAdESAttribute unsignedAttribute) {
        return "sigTst".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isCompleteCertificateRef(JAdESAttribute unsignedAttribute) {
        return "xRefs".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isAttributeCertificateRef(JAdESAttribute unsignedAttribute) {
        return "axRefs".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isCompleteRevocationRef(JAdESAttribute unsignedAttribute) {
        return "rRefs".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isAttributeRevocationRef(JAdESAttribute unsignedAttribute) {
        return "arRefs".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isRefsOnlyTimestamp(JAdESAttribute unsignedAttribute) {
        return "rfsTst".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isSigAndRefsTimestamp(JAdESAttribute unsignedAttribute) {
        return "sigRTst".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isCertificateValues(JAdESAttribute unsignedAttribute) {
        return "xVals".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isRevocationValues(JAdESAttribute unsignedAttribute) {
        return "rVals".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isArchiveTimestamp(JAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestamp(unsignedAttribute.getHeaderName());
    }

    private boolean isArchiveTimestamp(String headerName) {
        return "arcTst".equals(headerName);
    }

    protected boolean isTimeStampValidationData(JAdESAttribute unsignedAttribute) {
        return "tstVD".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isAnyValidationData(JAdESAttribute unsignedAttribute) {
        return "anyValData".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isValidationDataReferences(JAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCounterSignature(JAdESAttribute unsignedAttribute) {
        return "cSig".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isSignaturePolicyStore(JAdESAttribute unsignedAttribute) {
        return "sigPSt".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isAttrAuthoritiesCertValues(JAdESAttribute unsignedAttribute) {
        return "axVals".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isAttributeRevocationValues(JAdESAttribute unsignedAttribute) {
        return "arVals".equals(unsignedAttribute.getHeaderName());
    }

    protected boolean isEvidenceRecord(JAdESAttribute unsignedAttribute) {
        return false;
    }

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List timestampedReferences = super.getSignatureTimestampReferences();
        this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        return timestampedReferences;
    }

    protected List<CertificateRef> getCertificateRefs(JAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        List<?> certRefs = DSSJsonUtils.toList(unsignedAttribute.getValue());
        if (Utils.isCollectionNotEmpty(certRefs)) {
            for (Object item : certRefs) {
                CertificateRef certificateRef;
                Map<?, ?> certId = DSSJsonUtils.toMap(item, "certId");
                if (!Utils.isMapNotEmpty(certId) || (certificateRef = JAdESCertificateRefExtractionUtils.createCertificateRef(certId)) == null) continue;
                result.add(certificateRef);
            }
        }
        return result;
    }

    protected List<CRLRef> getCRLRefs(JAdESAttribute unsignedAttribute) {
        List<?> crlRefs;
        ArrayList<CRLRef> result = new ArrayList<CRLRef>();
        Map<?, ?> refsValueMap = DSSJsonUtils.toMap(unsignedAttribute.getValue());
        if (Utils.isMapNotEmpty(refsValueMap) && Utils.isCollectionNotEmpty(crlRefs = DSSJsonUtils.getAsList(refsValueMap, "crlRefs"))) {
            for (Object item : crlRefs) {
                CRLRef crlRef;
                Map<?, ?> crlRefMap = DSSJsonUtils.toMap(item);
                if (!Utils.isMapNotEmpty(crlRefMap) || (crlRef = JAdESRevocationRefExtractionUtils.createCRLRef(crlRefMap)) == null) continue;
                result.add(crlRef);
            }
        }
        return result;
    }

    protected List<OCSPRef> getOCSPRefs(JAdESAttribute unsignedAttribute) {
        List<?> ocsp;
        ArrayList<OCSPRef> result = new ArrayList<OCSPRef>();
        Map<?, ?> refsValueMap = DSSJsonUtils.toMap(unsignedAttribute.getValue());
        if (Utils.isMapNotEmpty(refsValueMap) && Utils.isCollectionNotEmpty(ocsp = DSSJsonUtils.getAsList(refsValueMap, "ocspRefs"))) {
            for (Object item : ocsp) {
                OCSPRef ocspRef;
                Map<?, ?> ocspRefMap = DSSJsonUtils.toMap(item);
                if (!Utils.isMapNotEmpty(ocspRefMap) || (ocspRef = JAdESRevocationRefExtractionUtils.createOCSPRef(ocspRefMap)) == null) continue;
                result.add(ocspRef);
            }
        }
        return result;
    }

    protected List<Identifier> getEncapsulatedCertificateIdentifiers(JAdESAttribute unsignedAttribute) {
        List<?> xVals = null;
        if (this.isTimeStampValidationData(unsignedAttribute)) {
            Map<?, ?> tstVd = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "tstVD");
            if (Utils.isMapNotEmpty(tstVd)) {
                xVals = DSSJsonUtils.getAsList(tstVd, "xVals");
            }
        } else if (this.isAnyValidationData(unsignedAttribute)) {
            Map<?, ?> anyVD = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "anyValData");
            if (Utils.isMapNotEmpty(anyVD)) {
                xVals = DSSJsonUtils.getAsList(anyVD, "xVals");
            }
        } else {
            xVals = DSSJsonUtils.toList(unsignedAttribute.getValue(), "xVals");
        }
        if (Utils.isCollectionNotEmpty(xVals)) {
            ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
            for (Object encapsulatedCert : xVals) {
                CertificateToken certificateToken = this.toCertificateToken(encapsulatedCert);
                if (certificateToken == null) continue;
                certificateIdentifiers.add((Identifier)certificateToken.getDSSId());
            }
            return certificateIdentifiers;
        }
        return Collections.emptyList();
    }

    private CertificateToken toCertificateToken(Object encapsulatedCert) {
        try {
            Map<?, ?> map = DSSJsonUtils.toMap(encapsulatedCert);
            if (Utils.isMapNotEmpty(map)) {
                Map<?, ?> x509Cert = DSSJsonUtils.getAsMap(map, "x509Cert");
                Map<?, ?> otherCert = DSSJsonUtils.getAsMap(map, "otherCert");
                if (Utils.isMapNotEmpty(x509Cert)) {
                    String base64Cert = DSSJsonUtils.getAsString(x509Cert, "val");
                    if (Utils.isStringNotBlank((String)base64Cert)) {
                        byte[] binaries = Utils.fromBase64((String)base64Cert);
                        return DSSUtils.loadCertificate((byte[])binaries);
                    }
                } else if (Utils.isMapNotEmpty(otherCert)) {
                    LOG.warn("The header '{}' is not supported! The entry is skipped.", (Object)"otherCert");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during parsing a certificate. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(JAdESAttribute unsignedAttribute) {
        Map<?, ?> rVals = null;
        if (this.isTimeStampValidationData(unsignedAttribute)) {
            Map<?, ?> tstVd = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "tstVD");
            if (Utils.isMapNotEmpty(tstVd)) {
                rVals = DSSJsonUtils.getAsMap(tstVd, "rVals");
            }
        } else if (this.isAnyValidationData(unsignedAttribute)) {
            Map<?, ?> anyVD = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "anyValData");
            if (Utils.isMapNotEmpty(anyVD)) {
                rVals = DSSJsonUtils.getAsMap(anyVD, "rVals");
            }
        } else {
            rVals = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "rVals");
        }
        if (rVals != null) {
            ArrayList<CRLBinary> crlIdentifiers = new ArrayList<CRLBinary>();
            List<?> crlVals = DSSJsonUtils.getAsList(rVals, "crlVals");
            if (Utils.isCollectionNotEmpty(crlVals)) {
                for (Object item : crlVals) {
                    CRLBinary crlBinary = this.toCRLBinary(item);
                    if (crlBinary == null) continue;
                    crlIdentifiers.add(crlBinary);
                }
            }
            return crlIdentifiers;
        }
        return Collections.emptyList();
    }

    private CRLBinary toCRLBinary(Object crlVal) {
        try {
            String base64Crl;
            Map<?, ?> encapsulatedCrl = DSSJsonUtils.toMap(crlVal);
            if (Utils.isMapNotEmpty(encapsulatedCrl) && Utils.isStringNotBlank((String)(base64Crl = DSSJsonUtils.getAsString(encapsulatedCrl, "val")))) {
                byte[] binaries = Utils.fromBase64((String)base64Crl);
                return CRLUtils.buildCRLBinary((byte[])binaries);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during parsing a CRL. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(JAdESAttribute unsignedAttribute) {
        Map<?, ?> rVals = null;
        if (this.isTimeStampValidationData(unsignedAttribute)) {
            Map<?, ?> tstVd = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "tstVD");
            if (Utils.isMapNotEmpty(tstVd)) {
                rVals = DSSJsonUtils.getAsMap(tstVd, "rVals");
            }
        } else if (this.isAnyValidationData(unsignedAttribute)) {
            Map<?, ?> anyVD = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "anyValData");
            if (Utils.isMapNotEmpty(anyVD)) {
                rVals = DSSJsonUtils.getAsMap(anyVD, "rVals");
            }
        } else {
            rVals = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "rVals");
        }
        if (rVals != null) {
            ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
            List<?> ocspVals = DSSJsonUtils.getAsList(rVals, "ocspVals");
            if (Utils.isCollectionNotEmpty(ocspVals)) {
                for (Object item : ocspVals) {
                    OCSPResponseBinary ocspResponseBinary = this.toOCSPResponseBinary(item);
                    if (ocspResponseBinary == null) continue;
                    ocspIdentifiers.add(ocspResponseBinary);
                }
            }
            return ocspIdentifiers;
        }
        return Collections.emptyList();
    }

    private OCSPResponseBinary toOCSPResponseBinary(Object ocspVal) {
        try {
            String base64Ocps;
            Map<?, ?> encapsulatedOcsp = DSSJsonUtils.toMap(ocspVal);
            if (Utils.isMapNotEmpty(encapsulatedOcsp) && Utils.isStringNotBlank((String)(base64Ocps = DSSJsonUtils.getAsString(encapsulatedOcsp, "val")))) {
                byte[] binaries = Utils.fromBase64((String)base64Ocps);
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries((byte[])binaries);
                return OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during parsing a CRL. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    protected JAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(TimestampToken timestampToken) {
        return new JAdESTimestampMessageDigestBuilder((JAdESSignature)this.signature, timestampToken).setTimestampAttribute(this.timestampAttributeMap.get(timestampToken));
    }

    protected JAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(DigestAlgorithm digestAlgorithm) {
        return new JAdESTimestampMessageDigestBuilder((JAdESSignature)this.signature, digestAlgorithm);
    }

    protected List<AdvancedSignature> getCounterSignatures(JAdESAttribute unsignedAttribute) {
        EtsiUComponent etsiUComponent;
        JAdESSignature counterSignature;
        if (unsignedAttribute instanceof EtsiUComponent && (counterSignature = DSSJsonUtils.extractJAdESCounterSignature(etsiUComponent = (EtsiUComponent)unsignedAttribute, (JAdESSignature)this.signature)) != null) {
            return Collections.singletonList(counterSignature);
        }
        return Collections.emptyList();
    }

    public DSSMessageDigest getSignatureTimestampData(DigestAlgorithm digestAlgorithm) {
        JAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm);
        return builder.getSignatureTimestampMessageDigest();
    }

    public DSSMessageDigest getArchiveTimestampData(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        JAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod);
        return builder.getArchiveTimestampMessageDigest();
    }

    protected TimestampToken makeTimestampToken(JAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        throw new UnsupportedOperationException("Attribute can contain more than one timestamp");
    }

    protected List<TimestampToken> makeTimestampTokens(JAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        if (TimestampType.ARCHIVE_TIMESTAMP.equals((Object)timestampType)) {
            return this.extractArchiveTimestampTokens(signatureAttribute, references);
        }
        Map<?, ?> tstContainer = DSSJsonUtils.toMap(signatureAttribute.getValue(), "tstContainer");
        return this.extractTimestampTokens(signatureAttribute, tstContainer, timestampType, references);
    }

    private List<TimestampToken> extractTimestampTokens(JAdESAttribute signatureAttribute, Map<?, ?> tstContainer, TimestampType timestampType, List<TimestampedReference> references) {
        LinkedList<TimestampToken> result = new LinkedList<TimestampToken>();
        if (Utils.isMapNotEmpty(tstContainer)) {
            List<?> tstTokens = DSSJsonUtils.getAsList(tstContainer, "tstTokens");
            if (Utils.isCollectionNotEmpty(tstTokens)) {
                for (int i = 0; i < tstTokens.size(); ++i) {
                    Object tstToken = tstTokens.get(i);
                    TimestampToken timestampToken = this.toTimestampToken(tstToken, signatureAttribute, i, timestampType, references);
                    if (timestampToken == null) continue;
                    this.timestampAttributeMap.put(timestampToken, signatureAttribute);
                    result.add(timestampToken);
                }
            } else {
                LOG.warn("'{}' element is not found! Returns an empty array if timestamps.", (Object)"tstTokens");
            }
        }
        return result;
    }

    private TimestampToken toTimestampToken(Object tstToken, JAdESAttribute signatureAttribute, Integer orderWithinAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        Map<?, ?> tstTokenMap = DSSJsonUtils.toMap(tstToken);
        if (Utils.isMapNotEmpty(tstTokenMap)) {
            String encoding = DSSJsonUtils.getAsString(tstTokenMap, "encoding");
            if (Utils.isStringEmpty((String)encoding) || Utils.areStringsEqual((String)PKIEncoding.DER.getUri(), (String)encoding)) {
                String tstBase64 = DSSJsonUtils.getAsString(tstTokenMap, "val");
                if (Utils.isStringNotEmpty((String)tstBase64)) {
                    try {
                        byte[] binaries = Utils.fromBase64((String)tstBase64);
                        SignatureTimestampIdentifierBuilder identifierBuilder = new SignatureTimestampIdentifierBuilder(binaries).setSignature(this.signature).setAttribute((SignatureAttribute)signatureAttribute).setOrderOfAttribute(this.getAttributeOrder(signatureAttribute)).setOrderWithinAttribute(orderWithinAttribute);
                        return new TimestampToken(binaries, timestampType, references, (TimestampIdentifierBuilder)identifierBuilder);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to create timestamp from base64-encoded string '{}'. Reason : {}", new Object[]{tstBase64, e.getMessage(), e});
                    }
                }
            } else {
                LOG.warn("Unsupported encoding {}", (Object)encoding);
            }
        }
        return null;
    }

    private List<TimestampToken> extractArchiveTimestampTokens(JAdESAttribute signatureAttribute, List<TimestampedReference> references) {
        Map<?, ?> arcTst = DSSJsonUtils.toMap(signatureAttribute.getValue(), "arcTst");
        return this.extractTimestampTokens(signatureAttribute, arcTst, TimestampType.ARCHIVE_TIMESTAMP, references);
    }

    protected ArchiveTimestampType getArchiveTimestampType(JAdESAttribute unsignedAttribute) {
        return ArchiveTimestampType.JAdES;
    }

    protected List<EvidenceRecord> makeEvidenceRecords(JAdESAttribute signatureAttribute, List<TimestampedReference> references) {
        if (signatureAttribute != null) {
            LOG.warn("Embedded evidence records are not supported within JAdES format! The unsigned attribute is skipped.");
        }
        return Collections.emptyList();
    }
}

