/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.identifier;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.Identifier;
import java.util.Arrays;
import java.util.EnumMap;

public abstract class MultipleDigestIdentifier
extends Identifier {
    private static final long serialVersionUID = 8499261315144968564L;
    private final byte[] binaries;
    private final EnumMap<DigestAlgorithm, byte[]> digestMap = new EnumMap(DigestAlgorithm.class);

    protected MultipleDigestIdentifier(String prefix, byte[] binaries) {
        super(prefix, binaries);
        this.binaries = binaries;
        Digest id = this.getDigestId();
        this.digestMap.put(id.getAlgorithm(), id.getValue());
    }

    public byte[] getBinaries() {
        return this.binaries;
    }

    public byte[] getDigestValue(DigestAlgorithm digestAlgorithm) {
        return this.digestMap.computeIfAbsent(digestAlgorithm, k -> this.getMessageDigest(digestAlgorithm).digest(this.getBinaries()));
    }

    public boolean isMatch(Digest expectedDigest) {
        return Arrays.equals(expectedDigest.getValue(), this.getDigestValue(expectedDigest.getAlgorithm()));
    }
}

