/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.Digest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

public class DigestDocument
extends CommonDocument {
    public DigestDocument() {
    }

    public DigestDocument(Digest digest) {
        Objects.requireNonNull(digest, "The Digest is not defined");
        this.addDigest(digest);
    }

    public DigestDocument(Digest digest, String name) {
        this(digest);
        this.name = name;
    }

    public DigestDocument(DigestAlgorithm digestAlgorithm, byte[] digestValue) {
        this.addDigest(digestAlgorithm, digestValue);
    }

    public DigestDocument(DigestAlgorithm digestAlgorithm, String base64EncodeDigest) {
        this.addDigest(digestAlgorithm, base64EncodeDigest);
    }

    public DigestDocument(DigestAlgorithm digestAlgorithm, byte[] digestValue, String name) {
        this(digestAlgorithm, digestValue);
        this.name = name;
    }

    public DigestDocument(DigestAlgorithm digestAlgorithm, String base64EncodeDigest, String name) {
        this(digestAlgorithm, base64EncodeDigest);
        this.name = name;
    }

    public void addDigest(Digest digest) {
        Objects.requireNonNull(digest, "The Digest is not defined");
        this.addDigest(digest.getAlgorithm(), digest.getValue());
    }

    public void addDigest(DigestAlgorithm digestAlgorithm, byte[] digestValue) {
        Objects.requireNonNull(digestAlgorithm, "The Digest Algorithm is not defined");
        Objects.requireNonNull(digestValue, "The digest value is not defined");
        this.digestMap.put(digestAlgorithm, digestValue);
    }

    public void addDigest(DigestAlgorithm digestAlgorithm, String base64EncodeDigest) {
        byte[] digest;
        Objects.requireNonNull(base64EncodeDigest, "The digest value is not defined");
        try {
            digest = Base64.getDecoder().decode(base64EncodeDigest);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to base64-decode string '%s' : %s", base64EncodeDigest, e.getMessage()));
        }
        this.addDigest(digestAlgorithm, digest);
    }

    @Override
    public byte[] getDigestValue(DigestAlgorithm digestAlgorithm) {
        byte[] digestValue = (byte[])this.digestMap.get(digestAlgorithm);
        if (digestValue == null) {
            throw new IllegalArgumentException("The digest document does not contain a digest value for the algorithm : " + digestAlgorithm);
        }
        return digestValue;
    }

    public Digest getExistingDigest() {
        if (!this.digestMap.isEmpty()) {
            Map.Entry digestEntry = this.digestMap.entrySet().iterator().next();
            return new Digest((DigestAlgorithm)digestEntry.getKey(), (byte[])digestEntry.getValue());
        }
        throw new IllegalStateException("The DigestDocument does not contain any digest! You must specify it by using addDigest() method.");
    }

    @Override
    public InputStream openStream() {
        throw new UnsupportedOperationException("Not possible with Digest document");
    }

    @Override
    public void save(String filePath) throws IOException {
        throw new UnsupportedOperationException("Not possible with Digest document");
    }
}

