/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import java.util.Objects;

public abstract class TimestampParameters
implements SerializableTimestampParameters {
    protected DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA512;

    protected TimestampParameters() {
    }

    protected TimestampParameters(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public String toString() {
        return "TimestampParameters [digestAlgorithm=" + this.digestAlgorithm + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampParameters that = (TimestampParameters)o;
        return this.digestAlgorithm == that.digestAlgorithm;
    }

    public int hashCode() {
        return Objects.hashCode(this.digestAlgorithm);
    }
}

