/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PadesCMSSignedDataBuilder;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.signature.SignatureValueChecker;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.Collections;
import java.util.Objects;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;

public class ExternalCMSService {
    private final CertificateVerifier certificateVerifier;
    private final PadesCMSSignedDataBuilder padesCMSSignedDataBuilder;
    private TSPSource tspSource;

    public ExternalCMSService(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
        this.padesCMSSignedDataBuilder = new PadesCMSSignedDataBuilder(certificateVerifier);
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    public ToBeSigned getDataToSign(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(messageDigest, "messageDigest cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertConfigurationValid(messageDigest, parameters);
        return this.buildToBeSignedData(messageDigest, parameters);
    }

    protected ToBeSigned buildToBeSignedData(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, (ContentSigner)customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest.getValue());
        CMSUtils.generateDetachedCMSSignedData((CMSSignedDataGenerator)generator, (CMSProcessableByteArray)content);
        byte[] dataToSign = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(dataToSign);
    }

    public CMSSignedDocument signMessageDigest(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(messageDigest, "messageDigest cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertConfigurationValid(messageDigest, parameters);
        CMSSignedData cmsSignedData = this.buildCMSSignedData(messageDigest, parameters, signatureValue);
        parameters.reinit();
        return new CMSSignedDocument(cmsSignedData);
    }

    protected CMSSignedData buildCMSSignedData(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        signatureValue = new SignatureValueChecker().ensureSignatureValue(signatureValue, parameters.getSignatureAlgorithm());
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, (ContentSigner)customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest.getValue());
        CMSSignedData cmsSignedData = CMSUtils.generateDetachedCMSSignedData((CMSSignedDataGenerator)generator, (CMSProcessableByteArray)content);
        if (!SignatureLevel.PAdES_BASELINE_B.equals((Object)signatureLevel)) {
            Objects.requireNonNull(this.tspSource, "TSPSource shall be provided for T-level creation!");
            DigestDocument digestDocument = DSSUtils.toDigestDocument((Digest)messageDigest);
            parameters.getContext().setDetachedContents(Collections.singletonList(digestDocument));
            CAdESLevelBaselineT cadesLevelBaselineT = new CAdESLevelBaselineT(this.tspSource, this.certificateVerifier);
            cmsSignedData = cadesLevelBaselineT.extendCMSSignatures(cmsSignedData, (CAdESSignatureParameters)parameters);
        }
        return cmsSignedData;
    }

    protected void assertConfigurationValid(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel shall be defined!");
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (!SignatureLevel.PAdES_BASELINE_B.equals((Object)signatureLevel) && !SignatureLevel.PAdES_BASELINE_T.equals((Object)signatureLevel)) {
            throw new IllegalArgumentException(String.format("SignatureLevel '%s' is not supported within PAdESCMSGeneratorService!", signatureLevel));
        }
        this.assertSigningCertificateValid((AbstractSignatureParameters<?>)parameters);
        if (messageDigest.getAlgorithm() != parameters.getDigestAlgorithm()) {
            throw new IllegalArgumentException(String.format("The DigestAlgorithm provided within Digest '%s' does not correspond to the one defined in SignatureParameters '%s'!", messageDigest.getAlgorithm(), parameters.getDigestAlgorithm()));
        }
    }

    protected void assertSigningCertificateValid(AbstractSignatureParameters<?> parameters) {
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        if (signingCertificate == null) {
            if (parameters.isGenerateTBSWithoutCertificate()) {
                return;
            }
            throw new IllegalArgumentException("Signing Certificate is not defined! Set signing certificate or use method setGenerateTBSWithoutCertificate(true).");
        }
        SignatureRequirementsChecker signatureRequirementsChecker = new SignatureRequirementsChecker(this.certificateVerifier, parameters);
        signatureRequirementsChecker.assertSigningCertificateIsValid(signingCertificate);
    }
}

