/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignatureForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSForPAdESBaselineRequirementsChecker
extends CAdESBaselineRequirementsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(CMSForPAdESBaselineRequirementsChecker.class);

    public CMSForPAdESBaselineRequirementsChecker(CAdESSignature signature) {
        super(signature);
    }

    public boolean isValidForPAdESBaselineBProfile() {
        if (((CAdESSignature)this.signature).getCmsSignedData().getSignerInfos().size() != 1) {
            LOG.warn("SignedData.signerInfos shall contain one and only one signerInfo for {}-BASELINE-B signature (cardinality == 1)!", (Object)this.getBaselineSignatureForm());
            return false;
        }
        return this.cmsBaselineBRequirements();
    }

    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.PAdES;
    }
}

