/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pades.validation.scope.PAdESSignatureScopeFinder;
import eu.europa.esig.dss.pades.validation.scope.PAdESTimestampScopeFinder;
import eu.europa.esig.dss.pades.validation.timestamp.PdfRevisionTimestampSource;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PDFDocumentValidator
extends SignedDocumentValidator {
    private IPdfObjFactory pdfObjectFactory = new ServiceLoaderPdfObjFactory();
    private List<PdfRevision> documentRevisions;
    private char[] passwordProtection;

    protected PDFDocumentValidator() {
    }

    public PDFDocumentValidator(DSSDocument document) {
        super((SignatureScopeFinder)new PAdESSignatureScopeFinder());
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        if (!this.isSupported(document)) {
            throw new IllegalInputException("Not supported document");
        }
        this.document = document;
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return PAdESUtils.isPDFDocument(dssDocument);
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjectFactory = pdfObjFactory;
    }

    @Deprecated
    public void setPasswordProtection(String pwd) {
        this.passwordProtection = pwd != null ? pwd.toCharArray() : null;
    }

    public void setPasswordProtection(char[] passwordProtection) {
        this.passwordProtection = passwordProtection;
    }

    protected <T extends AdvancedSignature> ValidationContext prepareValidationContext(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps, CertificateVerifier certificateVerifier) {
        ValidationContext validationContext = super.prepareValidationContext(signatures, detachedTimestamps, certificateVerifier);
        List<PdfDocDssRevision> dssRevisions = this.getDssRevisions();
        this.prepareDssDictionaryValidationContext(validationContext, dssRevisions);
        return validationContext;
    }

    protected PAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new PAdESDiagnosticDataBuilder();
    }

    protected void prepareDssDictionaryValidationContext(ValidationContext validationContext, List<PdfDocDssRevision> dssRevisions) {
        for (PdfDocDssRevision dssRevision : dssRevisions) {
            validationContext.addDocumentCertificateSource((CertificateSource)dssRevision.getCertificateSource());
            validationContext.addDocumentCRLSource((OfflineRevocationSource)dssRevision.getCRLSource());
            validationContext.addDocumentOCSPSource((OfflineRevocationSource)dssRevision.getOCSPSource());
        }
    }

    protected List<AdvancedSignature> getAllSignatures() {
        List allSignatures = super.getAllSignatures();
        this.postProcessing(allSignatures);
        return allSignatures;
    }

    protected void postProcessing(List<AdvancedSignature> signatures) {
        PDFSignatureService pdfSignatureService = this.pdfObjectFactory.newPAdESSignatureService();
        pdfSignatureService.analyzePdfModifications(this.document, signatures, this.passwordProtection);
    }

    public List<TimestampToken> getDetachedTimestamps() {
        List detachedTimestamps = super.getDetachedTimestamps();
        this.timestampPostProcessing(detachedTimestamps);
        return detachedTimestamps;
    }

    protected void timestampPostProcessing(List<TimestampToken> timestampTokens) {
        PDFSignatureService pdfSignatureService = this.pdfObjectFactory.newPAdESSignatureService();
        pdfSignatureService.analyzeTimestampPdfModifications(this.document, timestampTokens, this.passwordProtection);
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<PAdESSignature> signatures = new ArrayList<PAdESSignature>();
        ListCertificateSource dssCertificateSource = new ListCertificateSource();
        ListRevocationSource dssCRLSource = new ListRevocationSource();
        ListRevocationSource dssOCSPSource = new ListRevocationSource();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (pdfRevision instanceof PdfDocDssRevision) {
                PdfDocDssRevision docDssRevision = (PdfDocDssRevision)pdfRevision;
                dssCertificateSource.add((CertificateSource)docDssRevision.getCertificateSource());
                dssCRLSource.add((OfflineRevocationSource)docDssRevision.getCRLSource());
                dssOCSPSource.add((OfflineRevocationSource)docDssRevision.getOCSPSource());
                continue;
            }
            if (!(pdfRevision instanceof PdfSignatureRevision)) continue;
            PdfSignatureRevision pdfSignatureRevision = (PdfSignatureRevision)pdfRevision;
            try {
                PAdESSignature padesSignature = new PAdESSignature(pdfSignatureRevision, this.documentRevisions);
                padesSignature.setSignatureFilename(this.document.getName());
                padesSignature.setSigningCertificateSource(this.signingCertificateSource);
                ListCertificateSource listCertificateSource = new ListCertificateSource();
                listCertificateSource.addAll(dssCertificateSource);
                padesSignature.setDssCertificateSource(listCertificateSource);
                ListRevocationSource listCRLSource = new ListRevocationSource();
                listCRLSource.addAll(dssCRLSource);
                padesSignature.setDssCRLSource((ListRevocationSource<CRL>)listCRLSource);
                ListRevocationSource listOCSPSource = new ListRevocationSource();
                listOCSPSource.addAll(dssOCSPSource);
                padesSignature.setDssOCSPSource((ListRevocationSource<OCSP>)listOCSPSource);
                if (this.certificateVerifier != null) {
                    padesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                }
                signatures.add(padesSignature);
            }
            catch (Exception e) {
                throw new DSSException(String.format("Unable to collect a signature. Reason : [%s]", e.getMessage()), (Throwable)e);
            }
        }
        return Utils.reverseList(signatures);
    }

    protected List<TimestampToken> buildDetachedTimestamps() {
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        ArrayList<TimestampedReference> coveredReferences = new ArrayList<TimestampedReference>();
        ListCertificateSource certificateSource = new ListCertificateSource();
        ListRevocationSource crlSource = new ListRevocationSource();
        ListRevocationSource ocspSource = new ListRevocationSource();
        for (PdfRevision pdfRevision : Utils.reverseList(this.getRevisions())) {
            if (pdfRevision instanceof PdfDocTimestampRevision) {
                PdfDocTimestampRevision pdfDocTimestampRevision = (PdfDocTimestampRevision)pdfRevision;
                TimestampToken timestampToken = this.createPdfTimestampToken(pdfDocTimestampRevision);
                certificateSource.add((CertificateSource)timestampToken.getCertificateSource());
                crlSource.add((OfflineRevocationSource)timestampToken.getCRLSource());
                ocspSource.add((OfflineRevocationSource)timestampToken.getOCSPSource());
                DSSUtils.enrichCollection((Collection)timestampToken.getTimestampedReferences(), coveredReferences);
                timestamps.add(timestampToken);
            } else if (pdfRevision instanceof PdfDocDssRevision) {
                PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)pdfRevision;
                certificateSource.add((CertificateSource)pdfDocDssRevision.getCertificateSource());
                crlSource.add((OfflineRevocationSource)pdfDocDssRevision.getCRLSource());
                ocspSource.add((OfflineRevocationSource)pdfDocDssRevision.getOCSPSource());
            } else if (pdfRevision instanceof PdfSignatureRevision) break;
            PdfRevisionTimestampSource pdfRevisionTimestampSource = new PdfRevisionTimestampSource(pdfRevision, certificateSource, (ListRevocationSource<CRL>)crlSource, (ListRevocationSource<OCSP>)ocspSource);
            coveredReferences.addAll(pdfRevisionTimestampSource.getIncorporatedReferences());
        }
        return timestamps;
    }

    private TimestampToken createPdfTimestampToken(PdfDocTimestampRevision pdfDocTimestampRevision) {
        try {
            PdfTimestampToken timestampToken = pdfDocTimestampRevision.getTimestampToken();
            timestampToken.setFileName(this.document.getName());
            PAdESTimestampScopeFinder timestampScopeFinder = this.getPAdESTimestampScopeFinder();
            timestampScopeFinder.setDefaultDigestAlgorithm(this.getDefaultDigestAlgorithm());
            this.findTimestampScopes(timestampToken, timestampScopeFinder);
            return timestampToken;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to create a timestamp for a revision : %s. Reason : [%s]", pdfDocTimestampRevision.getByteRange(), e.getMessage()), (Throwable)e);
        }
    }

    public <T extends AdvancedSignature> void findSignatureScopes(Collection<T> allSignatures) {
        super.findSignatureScopes(allSignatures);
        for (AdvancedSignature signature : allSignatures) {
            PAdESTimestampScopeFinder timestampScopeFinder = this.getPAdESTimestampScopeFinder();
            this.prepareTimestampScopeFinder(timestampScopeFinder, signature);
            for (TimestampToken timestampToken : signature.getDocumentTimestamps()) {
                this.findTimestampScopes(timestampToken, timestampScopeFinder);
            }
        }
    }

    protected PAdESTimestampScopeFinder getPAdESTimestampScopeFinder() {
        return new PAdESTimestampScopeFinder();
    }

    public List<PdfDssDict> getDssDictionaries() {
        ArrayList<PdfDssDict> dssDicts = new ArrayList<PdfDssDict>();
        for (PdfDocDssRevision dssRevision : this.getDssRevisions()) {
            dssDicts.add(dssRevision.getDssDictionary());
        }
        return dssDicts;
    }

    protected List<PdfDocDssRevision> getDssRevisions() {
        ArrayList<PdfDocDssRevision> dssRevisions = new ArrayList<PdfDocDssRevision>();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (!(pdfRevision instanceof PdfDocDssRevision)) continue;
            dssRevisions.add((PdfDocDssRevision)pdfRevision);
        }
        return Utils.reverseList(dssRevisions);
    }

    protected List<PdfRevision> getRevisions() {
        if (this.documentRevisions == null) {
            PDFSignatureService pdfSignatureService = this.pdfObjectFactory.newPAdESSignatureService();
            this.documentRevisions = pdfSignatureService.getRevisions(this.document, this.passwordProtection);
        }
        return this.documentRevisions;
    }

    public <T extends AdvancedSignature> PdfValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        return (PdfValidationDataContainer)super.getValidationData(signatures, detachedTimestamps);
    }

    protected PdfValidationDataContainer instantiateValidationDataContainer() {
        return new PdfValidationDataContainer(this.getDssRevisions());
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        PAdESSignature padesSignature = (PAdESSignature)advancedSignature;
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        DSSDocument originalPDF = PAdESUtils.getOriginalPDF(padesSignature);
        if (originalPDF != null && !DSSUtils.isEmpty((DSSDocument)originalPDF)) {
            result.add(originalPDF);
        }
        return result;
    }
}

