/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlQuery;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlSelectQuery;
import eu.europa.esig.dss.spi.client.jdbc.record.SqlRecord;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcCacheCRLSource
extends JdbcRevocationSource<CRL>
implements CRLSource {
    private static final long serialVersionUID = 3007740140330998336L;
    private static final SqlQuery SQL_INIT_CHECK_EXISTENCE = SqlQuery.createQuery((String)"SELECT COUNT(*) FROM CACHED_CRL");
    private static final SqlQuery SQL_INIT_CREATE_TABLE = SqlQuery.createQuery((String)"CREATE TABLE CACHED_CRL (ID CHAR(40), DATA BLOB, ISSUER LONGVARBINARY)");
    private static final SqlQuery SQL_DROP_TABLE = SqlQuery.createQuery((String)"DROP TABLE CACHED_CRL");
    private static final SqlQuery SQL_FIND_INSERT = SqlQuery.createQuery((String)"INSERT INTO CACHED_CRL (ID, DATA, ISSUER) VALUES (?, ?, ?)");
    private static final SqlQuery SQL_FIND_UPDATE = SqlQuery.createQuery((String)"UPDATE CACHED_CRL SET DATA = ?, ISSUER = ?  WHERE ID = ?");
    private static final SqlQuery SQL_FIND_REMOVE = SqlQuery.createQuery((String)"DELETE FROM CACHED_CRL WHERE ID = ?");
    private static final SqlSelectQuery SQL_FIND_QUERY = new SqlSelectQuery("SELECT * FROM CACHED_CRL WHERE ID = ?"){

        public SqlCRLRecord getRecord(ResultSet rs) throws SQLException {
            SqlCRLRecord response = new SqlCRLRecord();
            response.id = rs.getString("ID");
            response.crlBinary = rs.getBytes("DATA");
            response.certificateIssuerBinary = rs.getBytes("ISSUER");
            return response;
        }
    };

    protected SqlQuery getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    protected SqlQuery getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    protected SqlQuery getInsertRevocationTokenEntryQuery() {
        return SQL_FIND_INSERT;
    }

    protected SqlQuery getUpdateRevocationTokenEntryQuery() {
        return SQL_FIND_UPDATE;
    }

    protected SqlQuery getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    protected SqlQuery getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    protected SqlSelectQuery getRevocationDataExtractQuery() {
        return SQL_FIND_QUERY;
    }

    protected List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        return DSSRevocationUtils.getCRLRevocationTokenKeys((CertificateToken)certificateToken);
    }

    protected RevocationToken<CRL> buildRevocationTokenFromResult(SqlRecord response, CertificateToken certificateToken, CertificateToken issuerCertificateToken) throws DSSExternalResourceException {
        try {
            SqlCRLRecord crlResponse = (SqlCRLRecord)response;
            CRLBinary crlBinary = CRLUtils.buildCRLBinary((byte[])crlResponse.crlBinary);
            CertificateToken cachedIssuerCertificate = DSSUtils.loadCertificate((byte[])crlResponse.certificateIssuerBinary);
            CRLValidity cached = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)cachedIssuerCertificate);
            cached.setIssuerToken(cachedIssuerCertificate);
            CRLToken crlToken = new CRLToken(certificateToken, cached);
            crlToken.setExternalOrigin(RevocationOrigin.CACHED);
            return crlToken;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to get a revocation token. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    protected void insertRevocation(String revocationKey, RevocationToken<CRL> token) {
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        this.getJdbcCacheConnector().execute(this.getInsertRevocationTokenEntryQuery(), new Object[]{revocationKey, crlValidity.getDerEncoded(), crlValidity.getIssuerToken().getEncoded()});
    }

    protected void updateRevocation(String revocationKey, RevocationToken<CRL> token) {
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        this.getJdbcCacheConnector().execute(this.getUpdateRevocationTokenEntryQuery(), new Object[]{crlValidity.getDerEncoded(), crlValidity.getIssuerToken().getEncoded(), revocationKey});
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    protected String getRevocationTokenKey(CertificateToken certificateToken, String urlString) {
        return DSSRevocationUtils.getCRLRevocationTokenKey((String)urlString);
    }

    protected static class SqlCRLRecord
    implements SqlRecord {
        protected String id;
        protected byte[] crlBinary;
        protected byte[] certificateIssuerBinary;

        protected SqlCRLRecord() {
        }
    }
}

