/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.dto.parameters;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.TimestampDTO;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteBLevelParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureImageParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RemoteSignatureParameters
implements Serializable {
    private RemoteCertificate signingCertificate;
    private List<RemoteCertificate> certificateChain = new ArrayList<RemoteCertificate>();
    private List<RemoteDocument> detachedContents;
    private ASiCContainerType asicContainerType;
    private SignatureLevel signatureLevel;
    private RemoteBLevelParameters bLevelParams = new RemoteBLevelParameters();
    private SignaturePackaging signaturePackaging;
    private boolean embedXML;
    private boolean manifestSignature;
    private JWSSerializationType jwsSerializationType;
    private SigDMechanism sigDMechanism;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SHA256;
    private DigestAlgorithm digestAlgorithm = this.signatureAlgorithm.getDigestAlgorithm();
    private EncryptionAlgorithm encryptionAlgorithm = this.signatureAlgorithm.getEncryptionAlgorithm();
    private DigestAlgorithm referenceDigestAlgorithm;
    private MaskGenerationFunction maskGenerationFunction = this.signatureAlgorithm.getMaskGenerationFunction();
    private List<TimestampDTO> contentTimestamps;
    private RemoteTimestampParameters contentTimestampParameters;
    private RemoteTimestampParameters signatureTimestampParameters;
    private RemoteTimestampParameters archiveTimestampParameters;
    private boolean signWithExpiredCertificate = false;
    private boolean generateTBSWithoutCertificate = false;
    private RemoteSignatureImageParameters imageParameters;
    private String signatureIdToCounterSign;

    public RemoteCertificate getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(RemoteCertificate signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public List<RemoteCertificate> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<RemoteCertificate> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public List<RemoteDocument> getDetachedContents() {
        return this.detachedContents;
    }

    public void setDetachedContents(List<RemoteDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    public ASiCContainerType getAsicContainerType() {
        return this.asicContainerType;
    }

    public void setAsicContainerType(ASiCContainerType asicContainerType) {
        this.asicContainerType = asicContainerType;
    }

    public SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "signatureLevel must be defined!");
        this.signatureLevel = signatureLevel;
    }

    public boolean isEmbedXML() {
        return this.embedXML;
    }

    public void setEmbedXML(boolean embedXML) {
        this.embedXML = embedXML;
    }

    public boolean isManifestSignature() {
        return this.manifestSignature;
    }

    public void setManifestSignature(boolean manifestSignature) {
        this.manifestSignature = manifestSignature;
    }

    public JWSSerializationType getJwsSerializationType() {
        return this.jwsSerializationType;
    }

    public void setJwsSerializationType(JWSSerializationType jwsSerializationType) {
        this.jwsSerializationType = jwsSerializationType;
    }

    public SigDMechanism getSigDMechanism() {
        return this.sigDMechanism;
    }

    public void setSigDMechanism(SigDMechanism sigDMechanism) {
        this.sigDMechanism = sigDMechanism;
    }

    public DigestAlgorithm getReferenceDigestAlgorithm() {
        return this.referenceDigestAlgorithm;
    }

    public void setReferenceDigestAlgorithm(DigestAlgorithm referenceDigestAlgorithm) {
        this.referenceDigestAlgorithm = referenceDigestAlgorithm;
    }

    public RemoteBLevelParameters getBLevelParams() {
        return this.bLevelParams;
    }

    public void setBLevelParams(RemoteBLevelParameters bLevelParams) {
        this.bLevelParams = bLevelParams;
    }

    public SignaturePackaging getSignaturePackaging() {
        return this.signaturePackaging;
    }

    public void setSignaturePackaging(SignaturePackaging signaturePackaging) {
        this.signaturePackaging = signaturePackaging;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        if (this.digestAlgorithm != null && this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm, (MaskGenerationFunction)this.maskGenerationFunction);
        }
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        if (this.digestAlgorithm != null && this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm, (MaskGenerationFunction)this.maskGenerationFunction);
        }
    }

    public void setMaskGenerationFunction(MaskGenerationFunction maskGenerationFunction) {
        this.maskGenerationFunction = maskGenerationFunction;
        if (this.digestAlgorithm != null && this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm, (MaskGenerationFunction)this.maskGenerationFunction);
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public MaskGenerationFunction getMaskGenerationFunction() {
        return this.maskGenerationFunction;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public List<TimestampDTO> getContentTimestamps() {
        return this.contentTimestamps;
    }

    public void setContentTimestamps(List<TimestampDTO> contentTimestamps) {
        this.contentTimestamps = contentTimestamps;
    }

    public RemoteTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new RemoteTimestampParameters();
        }
        return this.contentTimestampParameters;
    }

    public void setContentTimestampParameters(RemoteTimestampParameters contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters;
    }

    public RemoteTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new RemoteTimestampParameters();
        }
        return this.signatureTimestampParameters;
    }

    public void setSignatureTimestampParameters(RemoteTimestampParameters signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters;
    }

    public RemoteTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new RemoteTimestampParameters();
        }
        return this.archiveTimestampParameters;
    }

    public void setArchiveTimestampParameters(RemoteTimestampParameters archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters;
    }

    public boolean isSignWithExpiredCertificate() {
        return this.signWithExpiredCertificate;
    }

    public void setSignWithExpiredCertificate(boolean signWithExpiredCertificate) {
        this.signWithExpiredCertificate = signWithExpiredCertificate;
    }

    public boolean isGenerateTBSWithoutCertificate() {
        return this.generateTBSWithoutCertificate;
    }

    public void setGenerateTBSWithoutCertificate(boolean generateTBSWithoutCertificate) {
        this.generateTBSWithoutCertificate = generateTBSWithoutCertificate;
    }

    public RemoteSignatureImageParameters getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(RemoteSignatureImageParameters imageParameters) {
        this.imageParameters = imageParameters;
    }

    public String getSignatureIdToCounterSign() {
        return this.signatureIdToCounterSign;
    }

    public void setSignatureIdToCounterSign(String signatureIdToCounterSign) {
        this.signatureIdToCounterSign = signatureIdToCounterSign;
    }

    public String toString() {
        return "RemoteSignatureParameters [signWithExpiredCertificate=" + this.signWithExpiredCertificate + ", signatureLevel=" + this.signatureLevel + ", generateTBSWithoutCertificate=" + this.generateTBSWithoutCertificate + ", signaturePackaging=" + this.signaturePackaging + ", signatureAlgorithm=" + this.signatureAlgorithm + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", digestAlgorithm=" + this.digestAlgorithm + ", referenceDigestAlgorithm=" + this.referenceDigestAlgorithm + ", maskGenerationFunction=" + this.maskGenerationFunction + ", bLevelParams=" + this.bLevelParams + ", contentTimestampParameters=" + this.contentTimestampParameters + ", signatureTimestampParameters=" + this.signatureTimestampParameters + ", archiveTimestampParameters=" + this.archiveTimestampParameters + ", imageParameters=" + this.imageParameters + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archiveTimestampParameters == null ? 0 : this.archiveTimestampParameters.hashCode());
        result = 31 * result + (this.asicContainerType == null ? 0 : this.asicContainerType.hashCode());
        result = 31 * result + (this.bLevelParams == null ? 0 : this.bLevelParams.hashCode());
        result = 31 * result + (this.certificateChain == null ? 0 : this.certificateChain.hashCode());
        result = 31 * result + (this.contentTimestampParameters == null ? 0 : this.contentTimestampParameters.hashCode());
        result = 31 * result + (this.contentTimestamps == null ? 0 : this.contentTimestamps.hashCode());
        result = 31 * result + (this.detachedContents == null ? 0 : this.detachedContents.hashCode());
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        result = 31 * result + (this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode());
        result = 31 * result + (this.generateTBSWithoutCertificate ? 1231 : 1237);
        result = 31 * result + (this.imageParameters == null ? 0 : this.imageParameters.hashCode());
        result = 31 * result + (this.embedXML ? 1231 : 1237);
        result = 31 * result + (this.manifestSignature ? 1231 : 1237);
        result = 31 * result + (this.jwsSerializationType == null ? 0 : this.jwsSerializationType.hashCode());
        result = 31 * result + (this.maskGenerationFunction == null ? 0 : this.maskGenerationFunction.hashCode());
        result = 31 * result + (this.referenceDigestAlgorithm == null ? 0 : this.referenceDigestAlgorithm.hashCode());
        result = 31 * result + (this.signWithExpiredCertificate ? 1231 : 1237);
        result = 31 * result + (this.signatureAlgorithm == null ? 0 : this.signatureAlgorithm.hashCode());
        result = 31 * result + (this.signatureLevel == null ? 0 : this.signatureLevel.hashCode());
        result = 31 * result + (this.signaturePackaging == null ? 0 : this.signaturePackaging.hashCode());
        result = 31 * result + (this.signatureTimestampParameters == null ? 0 : this.signatureTimestampParameters.hashCode());
        result = 31 * result + (this.signingCertificate == null ? 0 : this.signingCertificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteSignatureParameters other = (RemoteSignatureParameters)obj;
        if (!Objects.equals(this.archiveTimestampParameters, other.archiveTimestampParameters)) {
            return false;
        }
        if (this.asicContainerType != other.asicContainerType) {
            return false;
        }
        if (!Objects.equals(this.bLevelParams, other.bLevelParams)) {
            return false;
        }
        if (!Objects.equals(this.certificateChain, other.certificateChain)) {
            return false;
        }
        if (!Objects.equals(this.contentTimestampParameters, other.contentTimestampParameters)) {
            return false;
        }
        if (!Objects.equals(this.contentTimestamps, other.contentTimestamps)) {
            return false;
        }
        if (!Objects.equals(this.detachedContents, other.detachedContents)) {
            return false;
        }
        if (this.digestAlgorithm != other.digestAlgorithm) {
            return false;
        }
        if (this.encryptionAlgorithm != other.encryptionAlgorithm) {
            return false;
        }
        if (this.generateTBSWithoutCertificate != other.generateTBSWithoutCertificate) {
            return false;
        }
        if (!Objects.equals(this.imageParameters, other.imageParameters)) {
            return false;
        }
        if (this.embedXML != other.embedXML) {
            return false;
        }
        if (this.manifestSignature != other.manifestSignature) {
            return false;
        }
        if (this.jwsSerializationType != other.jwsSerializationType) {
            return false;
        }
        if (this.maskGenerationFunction != other.maskGenerationFunction) {
            return false;
        }
        if (this.referenceDigestAlgorithm != other.referenceDigestAlgorithm) {
            return false;
        }
        if (this.signWithExpiredCertificate != other.signWithExpiredCertificate) {
            return false;
        }
        if (this.signatureAlgorithm != other.signatureAlgorithm) {
            return false;
        }
        if (this.signatureLevel != other.signatureLevel) {
            return false;
        }
        if (this.signaturePackaging != other.signaturePackaging) {
            return false;
        }
        if (!Objects.equals(this.signatureTimestampParameters, other.signatureTimestampParameters)) {
            return false;
        }
        return Objects.equals(this.signingCertificate, other.signingCertificate);
    }
}

