/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.ExternalCMSService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.DigestDTO;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteExternalCMSService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExternalCMSServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteExternalCMSService {
    private static final long serialVersionUID = -8128859790984520949L;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteExternalCMSServiceImpl.class);
    private ExternalCMSService service;

    public void setService(ExternalCMSService service) {
        this.service = service;
    }

    @Override
    public ToBeSignedDTO getDataToSign(DigestDTO messageDigestDTO, RemoteSignatureParameters parameters) {
        Objects.requireNonNull(this.service, "PAdESExternalCMSSignatureService must be defined!");
        Objects.requireNonNull(messageDigestDTO, "MessageDigest must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        this.assertPAdESParameters(parameters);
        LOG.info("GetDataToSign in process...");
        DSSMessageDigest messageDigest = this.toMessageDigest(messageDigestDTO);
        PAdESSignatureParameters padesParameters = (PAdESSignatureParameters)this.createParameters(parameters);
        ToBeSigned dataToSign = this.service.getDataToSign(messageDigest, padesParameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO((ToBeSigned)dataToSign);
    }

    @Override
    public RemoteDocument signMessageDigest(DigestDTO messageDigestDTO, RemoteSignatureParameters parameters, SignatureValueDTO signatureValueDTO) {
        Objects.requireNonNull(this.service, "PAdESExternalCMSSignatureService must be defined!");
        Objects.requireNonNull(messageDigestDTO, "MessageDigest must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        Objects.requireNonNull(signatureValueDTO, "SignatureValue must be defined!");
        this.assertPAdESParameters(parameters);
        LOG.info("SignMessageDigest in process...");
        DSSMessageDigest messageDigest = this.toMessageDigest(messageDigestDTO);
        PAdESSignatureParameters padesParameters = (PAdESSignatureParameters)this.createParameters(parameters);
        SignatureValue signatureValue = DTOConverter.toSignatureValue((SignatureValueDTO)signatureValueDTO);
        CMSSignedDocument cmsSignature = this.service.signMessageDigest(messageDigest, padesParameters, signatureValue);
        LOG.info("SignMessageDigest is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)cmsSignature);
    }

    private DSSMessageDigest toMessageDigest(DigestDTO digest) {
        if (digest != null) {
            return new DSSMessageDigest(digest.getAlgorithm(), digest.getValue());
        }
        return null;
    }

    private void assertPAdESParameters(RemoteSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureLevel(), "signatureLevel must be defined!");
        if (!SignatureForm.PAdES.equals((Object)parameters.getSignatureLevel().getSignatureForm())) {
            throw new UnsupportedOperationException("PAdES signature form is required! Please update SignatureLevel within parameters.");
        }
    }
}

