/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESWithExternalCMSService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.DigestDTO;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemotePAdESWithExternalCMSService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePAdESWithExternalCMSServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemotePAdESWithExternalCMSService {
    private static final long serialVersionUID = -5681970320686504972L;
    private static final Logger LOG = LoggerFactory.getLogger(RemotePAdESWithExternalCMSServiceImpl.class);
    private PAdESWithExternalCMSService service;

    public void setService(PAdESWithExternalCMSService service) {
        this.service = service;
    }

    @Override
    public DigestDTO getMessageDigest(RemoteDocument toSignDocument, RemoteSignatureParameters parameters) {
        Objects.requireNonNull(this.service, "PAdESExternalCMSSignatureService must be defined!");
        Objects.requireNonNull(toSignDocument, "toSignDocument must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        this.assertPAdESParameters(parameters);
        LOG.info("GetMessageDigest in process...");
        DSSDocument document = RemoteDocumentConverter.toDSSDocument((RemoteDocument)toSignDocument);
        PAdESSignatureParameters padesParameters = (PAdESSignatureParameters)this.createParameters(parameters);
        DSSMessageDigest digestToSign = this.service.getMessageDigest(document, padesParameters);
        LOG.info("GetMessageDigest is finished");
        return DTOConverter.toDigestDTO((Digest)digestToSign);
    }

    @Override
    public RemoteDocument signDocument(RemoteDocument toSignDocument, RemoteSignatureParameters parameters, RemoteDocument cmsSignature) {
        Objects.requireNonNull(this.service, "PAdESExternalCMSSignatureService must be defined!");
        Objects.requireNonNull(toSignDocument, "toSignDocument must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        this.assertPAdESParameters(parameters);
        LOG.info("SignDocument in process...");
        DSSDocument document = RemoteDocumentConverter.toDSSDocument((RemoteDocument)toSignDocument);
        PAdESSignatureParameters padesParameters = (PAdESSignatureParameters)this.createParameters(parameters);
        DSSDocument cmsDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)cmsSignature);
        DSSDocument signedDocument = this.service.signDocument(document, padesParameters, cmsDocument);
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)signedDocument);
    }

    private void assertPAdESParameters(RemoteSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureLevel(), "signatureLevel must be defined!");
        if (!SignatureForm.PAdES.equals((Object)parameters.getSignatureLevel().getSignatureForm())) {
            throw new UnsupportedOperationException("PAdES signature form is required! Please update SignatureLevel within parameters.");
        }
    }
}

