/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteCertificateConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.dto.exception.DSSRemoteServiceException;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteTrustedListSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTrustedListSignatureParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import eu.europa.esig.dss.xades.tsl.TrustedListV5SignatureParametersBuilder;
import eu.europa.esig.dss.xades.tsl.TrustedListV6SignatureParametersBuilder;
import eu.europa.esig.dss.xades.tsl.XAdESTrustedListUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTrustedListSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteTrustedListSignatureService {
    private static final long serialVersionUID = 1029264702356172700L;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTrustedListSignatureServiceImpl.class);
    private XAdESService xadesService;

    public void setXadesService(XAdESService xadesService) {
        this.xadesService = xadesService;
    }

    @Override
    public ToBeSignedDTO getDataToSign(RemoteDocument trustedList, RemoteTrustedListSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(this.xadesService, "XAdESService must be defined!");
        Objects.requireNonNull(trustedList, "Trusted List must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        Objects.requireNonNull(parameters.getSigningCertificate(), "Signing Certificate must be defined!");
        LOG.info("GetDataToSign in process...");
        DSSDocument tlDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)trustedList);
        XAdESSignatureParameters signatureParameters = this.createParameters(tlDocument, parameters);
        ToBeSigned dataToSign = this.xadesService.getDataToSign(tlDocument, signatureParameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO((ToBeSigned)dataToSign);
    }

    @Override
    public RemoteDocument signDocument(RemoteDocument trustedList, RemoteTrustedListSignatureParameters parameters, SignatureValueDTO signatureValue) throws DSSException {
        Objects.requireNonNull(this.xadesService, "XAdESService must be defined!");
        Objects.requireNonNull(trustedList, "Trusted List must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        Objects.requireNonNull(parameters.getSigningCertificate(), "Signing Certificate must be defined!");
        Objects.requireNonNull(signatureValue, "Signature Value must be defined!");
        LOG.info("SignDocument in process...");
        DSSDocument tlDocument = RemoteDocumentConverter.toDSSDocument((RemoteDocument)trustedList);
        XAdESSignatureParameters signatureParameters = this.createParameters(tlDocument, parameters);
        DSSDocument signDocument = this.xadesService.signDocument(tlDocument, signatureParameters, this.toSignatureValue(signatureValue));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument((DSSDocument)signDocument);
    }

    private XAdESSignatureParameters createParameters(DSSDocument tlDocument, RemoteTrustedListSignatureParameters parameters) {
        TrustedListV5SignatureParametersBuilder tlParametersBuilder;
        CertificateToken certificateToken = RemoteCertificateConverter.toCertificateToken((RemoteCertificate)parameters.getSigningCertificate());
        if (parameters.getTlVersion() == null) {
            LOG.warn("Please provide a signatureParameters.tlVersion parameter! The XML Trusted List V5 is set by default.");
            tlParametersBuilder = new TrustedListV5SignatureParametersBuilder(certificateToken, tlDocument);
        } else {
            if (!this.isValidTlVersion(parameters.getTlVersion())) {
                throw new DSSRemoteServiceException(String.format("The TlVersion parameter shall be represented by a valid integer! Obtained value '%s'.", parameters.getTlVersion()));
            }
            Integer tlVersion = Integer.valueOf(parameters.getTlVersion());
            if (XAdESTrustedListUtils.TL_V5_IDENTIFIER.equals(tlVersion)) {
                tlParametersBuilder = new TrustedListV5SignatureParametersBuilder(certificateToken, tlDocument);
            } else if (XAdESTrustedListUtils.TL_V6_IDENTIFIER.equals(tlVersion)) {
                tlParametersBuilder = new TrustedListV6SignatureParametersBuilder(certificateToken, tlDocument);
            } else {
                throw new DSSRemoteServiceException(String.format("Unsupported TLVersionIdentifier '%s'!", parameters.getTlVersion()));
            }
        }
        tlParametersBuilder.assertConfigurationIsValid();
        if (parameters.getEncryptionAlgorithm() != null) {
            tlParametersBuilder.setEncryptionAlgorithm(parameters.getEncryptionAlgorithm());
        }
        if (parameters.getDigestAlgorithm() != null) {
            tlParametersBuilder.setDigestAlgorithm(parameters.getDigestAlgorithm());
        }
        if (parameters.getBLevelParameters() != null) {
            tlParametersBuilder.setBLevelParams(this.toBLevelParameters(parameters.getBLevelParameters()));
        }
        if (parameters.getReferenceId() != null) {
            tlParametersBuilder.setReferenceId(parameters.getReferenceId());
        }
        if (parameters.getReferenceDigestAlgorithm() != null) {
            tlParametersBuilder.setReferenceDigestAlgorithm(parameters.getReferenceDigestAlgorithm());
        }
        return tlParametersBuilder.build();
    }

    private boolean isValidTlVersion(String tlVersion) {
        if (Utils.isStringDigits((String)tlVersion)) {
            try {
                return Integer.valueOf(tlVersion) != null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

