/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryDataLoader
implements DataLoader {
    private static final long serialVersionUID = -2899281917849499181L;
    private Map<String, byte[]> dataMap = new HashMap<String, byte[]>();

    public MemoryDataLoader(Map<String, byte[]> dataMap) {
        this.dataMap.putAll(dataMap);
    }

    @Override
    public byte[] get(String url) {
        return this.dataMap.get(url);
    }

    @Override
    public DataLoader.DataAndUrl get(List<String> urlStrings) throws DSSException {
        for (String url : urlStrings) {
            byte[] data = this.get(url);
            if (data == null) continue;
            return new DataLoader.DataAndUrl(url, data);
        }
        throw new DSSExternalResourceException(String.format("A content for URLs [%s] does not exist!", urlStrings));
    }

    @Override
    @Deprecated
    public byte[] get(String url, boolean refresh) {
        return this.get(url);
    }

    @Override
    public byte[] post(String url, byte[] content) {
        return this.get(url);
    }

    @Override
    public void setContentType(String contentType) {
        throw new UnsupportedOperationException("Content type change is not supported by this implementation!");
    }
}

