/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.CertificateExtensionEnum;
import eu.europa.esig.dss.enumerations.GeneralNameType;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.extension.AuthorityInformationAccess;
import eu.europa.esig.dss.model.x509.extension.BasicConstraints;
import eu.europa.esig.dss.model.x509.extension.CRLDistributionPoints;
import eu.europa.esig.dss.model.x509.extension.CertificateExtension;
import eu.europa.esig.dss.model.x509.extension.CertificateExtensions;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicies;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicy;
import eu.europa.esig.dss.model.x509.extension.ExtendedKeyUsages;
import eu.europa.esig.dss.model.x509.extension.GeneralSubtree;
import eu.europa.esig.dss.model.x509.extension.InhibitAnyPolicy;
import eu.europa.esig.dss.model.x509.extension.KeyUsage;
import eu.europa.esig.dss.model.x509.extension.NameConstraints;
import eu.europa.esig.dss.model.x509.extension.OCSPNoCheck;
import eu.europa.esig.dss.model.x509.extension.PolicyConstraints;
import eu.europa.esig.dss.model.x509.extension.QcStatements;
import eu.europa.esig.dss.model.x509.extension.SubjectAlternativeNames;
import eu.europa.esig.dss.model.x509.extension.ValidityAssuredShortTerm;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.QcStatementUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExtensionsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateExtensionsUtils.class);

    private CertificateExtensionsUtils() {
    }

    public static CertificateExtensions getCertificateExtensions(CertificateToken certificateToken) {
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        CertificateExtensionsUtils.setCertificateExtensions(certificateExtensions, certificateToken, certificateToken.getCertificate().getCriticalExtensionOIDs());
        CertificateExtensionsUtils.setCertificateExtensions(certificateExtensions, certificateToken, certificateToken.getCertificate().getNonCriticalExtensionOIDs());
        return certificateExtensions;
    }

    private static void setCertificateExtensions(CertificateExtensions certificateExtensions, CertificateToken certificateToken, Collection<String> extensionOIDs) {
        if (Utils.isCollectionNotEmpty(extensionOIDs)) {
            for (String oid : extensionOIDs) {
                if (CertificateExtensionsUtils.isSubjectAlternativeNames(oid)) {
                    certificateExtensions.setSubjectAlternativeNames(CertificateExtensionsUtils.getSubjectAlternativeNames(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isAuthorityKeyIdentifier(oid)) {
                    certificateExtensions.setAuthorityKeyIdentifier(CertificateExtensionsUtils.getAuthorityKeyIdentifier(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isSubjectKeyIdentifier(oid)) {
                    certificateExtensions.setSubjectKeyIdentifier(CertificateExtensionsUtils.getSubjectKeyIdentifier(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isAuthorityInformationAccess(oid)) {
                    certificateExtensions.setAuthorityInformationAccess(CertificateExtensionsUtils.getAuthorityInformationAccess(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isCRLDistributionPoints(oid)) {
                    certificateExtensions.setCRLDistributionPoints(CertificateExtensionsUtils.getCRLDistributionPoints(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isBasicConstraints(oid)) {
                    certificateExtensions.setBasicConstraints(CertificateExtensionsUtils.getBasicConstraints(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isNameConstraints(oid)) {
                    certificateExtensions.setNameConstraints(CertificateExtensionsUtils.getNameConstraints(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isPolicyConstraints(oid)) {
                    certificateExtensions.setPolicyConstraints(CertificateExtensionsUtils.getPolicyConstraints(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isInhibitAnyPolicy(oid)) {
                    certificateExtensions.setInhibitAnyPolicy(CertificateExtensionsUtils.getInhibitAnyPolicy(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isKeyUsage(oid)) {
                    certificateExtensions.setKeyUsage(CertificateExtensionsUtils.getKeyUsage(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isExtendedKeyUsage(oid)) {
                    certificateExtensions.setExtendedKeyUsage(CertificateExtensionsUtils.getExtendedKeyUsage(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isCertificatePolicies(oid)) {
                    certificateExtensions.setCertificatePolicies(CertificateExtensionsUtils.getCertificatePolicies(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isOcspNoCheck(oid)) {
                    certificateExtensions.setOcspNoCheck(CertificateExtensionsUtils.getOcspNoCheck(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isValidityAssuredShortTerm(oid)) {
                    certificateExtensions.setValidityAssuredShortTerm(CertificateExtensionsUtils.getValAssuredSTCerts(certificateToken));
                    continue;
                }
                if (CertificateExtensionsUtils.isQcStatements(oid)) {
                    certificateExtensions.setQcStatements(CertificateExtensionsUtils.getQcStatements(certificateToken));
                    continue;
                }
                certificateExtensions.addOtherExtension(CertificateExtensionsUtils.getOtherCertificateExtension(certificateToken, oid));
            }
        }
    }

    public static boolean isSubjectAlternativeNames(String oid) {
        return CertificateExtensionEnum.SUBJECT_ALTERNATIVE_NAME.getOid().equals(oid);
    }

    public static boolean isAuthorityKeyIdentifier(String oid) {
        return CertificateExtensionEnum.AUTHORITY_KEY_IDENTIFIER.getOid().equals(oid);
    }

    public static boolean isSubjectKeyIdentifier(String oid) {
        return CertificateExtensionEnum.SUBJECT_KEY_IDENTIFIER.getOid().equals(oid);
    }

    public static boolean isAuthorityInformationAccess(String oid) {
        return CertificateExtensionEnum.AUTHORITY_INFORMATION_ACCESS.getOid().equals(oid);
    }

    public static boolean isCRLDistributionPoints(String oid) {
        return CertificateExtensionEnum.CRL_DISTRIBUTION_POINTS.getOid().equals(oid);
    }

    public static boolean isBasicConstraints(String oid) {
        return CertificateExtensionEnum.BASIC_CONSTRAINTS.getOid().equals(oid);
    }

    public static boolean isNameConstraints(String oid) {
        return CertificateExtensionEnum.NAME_CONSTRAINTS.getOid().equals(oid);
    }

    public static boolean isPolicyConstraints(String oid) {
        return CertificateExtensionEnum.POLICY_CONSTRAINTS.getOid().equals(oid);
    }

    public static boolean isKeyUsage(String oid) {
        return CertificateExtensionEnum.KEY_USAGE.getOid().equals(oid);
    }

    public static boolean isExtendedKeyUsage(String oid) {
        return CertificateExtensionEnum.EXTENDED_KEY_USAGE.getOid().equals(oid);
    }

    public static boolean isInhibitAnyPolicy(String oid) {
        return CertificateExtensionEnum.INHIBIT_ANY_POLICY.getOid().equals(oid);
    }

    public static boolean isCertificatePolicies(String oid) {
        return CertificateExtensionEnum.CERTIFICATE_POLICIES.getOid().equals(oid);
    }

    public static boolean isOcspNoCheck(String oid) {
        return CertificateExtensionEnum.OCSP_NOCHECK.getOid().equals(oid);
    }

    public static boolean isValidityAssuredShortTerm(String oid) {
        return CertificateExtensionEnum.VALIDITY_ASSURED_SHORT_TERM.getOid().equals(oid);
    }

    public static boolean isQcStatements(String oid) {
        return CertificateExtensionEnum.QC_STATEMENTS.getOid().equals(oid);
    }

    public static SubjectAlternativeNames getSubjectAlternativeNames(CertificateToken certificateToken) {
        try {
            SubjectAlternativeNames subjectAlternateNames = new SubjectAlternativeNames();
            subjectAlternateNames.setOctets(certificateToken.getCertificate().getExtensionValue(subjectAlternateNames.getOid()));
            ArrayList<eu.europa.esig.dss.model.x509.extension.GeneralName> result = new ArrayList<eu.europa.esig.dss.model.x509.extension.GeneralName>();
            Collection<List<?>> subjectAlternativeNames = certificateToken.getCertificate().getSubjectAlternativeNames();
            if (Utils.isCollectionNotEmpty(subjectAlternativeNames)) {
                for (List<?> gn : subjectAlternativeNames) {
                    eu.europa.esig.dss.model.x509.extension.GeneralName generalName = CertificateExtensionsUtils.getGeneralName(gn);
                    if (generalName == null) continue;
                    result.add(generalName);
                }
            }
            subjectAlternateNames.setGeneralNames(result);
            subjectAlternateNames.checkCritical(certificateToken);
            return subjectAlternateNames;
        }
        catch (Exception e) {
            LOG.warn("Unable to extract SubjectAlternativeNames", (Throwable)e);
            return null;
        }
    }

    private static eu.europa.esig.dss.model.x509.extension.GeneralName getGeneralName(List<?> gn) {
        if (Utils.collectionSize(gn) == 2) {
            try {
                if (!(gn.get(0) instanceof Integer)) {
                    LOG.warn("Unable to load the alternative name. Reason : Invalid encoding!");
                    return null;
                }
                eu.europa.esig.dss.model.x509.extension.GeneralName generalName = new eu.europa.esig.dss.model.x509.extension.GeneralName();
                GeneralNameType type = GeneralNameType.fromIndex((int)((Integer)gn.get(0)));
                generalName.setGeneralNameType(type);
                Object value = gn.get(1);
                if (value instanceof String) {
                    String strValue = (String)value;
                    if (GeneralNameType.DIRECTORY_NAME.equals((Object)type)) {
                        strValue = CertificateExtensionsUtils.toRFC2253RDN(strValue);
                    }
                    generalName.setValue(strValue);
                } else if (value instanceof byte[]) {
                    generalName.setValue(CertificateExtensionsUtils.toHexEncoded((byte[])value));
                } else {
                    LOG.warn("Unable to load the alternative name. Reason : Unsupported value type!");
                    return null;
                }
                return generalName;
            }
            catch (Exception e) {
                LOG.warn("Unable to load the alternative name. Reason : {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            LOG.warn("Unable to load the alternative name. Reason : Invalid sequence length!");
        }
        return null;
    }

    private static String toRFC2253RDN(String value) {
        try {
            RDN[] rdns = RFC4519Style.INSTANCE.fromString(value);
            X500Principal x500Principal = new X500Principal(DSSASN1Utils.getDEREncoded((ASN1Encodable)new X500Name(rdns)));
            return new X500PrincipalHelper(x500Principal).getRFC2253();
        }
        catch (Exception e) {
            LOG.warn("Unable to build RDN! Reason: {}", (Object)e.getMessage(), (Object)e);
            return value;
        }
    }

    public static AuthorityInformationAccess getAuthorityInformationAccess(CertificateToken certificateToken) {
        byte[] authInfoAccessExtensionValue = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.AUTHORITY_INFORMATION_ACCESS.getOid());
        if (Utils.isArrayEmpty((byte[])authInfoAccessExtensionValue)) {
            return null;
        }
        try {
            ASN1Sequence asn1Sequence = DSSASN1Utils.getAsn1SequenceFromDerOctetString(authInfoAccessExtensionValue);
            if (asn1Sequence == null || asn1Sequence.size() == 0) {
                LOG.warn("Empty ASN1Sequence for AuthorityInformationAccess");
                return null;
            }
            AuthorityInformationAccess authorityInformationAccess = new AuthorityInformationAccess();
            authorityInformationAccess.setOctets(authInfoAccessExtensionValue);
            org.bouncycastle.asn1.x509.AuthorityInformationAccess aia = org.bouncycastle.asn1.x509.AuthorityInformationAccess.getInstance((Object)asn1Sequence);
            AccessDescription[] accessDescriptions = aia.getAccessDescriptions();
            authorityInformationAccess.setCaIssuers(CertificateExtensionsUtils.getAccessUrls(accessDescriptions, X509ObjectIdentifiers.id_ad_caIssuers));
            authorityInformationAccess.setOcsp(CertificateExtensionsUtils.getAccessUrls(accessDescriptions, X509ObjectIdentifiers.id_ad_ocsp));
            authorityInformationAccess.checkCritical(certificateToken);
            return authorityInformationAccess;
        }
        catch (Exception e) {
            LOG.warn("Unable to parse authorityInfoAccess", (Throwable)e);
            return null;
        }
    }

    private static List<String> getAccessUrls(AccessDescription[] accessDescriptions, ASN1ObjectIdentifier aiaOid) {
        ArrayList<String> locationsUrls = new ArrayList<String>();
        for (AccessDescription accessDescription : accessDescriptions) {
            GeneralName gn;
            String location;
            if (!aiaOid.equals((ASN1Primitive)accessDescription.getAccessMethod()) || (location = CertificateExtensionsUtils.parseGn(gn = accessDescription.getAccessLocation())) == null) continue;
            locationsUrls.add(location);
        }
        return locationsUrls;
    }

    public static List<String> getCAIssuersAccessUrls(CertificateToken certificate) {
        AuthorityInformationAccess aia = CertificateExtensionsUtils.getAuthorityInformationAccess(certificate);
        return aia != null ? aia.getCaIssuers() : Collections.emptyList();
    }

    public static List<String> getOCSPAccessUrls(CertificateToken certificate) {
        AuthorityInformationAccess aia = CertificateExtensionsUtils.getAuthorityInformationAccess(certificate);
        return aia != null ? aia.getOcsp() : Collections.emptyList();
    }

    public static eu.europa.esig.dss.model.x509.extension.AuthorityKeyIdentifier getAuthorityKeyIdentifier(CertificateToken certificateToken) {
        byte[] extensionValue = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.AUTHORITY_KEY_IDENTIFIER.getOid());
        if (Utils.isArrayEmpty((byte[])extensionValue)) {
            return null;
        }
        try {
            eu.europa.esig.dss.model.x509.extension.AuthorityKeyIdentifier authorityKeyIdentifier = new eu.europa.esig.dss.model.x509.extension.AuthorityKeyIdentifier();
            authorityKeyIdentifier.setOctets(extensionValue);
            ASN1Primitive extension = JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue);
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)extension);
            authorityKeyIdentifier.setKeyIdentifier(aki.getKeyIdentifier());
            if (aki.getAuthorityCertIssuer() != null && aki.getAuthorityCertSerialNumber() != null) {
                IssuerSerial issuerSerial = new IssuerSerial(aki.getAuthorityCertIssuer(), aki.getAuthorityCertSerialNumber());
                authorityKeyIdentifier.setAuthorityCertIssuerSerial(DSSASN1Utils.getDEREncoded((ASN1Encodable)issuerSerial));
            }
            authorityKeyIdentifier.checkCritical(certificateToken);
            return authorityKeyIdentifier;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to retrieve authority key identifier of a certificate. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static eu.europa.esig.dss.model.x509.extension.SubjectKeyIdentifier getSubjectKeyIdentifier(CertificateToken certificateToken) {
        byte[] extensionValue = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.SUBJECT_KEY_IDENTIFIER.getOid());
        if (Utils.isArrayEmpty((byte[])extensionValue)) {
            return null;
        }
        try {
            eu.europa.esig.dss.model.x509.extension.SubjectKeyIdentifier subjectKeyIdentifier = new eu.europa.esig.dss.model.x509.extension.SubjectKeyIdentifier();
            subjectKeyIdentifier.setOctets(extensionValue);
            ASN1Primitive extension = JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue);
            SubjectKeyIdentifier skiBC = SubjectKeyIdentifier.getInstance((Object)extension);
            subjectKeyIdentifier.setSki(skiBC.getKeyIdentifier());
            subjectKeyIdentifier.checkCritical(certificateToken);
            return subjectKeyIdentifier;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to retrieve subject key identifier of a certificate. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static CRLDistributionPoints getCRLDistributionPoints(CertificateToken certificateToken) {
        byte[] crlDistributionPointsBytes = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.CRL_DISTRIBUTION_POINTS.getOid());
        if (crlDistributionPointsBytes != null) {
            try {
                DistributionPoint[] distributionPoints;
                CRLDistributionPoints crlDistributionPoints = new CRLDistributionPoints();
                crlDistributionPoints.setOctets(crlDistributionPointsBytes);
                ArrayList<String> urls = new ArrayList<String>();
                ASN1Sequence asn1Sequence = DSSASN1Utils.getAsn1SequenceFromDerOctetString(crlDistributionPointsBytes);
                CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)asn1Sequence);
                for (DistributionPoint distributionPoint : distributionPoints = distPoint.getDistributionPoints()) {
                    GeneralName[] names;
                    DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                    if (0 != distributionPointName.getType()) continue;
                    GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
                    for (GeneralName name : names = generalNames.getNames()) {
                        String location = CertificateExtensionsUtils.parseGn(name);
                        if (location == null) continue;
                        urls.add(location);
                    }
                }
                crlDistributionPoints.setCrlUrls(urls);
                crlDistributionPoints.checkCritical(certificateToken);
                return crlDistributionPoints;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse cRLDistributionPoints", (Throwable)e);
            }
        }
        return null;
    }

    private static String parseGn(GeneralName gn) {
        try {
            if (6 == gn.getTagNo()) {
                ASN1String str = (ASN1String)((DERTaggedObject)gn.toASN1Primitive()).getBaseObject();
                return str.getString();
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to parse GN '{}'", (Object)gn, (Object)e);
        }
        return null;
    }

    public static List<String> getCRLAccessUrls(CertificateToken certificate) {
        CRLDistributionPoints crlDistributionPoints = CertificateExtensionsUtils.getCRLDistributionPoints(certificate);
        return crlDistributionPoints != null ? crlDistributionPoints.getCrlUrls() : Collections.emptyList();
    }

    public static BasicConstraints getBasicConstraints(CertificateToken certificateToken) {
        BasicConstraints basicConstraints = new BasicConstraints();
        basicConstraints.setOctets(certificateToken.getCertificate().getExtensionValue(basicConstraints.getOid()));
        int value = certificateToken.getCertificate().getBasicConstraints();
        basicConstraints.setCa(value != -1);
        basicConstraints.setPathLenConstraint(value);
        basicConstraints.checkCritical(certificateToken);
        return basicConstraints;
    }

    public static NameConstraints getNameConstraints(CertificateToken certificateToken) {
        byte[] nameConstraintsBinaries = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.NAME_CONSTRAINTS.getOid());
        if (Utils.isArrayNotEmpty((byte[])nameConstraintsBinaries)) {
            try {
                ASN1Sequence seq = DSSASN1Utils.getAsn1SequenceFromDerOctetString(nameConstraintsBinaries);
                org.bouncycastle.asn1.x509.NameConstraints bcNameConstraints = org.bouncycastle.asn1.x509.NameConstraints.getInstance((Object)seq);
                NameConstraints nameConstraints = new NameConstraints();
                nameConstraints.setOctets(nameConstraintsBinaries);
                nameConstraints.setPermittedSubtrees(CertificateExtensionsUtils.getGeneralSubtrees(bcNameConstraints.getPermittedSubtrees()));
                nameConstraints.setExcludedSubtrees(CertificateExtensionsUtils.getGeneralSubtrees(bcNameConstraints.getExcludedSubtrees()));
                nameConstraints.checkCritical(certificateToken);
                return nameConstraints;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse the nameConstraints extension '{}' : {}", new Object[]{Utils.toBase64((byte[])nameConstraintsBinaries), e.getMessage(), e});
            }
        }
        return null;
    }

    private static List<GeneralSubtree> getGeneralSubtrees(org.bouncycastle.asn1.x509.GeneralSubtree[] generalSubtrees) {
        if (Utils.isArrayEmpty((Object[])generalSubtrees)) {
            return Collections.emptyList();
        }
        ArrayList<GeneralSubtree> result = new ArrayList<GeneralSubtree>();
        for (org.bouncycastle.asn1.x509.GeneralSubtree bcGeneralSubtree : generalSubtrees) {
            GeneralSubtree generalSubtree = new GeneralSubtree();
            GeneralName generalName = bcGeneralSubtree.getBase();
            GeneralNameType generalNameType = GeneralNameType.fromIndex((int)generalName.getTagNo());
            if (generalNameType == null) {
                LOG.warn("Unsupported GeneralName type of index '{}'!", (Object)generalName.getTagNo());
                continue;
            }
            generalSubtree.setGeneralNameType(generalNameType);
            generalSubtree.setMinimum(bcGeneralSubtree.getMinimum());
            generalSubtree.setMaximum(bcGeneralSubtree.getMaximum());
            generalSubtree.setValue(CertificateExtensionsUtils.getStringValue(generalNameType, generalName.getName()));
            result.add(generalSubtree);
        }
        return result;
    }

    private static String getStringValue(GeneralNameType generalNameType, ASN1Encodable generalNameValue) {
        try {
            switch (generalNameType) {
                case OTHER_NAME: 
                case EDI_PARTY_NAME: 
                case X400_ADDRESS: {
                    return CertificateExtensionsUtils.toHexEncoded(generalNameValue);
                }
                case RFC822_NAME: 
                case DNS_NAME: 
                case UNIFORM_RESOURCE_IDENTIFIER: {
                    if (generalNameValue instanceof ASN1String) {
                        return ((ASN1String)generalNameValue).getString();
                    }
                    LOG.warn("String value is expected for a General Name of type '{}'. Hex-encoded value is returned.", (Object)generalNameType);
                    return CertificateExtensionsUtils.toHexEncoded(generalNameValue);
                }
                case DIRECTORY_NAME: {
                    X500Principal x500Principal = new X500Principal(DSSASN1Utils.getDEREncoded(generalNameValue));
                    return new X500PrincipalHelper(x500Principal).getRFC2253();
                }
                case IP_ADDRESS: {
                    byte[] octets = ASN1OctetString.getInstance((Object)generalNameValue).getOctets();
                    return CertificateExtensionsUtils.toHexEncoded(octets);
                }
                case REGISTERED_ID: {
                    return ASN1ObjectIdentifier.getInstance((Object)generalNameValue).getId();
                }
            }
            LOG.warn("Unsupported General Name of type '{}'. Hex-encoded value is returned.", (Object)generalNameType);
            return CertificateExtensionsUtils.toHexEncoded(generalNameValue);
        }
        catch (Exception e) {
            LOG.warn("An error occurred on extraction of General Name of Type '{}' : {}. Hex-encoded value is returned.", (Object)generalNameType, (Object)e.getMessage());
            return CertificateExtensionsUtils.toHexEncoded(generalNameValue);
        }
    }

    private static String toHexEncoded(ASN1Encodable asn1Encodable) {
        return CertificateExtensionsUtils.toHexEncoded(DSSASN1Utils.getDEREncoded(asn1Encodable));
    }

    private static String toHexEncoded(byte[] binaries) {
        return "#" + Utils.toHex((byte[])binaries);
    }

    public static PolicyConstraints getPolicyConstraints(CertificateToken certificateToken) {
        byte[] policyConstraintsBinaries = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.POLICY_CONSTRAINTS.getOid());
        if (Utils.isArrayNotEmpty((byte[])policyConstraintsBinaries)) {
            PolicyConstraints policyConstraints = new PolicyConstraints();
            policyConstraints.setOctets(policyConstraintsBinaries);
            try {
                BigInteger requireExplicitPolicyMapping;
                ASN1Sequence seq = DSSASN1Utils.getAsn1SequenceFromDerOctetString(policyConstraintsBinaries);
                org.bouncycastle.asn1.x509.PolicyConstraints bcPolicyConstraints = org.bouncycastle.asn1.x509.PolicyConstraints.getInstance((Object)seq);
                BigInteger inhibitPolicyMapping = bcPolicyConstraints.getInhibitPolicyMapping();
                if (inhibitPolicyMapping != null) {
                    policyConstraints.setInhibitPolicyMapping(inhibitPolicyMapping.intValue());
                }
                if ((requireExplicitPolicyMapping = bcPolicyConstraints.getRequireExplicitPolicyMapping()) != null) {
                    policyConstraints.setRequireExplicitPolicy(requireExplicitPolicyMapping.intValue());
                }
                policyConstraints.checkCritical(certificateToken);
                return policyConstraints;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse the policyConstraints extension '{}' : {}", new Object[]{Utils.toBase64((byte[])policyConstraintsBinaries), e.getMessage(), e});
            }
        }
        return null;
    }

    public static InhibitAnyPolicy getInhibitAnyPolicy(CertificateToken certificateToken) {
        byte[] inhibitAnyPolicyBinaries = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.INHIBIT_ANY_POLICY.getOid());
        if (Utils.isArrayNotEmpty((byte[])inhibitAnyPolicyBinaries)) {
            InhibitAnyPolicy inhibitAnyPolicy = new InhibitAnyPolicy();
            inhibitAnyPolicy.setOctets(inhibitAnyPolicyBinaries);
            try {
                BigInteger value;
                ASN1Integer asn1Integer = DSSASN1Utils.getAsn1IntegerFromDerOctetString(inhibitAnyPolicyBinaries);
                if (asn1Integer != null && (value = asn1Integer.getValue()) != null) {
                    inhibitAnyPolicy.setValue(value.intValue());
                    inhibitAnyPolicy.checkCritical(certificateToken);
                    return inhibitAnyPolicy;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to parse the inhibitAnyPolicy extension '{}' : {}", new Object[]{Utils.toBase64((byte[])inhibitAnyPolicyBinaries), e.getMessage(), e});
            }
        }
        return null;
    }

    public static KeyUsage getKeyUsage(CertificateToken certificateToken) {
        boolean[] keyUsageArray = certificateToken.getCertificate().getKeyUsage();
        if (keyUsageArray != null) {
            KeyUsage keyUsage = new KeyUsage();
            keyUsage.setOctets(certificateToken.getCertificate().getExtensionValue(keyUsage.getOid()));
            ArrayList<KeyUsageBit> keyUsageBits = new ArrayList<KeyUsageBit>();
            for (KeyUsageBit keyUsageBit : KeyUsageBit.values()) {
                if (!keyUsageArray[keyUsageBit.getIndex()]) continue;
                keyUsageBits.add(keyUsageBit);
            }
            keyUsage.setKeyUsageBits(keyUsageBits);
            keyUsage.checkCritical(certificateToken);
            return keyUsage;
        }
        return null;
    }

    public static ExtendedKeyUsages getExtendedKeyUsage(CertificateToken certificateToken) {
        try {
            ExtendedKeyUsages extendedKeyUsage = new ExtendedKeyUsages();
            extendedKeyUsage.setOctets(certificateToken.getCertificate().getExtensionValue(extendedKeyUsage.getOid()));
            extendedKeyUsage.setOids(certificateToken.getCertificate().getExtendedKeyUsage());
            extendedKeyUsage.checkCritical(certificateToken);
            return extendedKeyUsage;
        }
        catch (CertificateParsingException e) {
            LOG.warn("Unable to retrieve ExtendedKeyUsage : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static CertificatePolicies getCertificatePolicies(CertificateToken certificateToken) {
        byte[] certificatePoliciesBinaries = certificateToken.getCertificate().getExtensionValue(CertificateExtensionEnum.CERTIFICATE_POLICIES.getOid());
        if (Utils.isArrayNotEmpty((byte[])certificatePoliciesBinaries)) {
            CertificatePolicies certificatePolicies = new CertificatePolicies();
            certificatePolicies.setOctets(certificatePoliciesBinaries);
            ArrayList<CertificatePolicy> policiesList = new ArrayList<CertificatePolicy>();
            try {
                ASN1Sequence seq = DSSASN1Utils.getAsn1SequenceFromDerOctetString(certificatePoliciesBinaries);
                for (int ii = 0; ii < seq.size(); ++ii) {
                    policiesList.add(CertificateExtensionsUtils.getCertificatePolicy(seq.getObjectAt(ii)));
                }
                certificatePolicies.setPolicyList(policiesList);
                certificatePolicies.checkCritical(certificateToken);
                return certificatePolicies;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse the certificatePolicies extension '{}' : {}", new Object[]{Utils.toBase64((byte[])certificatePoliciesBinaries), e.getMessage(), e});
            }
        }
        return null;
    }

    private static CertificatePolicy getCertificatePolicy(ASN1Encodable policyObject) {
        CertificatePolicy cp = new CertificatePolicy();
        PolicyInformation policyInfo = PolicyInformation.getInstance((Object)policyObject);
        cp.setOid(policyInfo.getPolicyIdentifier().getId());
        ASN1Sequence policyQualifiersSeq = policyInfo.getPolicyQualifiers();
        if (policyQualifiersSeq != null) {
            for (int jj = 0; jj < policyQualifiersSeq.size(); ++jj) {
                PolicyQualifierInfo pqi = PolicyQualifierInfo.getInstance((Object)policyQualifiersSeq.getObjectAt(jj));
                if (!PolicyQualifierId.id_qt_cps.equals((ASN1Primitive)pqi.getPolicyQualifierId())) continue;
                cp.setCpsUrl(DSSASN1Utils.getString(pqi.getQualifier()));
            }
        }
        return cp;
    }

    public static OCSPNoCheck getOcspNoCheck(CertificateToken certificateToken) {
        byte[] extensionValue = certificateToken.getCertificate().getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId());
        if (extensionValue != null) {
            OCSPNoCheck ocspNoCheck = new OCSPNoCheck();
            ocspNoCheck.setOctets(extensionValue);
            ocspNoCheck.setOcspNoCheck(CertificateExtensionsUtils.isNullIdentifiedValuePresent(extensionValue));
            ocspNoCheck.checkCritical(certificateToken);
            return ocspNoCheck;
        }
        return null;
    }

    public static boolean hasOcspNoCheckExtension(CertificateToken certificateToken) {
        OCSPNoCheck ocspNoCheck = CertificateExtensionsUtils.getOcspNoCheck(certificateToken);
        return ocspNoCheck != null && ocspNoCheck.isOcspNoCheck();
    }

    public static ValidityAssuredShortTerm getValAssuredSTCerts(CertificateToken certificateToken) {
        byte[] extensionValue = certificateToken.getCertificate().getExtensionValue(OID.id_etsi_ext_valassured_ST_certs.getId());
        if (extensionValue != null) {
            ValidityAssuredShortTerm validityAssuredShortTerm = new ValidityAssuredShortTerm();
            validityAssuredShortTerm.setOctets(extensionValue);
            validityAssuredShortTerm.setValAssuredSTCerts(CertificateExtensionsUtils.isNullIdentifiedValuePresent(extensionValue));
            validityAssuredShortTerm.checkCritical(certificateToken);
            return validityAssuredShortTerm;
        }
        return null;
    }

    private static boolean isNullIdentifiedValuePresent(byte[] extensionValue) {
        try {
            Object derObject = DSSASN1Utils.toASN1Primitive(extensionValue);
            if (derObject instanceof DEROctetString) {
                return DSSASN1Utils.isDEROctetStringNull((DEROctetString)derObject);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception when processing 'id_pkix_ocsp_no_check'", (Throwable)e);
        }
        return false;
    }

    public static boolean hasValAssuredShortTermCertsExtension(CertificateToken certificateToken) {
        ValidityAssuredShortTerm valAssuredSTCerts = CertificateExtensionsUtils.getValAssuredSTCerts(certificateToken);
        return valAssuredSTCerts != null && valAssuredSTCerts.isValAssuredSTCerts();
    }

    public static QcStatements getQcStatements(CertificateToken certificateToken) {
        QcStatements qcStatements = QcStatementUtils.getQcStatements(certificateToken);
        if (qcStatements != null) {
            qcStatements.checkCritical(certificateToken);
        }
        return qcStatements;
    }

    private static CertificateExtension getOtherCertificateExtension(CertificateToken certificateToken, String oid) {
        CertificateExtensionEnum value = CertificateExtensionEnum.forOid((String)oid);
        CertificateExtension certificateExtension = value != null ? new CertificateExtension(value) : new CertificateExtension(oid);
        certificateExtension.setOctets(certificateToken.getCertificate().getExtensionValue(oid));
        certificateExtension.checkCritical(certificateToken);
        if (value == null) {
            if (certificateExtension.isCritical()) {
                LOG.warn("Unknown critical CertificateExtension with OID : '{}'", (Object)oid);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Unknown non-critical CertificateExtension with OID : '{}'", (Object)oid);
            }
        }
        return certificateExtension;
    }
}

