/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.signature.identifier;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.identifier.SignatureIdentifier;
import eu.europa.esig.dss.spi.signature.identifier.SignatureIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public abstract class AbstractSignatureIdentifierBuilder
implements SignatureIdentifierBuilder {
    private static final long serialVersionUID = 5839378965317021595L;
    protected final AdvancedSignature signature;

    protected AbstractSignatureIdentifierBuilder(AdvancedSignature signature) {
        this.signature = signature;
    }

    @Override
    public SignatureIdentifier build() {
        return new SignatureIdentifier(this.buildBinaries());
    }

    protected byte[] buildBinaries() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeSignedProperties(baos);
            this.writeSignaturePosition(baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building an Identifier : %s", e.getMessage()), (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    protected void writeSignedProperties(ByteArrayOutputStream baos) throws IOException {
        this.writeSigningTime(baos, this.signature.getSigningTime());
        this.writeSigningCertificateRefs(baos, this.signature.getCertificateSource().getSigningCertificateRefs());
        this.writeSignatureValue(baos, this.signature.getSignatureValue());
    }

    private void writeSigningTime(ByteArrayOutputStream baos, Date signingTime) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(baos);){
            if (signingTime != null) {
                dos.writeLong(signingTime.getTime());
            }
            dos.flush();
        }
    }

    private void writeSigningCertificateRefs(ByteArrayOutputStream baos, List<CertificateRef> signingCertificateRefs) throws IOException {
        if (Utils.isCollectionNotEmpty(signingCertificateRefs)) {
            for (CertificateRef certificateRef : signingCertificateRefs) {
                this.writeString(baos, certificateRef.getDSSIdAsString());
            }
        }
    }

    private void writeSignatureValue(ByteArrayOutputStream baos, byte[] signatureValue) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(baos);){
            if (Utils.isArrayNotEmpty((byte[])signatureValue)) {
                dos.write(signatureValue);
            }
            dos.flush();
        }
    }

    protected void writeString(ByteArrayOutputStream baos, String str) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(baos);){
            if (str != null) {
                dos.writeChars(str);
            }
            dos.flush();
        }
    }

    protected void writeSignaturePosition(ByteArrayOutputStream baos) throws IOException {
        this.writeString(baos, this.getPositionId());
    }

    protected String getPositionId() {
        StringBuilder stringBuilder = new StringBuilder();
        AdvancedSignature masterSignature = this.signature.getMasterSignature();
        if (masterSignature != null) {
            stringBuilder.append(masterSignature.getId());
            stringBuilder.append(this.getCounterSignaturePosition(masterSignature));
        } else {
            stringBuilder.append(this.getSignaturePosition());
            stringBuilder.append(this.getSignatureFilePosition());
        }
        return stringBuilder.toString();
    }

    protected abstract Object getCounterSignaturePosition(AdvancedSignature var1);

    protected abstract Object getSignaturePosition();

    protected Object getSignatureFilePosition() {
        return "";
    }
}

