/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.alert.SilentOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CommonCertificateVerifier;

public class CertificateVerifierBuilder {
    private final CertificateVerifier certificateVerifier;

    public CertificateVerifierBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public CertificateVerifier buildCompleteCopy() {
        CommonCertificateVerifier copy = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            copy.setDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
            copy.setAIASource(this.certificateVerifier.getAIASource());
            copy.setCrlSource(this.certificateVerifier.getCrlSource());
            copy.setOcspSource(this.certificateVerifier.getOcspSource());
            copy.setRevocationDataLoadingStrategyFactory(this.certificateVerifier.getRevocationDataLoadingStrategyFactory());
            copy.setRevocationFallback(this.certificateVerifier.isRevocationFallback());
            copy.setRevocationDataVerifier(this.certificateVerifier.getRevocationDataVerifier());
            copy.setTimestampTokenVerifier(this.certificateVerifier.getTimestampTokenVerifier());
            copy.setCheckRevocationForUntrustedChains(this.certificateVerifier.isCheckRevocationForUntrustedChains());
            copy.setExtractPOEFromUntrustedChains(this.certificateVerifier.isExtractPOEFromUntrustedChains());
            copy.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            copy.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
            copy.setAlertOnInvalidSignature(this.certificateVerifier.getAlertOnInvalidSignature());
            copy.setAlertOnInvalidTimestamp(this.certificateVerifier.getAlertOnInvalidTimestamp());
            copy.setAlertOnMissingRevocationData(this.certificateVerifier.getAlertOnMissingRevocationData());
            copy.setAlertOnNoRevocationAfterBestSignatureTime(this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime());
            copy.setAlertOnRevokedCertificate(this.certificateVerifier.getAlertOnRevokedCertificate());
            copy.setAlertOnUncoveredPOE(this.certificateVerifier.getAlertOnUncoveredPOE());
            copy.setAlertOnExpiredSignature(this.certificateVerifier.getAlertOnExpiredSignature());
            copy.setAlertOnExpiredCertificate(this.certificateVerifier.getAlertOnExpiredCertificate());
            copy.setAlertOnNotYetValidCertificate(this.certificateVerifier.getAlertOnNotYetValidCertificate());
            copy.setAugmentationAlertOnSignatureWithoutCertificates(this.certificateVerifier.getAugmentationAlertOnSignatureWithoutCertificates());
            copy.setAugmentationAlertOnHigherSignatureLevel(this.certificateVerifier.getAugmentationAlertOnHigherSignatureLevel());
            copy.setAugmentationAlertOnSelfSignedCertificateChains(this.certificateVerifier.getAugmentationAlertOnSelfSignedCertificateChains());
        }
        return copy;
    }

    public CertificateVerifier buildOfflineAndSilentCopy() {
        CommonCertificateVerifier offlineCertificateVerifier = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            offlineCertificateVerifier.setDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
            offlineCertificateVerifier.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            offlineCertificateVerifier.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
            offlineCertificateVerifier.setRevocationDataVerifier(this.certificateVerifier.getRevocationDataVerifier());
            offlineCertificateVerifier.setTimestampTokenVerifier(this.certificateVerifier.getTimestampTokenVerifier());
            offlineCertificateVerifier.setExtractPOEFromUntrustedChains(this.certificateVerifier.isExtractPOEFromUntrustedChains());
        }
        offlineCertificateVerifier.setAlertOnInvalidSignature((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnInvalidTimestamp((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnMissingRevocationData((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnNoRevocationAfterBestSignatureTime((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnRevokedCertificate((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnUncoveredPOE((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnExpiredSignature((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnExpiredCertificate((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnNotYetValidCertificate((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAugmentationAlertOnSignatureWithoutCertificates((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAugmentationAlertOnHigherSignatureLevel((StatusAlert)new SilentOnStatusAlert());
        offlineCertificateVerifier.setAugmentationAlertOnSelfSignedCertificateChains((StatusAlert)new SilentOnStatusAlert());
        return offlineCertificateVerifier;
    }

    public CertificateVerifier buildCompleteCopyForValidation() {
        CertificateVerifier copy = this.buildCompleteCopy();
        copy.setRevocationFallback(true);
        return copy;
    }
}

