/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.RevocationDataLoadingStrategy;
import eu.europa.esig.dss.spi.validation.RevocationDataLoadingStrategyFactory;
import eu.europa.esig.dss.spi.validation.RevocationDataVerifier;
import eu.europa.esig.dss.spi.validation.TimestampTokenVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.status.RevocationFreshnessStatus;
import eu.europa.esig.dss.spi.validation.status.SignatureStatus;
import eu.europa.esig.dss.spi.validation.status.TokenStatus;
import eu.europa.esig.dss.spi.x509.AlternateUrlsSourceAdapter;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateReorderer;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.TokenIssuerSelector;
import eu.europa.esig.dss.spi.x509.TrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.aia.AIACertificateSource;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<AdvancedSignature> processedSignatures = new LinkedHashSet<AdvancedSignature>();
    private final Set<CertificateToken> processedCertificates = new LinkedHashSet<CertificateToken>();
    private final Set<RevocationToken<?>> processedRevocations = new LinkedHashSet();
    private final Set<TimestampToken> processedTimestamps = new LinkedHashSet<TimestampToken>();
    private final Set<EvidenceRecord> processedEvidenceRecords = new LinkedHashSet<EvidenceRecord>();
    private CertificateVerifier certificateVerifier;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private final Map<CertificateToken, Date> bestSignatureTimeCertChainDates = new HashMap<CertificateToken, Date>();
    private final Map<CertificateToken, Date> lastTimestampCertChainDates = new HashMap<CertificateToken, Date>();
    private final Map<String, List<POE>> poeTimes = new HashMap<String, List<POE>>();
    private final Map<Token, CertificateToken> tokenIssuerMap = new HashMap<Token, CertificateToken>();
    private final Map<Token, Set<CertificateToken>> certificateChildrenMap = new HashMap<Token, Set<CertificateToken>>();
    private final ListCertificateSource documentCertificateSource = new ListCertificateSource();
    private final ListRevocationSource<CRL> documentCRLSource = new ListRevocationSource();
    private final ListRevocationSource<OCSP> documentOCSPSource = new ListRevocationSource();
    private final ListCertificateSource aiaCertificateSources = new ListCertificateSource();
    private final ListCertificateSource revocationCertificateSources = new ListCertificateSource();
    private AIASource aiaSource;
    private RevocationSource<OCSP> remoteOCSPSource;
    private RevocationSource<CRL> remoteCRLSource;
    private RevocationDataLoadingStrategyFactory revocationDataLoadingStrategyFactory;
    private RevocationDataVerifier revocationDataVerifier;
    private boolean revocationFallback;
    private TimestampTokenVerifier timestampTokenVerifier;
    private ListCertificateSource trustedCertSources;
    private ListCertificateSource adjunctCertSources;
    private boolean checkRevocationForUntrustedChains;
    @Deprecated
    private boolean extractPOEFromUntrustedChains;
    protected Date currentTime;

    public SignatureValidationContext() {
        this(new Date());
    }

    public SignatureValidationContext(Date validationTime) {
        this.currentTime = validationTime;
    }

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null!");
        this.certificateVerifier = certificateVerifier;
        this.remoteCRLSource = certificateVerifier.getCrlSource();
        this.remoteOCSPSource = certificateVerifier.getOcspSource();
        this.aiaSource = certificateVerifier.getAIASource();
        this.adjunctCertSources = certificateVerifier.getAdjunctCertSources();
        this.trustedCertSources = certificateVerifier.getTrustedCertSources();
        this.checkRevocationForUntrustedChains = certificateVerifier.isCheckRevocationForUntrustedChains();
        this.extractPOEFromUntrustedChains = certificateVerifier.isExtractPOEFromUntrustedChains();
        this.revocationDataLoadingStrategyFactory = certificateVerifier.getRevocationDataLoadingStrategyFactory();
        this.revocationDataVerifier = certificateVerifier.getRevocationDataVerifier();
        this.revocationFallback = certificateVerifier.isRevocationFallback();
        this.timestampTokenVerifier = certificateVerifier.getTimestampTokenVerifier();
    }

    private RevocationDataVerifier getRevocationDataVerifier() {
        if (this.revocationDataVerifier == null) {
            this.revocationDataVerifier = RevocationDataVerifier.createDefaultRevocationDataVerifier();
        }
        if (this.revocationDataVerifier.getTrustedCertificateSource() == null) {
            this.revocationDataVerifier.setTrustedCertificateSource(this.trustedCertSources);
        }
        return this.revocationDataVerifier;
    }

    private TimestampTokenVerifier getTimestampTokenVerifier() {
        if (this.timestampTokenVerifier == null) {
            this.timestampTokenVerifier = TimestampTokenVerifier.createDefaultTimestampTokenVerifier();
            this.timestampTokenVerifier.setAcceptUntrustedCertificateChains(this.extractPOEFromUntrustedChains);
        }
        if (this.timestampTokenVerifier.getTrustedCertificateSource() == null) {
            this.timestampTokenVerifier.setTrustedCertificateSource(this.trustedCertSources);
        }
        return this.timestampTokenVerifier;
    }

    @Override
    public void addSignatureForVerification(AdvancedSignature signature) {
        if (signature == null) {
            return;
        }
        this.addDocumentCertificateSource(signature.getCertificateSource());
        this.addDocumentCRLSource(signature.getCRLSource());
        this.addDocumentOCSPSource(signature.getOCSPSource());
        this.registerPOE(signature.getId(), this.currentTime);
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            this.addCertificateTokenForVerification(signingCertificate);
        } else {
            List<CertificateValidity> certificateValidities = signature.getCandidatesForSigningCertificate().getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    this.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
        }
        List<TimestampToken> timestamps = signature.getAllTimestamps();
        this.prepareTimestamps(timestamps);
        List<EvidenceRecord> allEvidenceRecords = signature.getAllEvidenceRecords();
        for (EvidenceRecord evidenceRecord : allEvidenceRecords) {
            this.addEvidenceRecordForVerification(evidenceRecord);
        }
        this.registerBestSignatureTime(signature);
        boolean bl = this.processedSignatures.add(signature);
        if (LOG.isTraceEnabled()) {
            if (bl) {
                LOG.trace("AdvancedSignature added to processedSignatures: {} ", this.processedSignatures);
            } else {
                LOG.trace("AdvancedSignature already present processedSignatures: {} ", this.processedSignatures);
            }
        }
        List<AdvancedSignature> counterSignatures = signature.getCounterSignatures();
        this.prepareCounterSignatures(counterSignatures);
    }

    @Override
    public void addDocumentCertificateSource(CertificateSource certificateSource) {
        this.addCertificateSource(this.documentCertificateSource, certificateSource);
    }

    @Override
    public void addDocumentCertificateSource(ListCertificateSource listCertificateSource) {
        for (CertificateSource certificateSource : listCertificateSource.getSources()) {
            this.addDocumentCertificateSource(certificateSource);
        }
    }

    private void addCertificateSource(ListCertificateSource listCertificateSource, CertificateSource certificateSourceToAdd) {
        listCertificateSource.add(certificateSourceToAdd);
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        for (CertificateToken certificateToken : certificateSourceToAdd.getCertificates()) {
            Set<CertificateToken> equivalentCertificates = allCertificateSources.getByPublicKey(certificateToken.getPublicKey());
            for (CertificateToken equivalentCertificate : equivalentCertificates) {
                if (certificateToken.getDSSIdAsString().equals(equivalentCertificate.getDSSIdAsString())) continue;
                this.addCertificateTokenForVerification(certificateToken);
            }
        }
    }

    @Override
    public void addDocumentCRLSource(OfflineRevocationSource<CRL> crlSource) {
        this.documentCRLSource.add(crlSource);
    }

    @Override
    public void addDocumentCRLSource(ListRevocationSource<CRL> crlSource) {
        this.documentCRLSource.addAll(crlSource);
    }

    @Override
    public void addDocumentOCSPSource(OfflineRevocationSource<OCSP> ocspSource) {
        this.documentOCSPSource.add(ocspSource);
    }

    @Override
    public void addDocumentOCSPSource(ListRevocationSource<OCSP> ocspSource) {
        this.documentOCSPSource.addAll(ocspSource);
    }

    private void prepareTimestamps(List<TimestampToken> timestampTokens) {
        for (TimestampToken timestampToken : timestampTokens) {
            this.addTimestampTokenForVerification(timestampToken);
        }
    }

    private void registerBestSignatureTime(AdvancedSignature signature) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            Date bestSignatureTime = this.getBestSignatureTime(signature);
            if (bestSignatureTime == null) {
                bestSignatureTime = this.currentTime;
            }
            List<CertificateToken> certificateChain = this.toCertificateTokenChain(this.getCertChain((Token)signingCertificate));
            for (CertificateToken cert : certificateChain) {
                Date certBestSignatureTime = this.bestSignatureTimeCertChainDates.get(cert);
                if (certBestSignatureTime != null && !bestSignatureTime.after(certBestSignatureTime)) continue;
                this.bestSignatureTimeCertChainDates.put(cert, bestSignatureTime);
            }
        }
    }

    private Date getBestSignatureTime(AdvancedSignature signature) {
        Date bestSignatureTime = null;
        for (POE poe : this.poeTimes.get(signature.getId())) {
            if (bestSignatureTime != null && !bestSignatureTime.after(poe.getTime())) continue;
            bestSignatureTime = poe.getTime();
        }
        return bestSignatureTime;
    }

    private void prepareCounterSignatures(List<AdvancedSignature> counterSignatures) {
        for (AdvancedSignature counterSignature : counterSignatures) {
            this.addSignatureForVerification(counterSignature);
        }
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    @Deprecated
    public void setCurrentTime(Date currentTime) {
        Objects.requireNonNull(currentTime);
        this.currentTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimestampToken getNotYetVerifiedTimestamp() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null || !(entry.getKey() instanceof TimestampToken)) continue;
                entry.setValue(true);
                return (TimestampToken)entry.getKey();
            }
            return null;
        }
    }

    private Map<CertificateToken, List<CertificateToken>> getOrderedCertificateChains() {
        CertificateReorderer order = new CertificateReorderer(this.processedCertificates);
        return order.getOrderedCertificateChains();
    }

    private List<Token> getCertChain(Token token) {
        LinkedList<Token> chain = new LinkedList<Token>();
        Token issuerCertificateToken = token;
        do {
            chain.add(issuerCertificateToken);
        } while ((issuerCertificateToken = this.getIssuer(issuerCertificateToken)) != null && !chain.contains(issuerCertificateToken));
        return chain;
    }

    private List<CertificateToken> getCertificateTokenChain(Token token) {
        LinkedList<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
        for (Token chainItem : this.getCertChain(token)) {
            if (!(chainItem instanceof CertificateToken)) continue;
            certificateChain.add((CertificateToken)chainItem);
        }
        return certificateChain;
    }

    private CertificateToken getIssuer(Token token) {
        CertificateToken issuerCertificateToken = this.getIssuerFromProcessedCertificates(token);
        if (issuerCertificateToken != null) {
            return issuerCertificateToken;
        }
        Set<CertificateToken> candidates = Collections.emptySet();
        if (!this.tokenIssuerMap.containsKey(token)) {
            if (token instanceof OCSPToken) {
                candidates = this.getIssuersFromSource(token, ((OCSPToken)token).getCertificateSource());
            }
            if (token instanceof TimestampToken) {
                candidates = this.getIssuersFromSource(token, ((TimestampToken)token).getCertificateSource());
            }
            if (Utils.isCollectionEmpty(candidates)) {
                candidates = this.getIssuersFromSources(token, this.documentCertificateSource);
            }
        }
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = this.getIssuersFromSources(token, allCertificateSources);
        }
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = this.processedCertificates;
        }
        if ((issuerCertificateToken = new TokenIssuerSelector(token, candidates).getIssuer()) == null && this.aiaSource != null && token instanceof CertificateToken && !this.tokenIssuerMap.containsKey(token)) {
            AIACertificateSource aiaCertificateSource = new AIACertificateSource((CertificateToken)token, this.aiaSource);
            issuerCertificateToken = aiaCertificateSource.getIssuerFromAIA();
            this.addCertificateSource(this.aiaCertificateSources, aiaCertificateSource);
        }
        if (issuerCertificateToken == null && token instanceof OCSPToken) {
            issuerCertificateToken = this.getOCSPIssuer((OCSPToken)token, allCertificateSources);
        }
        if (issuerCertificateToken == null && token instanceof TimestampToken) {
            issuerCertificateToken = this.getTSACertificate((TimestampToken)token, allCertificateSources);
        }
        if (issuerCertificateToken != null) {
            this.addCertificateTokenForVerification(issuerCertificateToken);
        }
        this.addToCacheMap(token, issuerCertificateToken);
        return issuerCertificateToken;
    }

    private void addToCacheMap(Token token, CertificateToken issuerCertificateToken) {
        this.tokenIssuerMap.put(token, issuerCertificateToken);
        if (token instanceof CertificateToken) {
            Set<CertificateToken> childrenCertificates = this.certificateChildrenMap.get(issuerCertificateToken);
            if (Utils.isCollectionEmpty(childrenCertificates)) {
                childrenCertificates = new HashSet<CertificateToken>();
                this.certificateChildrenMap.put((Token)issuerCertificateToken, childrenCertificates);
            }
            childrenCertificates.add((CertificateToken)token);
        }
    }

    private CertificateToken getIssuerFromProcessedCertificates(Token token) {
        CertificateToken issuerCertificateToken = this.tokenIssuerMap.get(token);
        if (issuerCertificateToken != null && (token.getPublicKeyOfTheSigner() != null || token.isSignedBy(issuerCertificateToken))) {
            return issuerCertificateToken;
        }
        return null;
    }

    @Override
    public ListCertificateSource getAllCertificateSources() {
        ListCertificateSource allCertificateSources = new ListCertificateSource();
        allCertificateSources.addAll(this.documentCertificateSource);
        allCertificateSources.addAll(this.revocationCertificateSources);
        allCertificateSources.addAll(this.aiaCertificateSources);
        allCertificateSources.addAll(this.adjunctCertSources);
        allCertificateSources.addAll(this.trustedCertSources);
        return allCertificateSources;
    }

    @Override
    public ListCertificateSource getDocumentCertificateSource() {
        return this.documentCertificateSource;
    }

    @Override
    public ListRevocationSource<CRL> getDocumentCRLSource() {
        return this.documentCRLSource;
    }

    @Override
    public ListRevocationSource<OCSP> getDocumentOCSPSource() {
        return this.documentOCSPSource;
    }

    private Set<CertificateToken> getIssuersFromSources(Token token, ListCertificateSource allCertificateSources) {
        if (token.getPublicKeyOfTheSigner() != null) {
            return allCertificateSources.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return allCertificateSources.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private Set<CertificateToken> getIssuersFromSource(Token token, CertificateSource certificateSource) {
        if (token.getPublicKeyOfTheSigner() != null) {
            return certificateSource.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return certificateSource.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private CertificateToken getOCSPIssuer(OCSPToken token, ListCertificateSource allCertificateSources) {
        CertificateRef signingCertificateRef;
        ResponderId responderId;
        Set<CertificateRef> signingCertificateRefs = token.getCertificateSource().getAllCertificateRefs();
        if (Utils.collectionSize(signingCertificateRefs) == 1 && (responderId = (signingCertificateRef = signingCertificateRefs.iterator().next()).getResponderId()) != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            if (responderId.getSki() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySki(responderId.getSki()));
            }
            if (responderId.getX500Principal() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySubject(new X500PrincipalHelper(responderId.getX500Principal())));
            }
            return new TokenIssuerSelector(token, issuerCandidates).getIssuer();
        }
        LOG.warn("Signing certificate is not found for an OCSPToken with id '{}'.", (Object)token.getDSSIdAsString());
        return null;
    }

    private CertificateToken getTSACertificate(TimestampToken timestamp, ListCertificateSource allCertificateSources) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = timestamp.getCandidatesForSigningCertificate();
        CertificateValidity theBestCandidate = candidatesForSigningCertificate.getTheBestCandidate();
        if (theBestCandidate != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            CertificateToken timestampSigner = theBestCandidate.getCertificateToken();
            if (timestampSigner == null) {
                issuerCandidates.addAll(allCertificateSources.getBySignerIdentifier(theBestCandidate.getSignerInfo()));
            } else {
                issuerCandidates.add(timestampSigner);
            }
            return new TokenIssuerSelector(timestamp, issuerCandidates).getIssuer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                this.registerPOE(token.getDSSIdAsString(), this.currentTime);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokenForVerification(RevocationToken<?> revocationToken) {
        if (this.addTokenForVerification(revocationToken)) {
            CertificateToken issuerCertificateToken;
            RevocationCertificateSource revocationCertificateSource = revocationToken.getCertificateSource();
            if (revocationCertificateSource != null) {
                this.addCertificateSource(this.revocationCertificateSources, revocationCertificateSource);
            }
            if ((issuerCertificateToken = revocationToken.getIssuerCertificateToken()) != null) {
                this.addCertificateTokenForVerification(issuerCertificateToken);
            }
            boolean added = this.processedRevocations.add(revocationToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("RevocationToken added to processedRevocations: {} ", revocationToken);
                } else {
                    LOG.trace("RevocationToken already present processedRevocations: {} ", revocationToken);
                }
            }
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification((Token)certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedCertificates: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedCertificates: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            this.addDocumentCertificateSource(timestampToken.getCertificateSource());
            this.addDocumentCRLSource(timestampToken.getCRLSource());
            this.addDocumentOCSPSource(timestampToken.getOCSPSource());
            List<CertificateValidity> certificateValidities = timestampToken.getCandidatesForSigningCertificate().getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    this.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
            this.registerTimestampUsageDate(timestampToken);
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedTimestamps: {} ", this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedTimestamps: {} ", this.processedTimestamps);
                }
            }
        }
    }

    private void registerTimestampUsageDate(TimestampToken timestampToken) {
        CertificateToken tsaCertificate = this.getTSACertificate(timestampToken, this.getAllCertificateSources());
        if (tsaCertificate == null) {
            LOG.warn("No Timestamp Certificate found. Chain is skipped.");
            return;
        }
        List<CertificateToken> tsaCertificateChain = this.toCertificateTokenChain(this.getCertChain((Token)tsaCertificate));
        Date usageDate = timestampToken.getCreationDate();
        for (CertificateToken cert : tsaCertificateChain) {
            Date lastUsage = this.lastTimestampCertChainDates.get(cert);
            if (lastUsage != null && !lastUsage.before(usageDate)) continue;
            this.lastTimestampCertChainDates.put(cert, usageDate);
        }
        if (this.isTimestampValid(timestampToken)) {
            LOG.debug("Extracting POE from timestamp : {}", (Object)timestampToken.getDSSIdAsString());
            for (TimestampedReference timestampedReference : timestampToken.getTimestampedReferences()) {
                this.registerPOE(timestampedReference.getObjectId(), timestampToken);
            }
        }
    }

    protected boolean isTimestampValid(TimestampToken timestampToken) {
        return this.getTimestampTokenVerifier().isAcceptable(timestampToken, this.getCertificateTokenChain(timestampToken));
    }

    private void registerPOE(String tokenId, TimestampToken timestampToken) {
        List<POE> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<POE>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(new POE(timestampToken));
    }

    private void registerPOE(String tokenId, Date poeTime) {
        List<POE> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<POE>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(new POE(poeTime));
    }

    private List<CertificateToken> toCertificateTokenChain(List<Token> tokens) {
        LinkedList<CertificateToken> chain = new LinkedList<CertificateToken>();
        for (Token token : tokens) {
            if (!(token instanceof CertificateToken)) continue;
            chain.add((CertificateToken)token);
        }
        return chain;
    }

    @Override
    public void addEvidenceRecordForVerification(EvidenceRecord evidenceRecord) {
        this.addDocumentCertificateSource(evidenceRecord.getCertificateSource());
        this.addDocumentCRLSource(evidenceRecord.getCRLSource());
        this.addDocumentOCSPSource(evidenceRecord.getOCSPSource());
        this.prepareTimestamps(evidenceRecord.getTimestamps());
        boolean added = this.processedEvidenceRecords.add(evidenceRecord);
        if (LOG.isTraceEnabled()) {
            if (added) {
                LOG.trace("EvidenceRecord added to processedEvidenceRecords: {} ", this.processedSignatures);
            } else {
                LOG.trace("EvidenceRecord already present processedEvidenceRecords: {} ", this.processedSignatures);
            }
        }
    }

    @Override
    public void validate() {
        TimestampToken timestampToken = this.getNotYetVerifiedTimestamp();
        while (timestampToken != null) {
            this.getCertChain(timestampToken);
            timestampToken = this.getNotYetVerifiedTimestamp();
        }
        Token token = this.getNotYetVerifiedToken();
        while (token != null) {
            List<Token> certChain = this.getCertChain(token);
            if (token instanceof CertificateToken) {
                this.getRevocationData((CertificateToken)token, certChain);
            }
            token = this.getNotYetVerifiedToken();
        }
    }

    private Set<RevocationToken<?>> getRevocationData(CertificateToken certToken, List<Token> certChain) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for : {}", (Object)certToken.getDSSIdAsString());
        }
        if (this.isRevocationDataNotRequired(certToken)) {
            LOG.debug("Revocation data is not required for certificate : {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptySet();
        }
        CertificateToken issuerToken = this.getIssuer((Token)certToken);
        if (issuerToken == null) {
            LOG.warn("Issuer not found for certificate {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptySet();
        }
        HashSet revocations = new HashSet();
        List<RevocationToken<CRL>> crlTokens = this.documentCRLSource.getRevocationTokens(certToken, issuerToken);
        for (RevocationToken<CRL> revocationToken : crlTokens) {
            revocations.add(revocationToken);
            this.addRevocationTokenForVerification(revocationToken);
        }
        List<RevocationToken<OCSP>> ocspTokens = this.documentOCSPSource.getRevocationTokens(certToken, issuerToken);
        for (RevocationToken<OCSP> revocationToken : ocspTokens) {
            revocations.add(revocationToken);
            this.addRevocationTokenForVerification(revocationToken);
            this.addDocumentCertificateSource(revocationToken.getCertificateSource());
        }
        revocations.addAll(this.getRelatedRevocationTokens(certToken));
        if ((this.remoteOCSPSource != null || this.remoteCRLSource != null) && (Utils.isCollectionEmpty(revocations) || this.isRevocationDataRefreshNeeded(certToken, revocations))) {
            LOG.debug("The signature does not contain relative revocation data.");
            if (this.checkRevocationForUntrustedChains || this.containsTrustAnchor(certChain)) {
                LOG.trace("Revocation update is in progress for certificate : {}", (Object)certToken.getDSSIdAsString());
                CertificateToken certificateToken = (CertificateToken)this.getFirstTrustAnchor(certChain);
                RevocationToken<?> revocationToken = this.getRevocationToken(certToken, issuerToken, certificateToken);
                if (revocationToken != null && !revocations.contains(revocationToken)) {
                    LOG.debug("Obtained a new revocation data : {}, for certificate : {}", (Object)revocationToken.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
                    revocations.add(revocationToken);
                    this.addRevocationTokenForVerification(revocationToken);
                    this.linkRevocationToOtherCertificates(revocationToken, certToken, issuerToken);
                }
            } else {
                LOG.warn("External revocation check is skipped for untrusted certificate : {}", (Object)certToken.getDSSIdAsString());
            }
        }
        if (revocations.isEmpty()) {
            LOG.warn("No revocation found for the certificate {}", (Object)certToken.getDSSIdAsString());
        }
        return revocations;
    }

    private <T extends Token> boolean containsTrustAnchor(List<T> certChain) {
        return this.getFirstTrustAnchor(certChain) != null;
    }

    private <T extends Token> Token getFirstTrustAnchor(List<T> certChain) {
        if (Utils.isCollectionNotEmpty(certChain)) {
            for (Token token : certChain) {
                if (!this.isTrusted(token)) continue;
                return token;
            }
        }
        return null;
    }

    private void linkRevocationToOtherCertificates(RevocationToken<?> revocationToken, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        if (revocationToken instanceof CRLToken) {
            CRLToken crlToken = (CRLToken)revocationToken;
            Set<CertificateToken> certificateTokens = this.certificateChildrenMap.get(issuerCertificateToken);
            for (CertificateToken childCertificate : certificateTokens) {
                if (certificateToken == childCertificate) continue;
                CRLToken newCRLToken = new CRLToken(childCertificate, crlToken.getCrlValidity());
                newCRLToken.setExternalOrigin(crlToken.getExternalOrigin());
                newCRLToken.setSourceURL(crlToken.getSourceURL());
                this.addRevocationTokenForVerification(newCRLToken);
            }
        }
    }

    private RevocationToken<?> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificate, CertificateToken trustAnchor) {
        RevocationSource<CRL> currentCRLSource;
        RevocationSource<OCSP> currentOCSPSource;
        if (!this.trustedCertSources.isEmpty() && trustAnchor != null) {
            LOG.trace("Initializing a revocation verifier for a trusted chain...");
            currentOCSPSource = this.instantiateOCSPWithTrustServices(trustAnchor);
            currentCRLSource = this.instantiateCRLWithTrustServices(trustAnchor);
        } else {
            LOG.trace("Initializing a revocation verifier for not trusted chain...");
            currentOCSPSource = this.remoteOCSPSource;
            currentCRLSource = this.remoteCRLSource;
        }
        RevocationDataLoadingStrategy revocationDataLoadingStrategy = this.revocationDataLoadingStrategyFactory.create();
        revocationDataLoadingStrategy.setCrlSource(currentCRLSource);
        revocationDataLoadingStrategy.setOcspSource(currentOCSPSource);
        revocationDataLoadingStrategy.setRevocationDataVerifier(this.getRevocationDataVerifier());
        revocationDataLoadingStrategy.setFallbackEnabled(this.revocationFallback);
        return revocationDataLoadingStrategy.getRevocationToken(certificateToken, issuerCertificate);
    }

    private RevocationSource<OCSP> instantiateOCSPWithTrustServices(CertificateToken trustAnchor) {
        List<String> alternativeOCSPUrls = this.getAlternativeOCSPUrls(trustAnchor);
        if (Utils.isCollectionNotEmpty(alternativeOCSPUrls) && this.remoteOCSPSource instanceof RevocationSourceAlternateUrlsSupport) {
            return new AlternateUrlsSourceAdapter<OCSP>((RevocationSourceAlternateUrlsSupport)this.remoteOCSPSource, alternativeOCSPUrls);
        }
        return this.remoteOCSPSource;
    }

    private RevocationSource<CRL> instantiateCRLWithTrustServices(CertificateToken trustAnchor) {
        List<String> alternativeCRLUrls = this.getAlternativeCRLUrls(trustAnchor);
        if (Utils.isCollectionNotEmpty(alternativeCRLUrls) && this.remoteCRLSource instanceof RevocationSourceAlternateUrlsSupport) {
            return new AlternateUrlsSourceAdapter<CRL>((RevocationSourceAlternateUrlsSupport)this.remoteCRLSource, alternativeCRLUrls);
        }
        return this.remoteCRLSource;
    }

    private List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeOCSPUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof TrustedCertificateSource)) continue;
            TrustedCertificateSource trustedCertSource = (TrustedCertificateSource)certificateSource;
            alternativeOCSPUrls.addAll(trustedCertSource.getAlternativeOCSPUrls(trustAnchor));
        }
        return alternativeOCSPUrls;
    }

    private List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeCRLUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof TrustedCertificateSource)) continue;
            TrustedCertificateSource trustedCertSource = (TrustedCertificateSource)certificateSource;
            alternativeCRLUrls.addAll(trustedCertSource.getAlternativeCRLUrls(trustAnchor));
        }
        return alternativeCRLUrls;
    }

    @Override
    public boolean checkAllRequiredRevocationDataPresent() {
        TokenStatus status = new TokenStatus();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (List<CertificateToken> orderedCertChain : orderedCertificateChains.values()) {
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(orderedCertChain, null, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revocation data is missing for one or more certificate(s).");
            this.certificateVerifier.getAlertOnMissingRevocationData().alert((Object)status);
        }
        return success;
    }

    private void checkRevocationForCertificateChainAgainstBestSignatureTime(List<CertificateToken> certificates, Date bestSignatureTime, TokenStatus status) {
        for (CertificateToken certificateToken : certificates) {
            Date lowestPOETime;
            if (this.isSelfSignedOrTrusted(certificateToken)) break;
            if (this.isRevocationDataNotRequired(certificateToken)) continue;
            boolean found = false;
            Date earliestNextUpdate = null;
            List<RevocationToken<?>> relatedRevocationTokens = this.getRelatedRevocationTokens(certificateToken);
            for (RevocationToken<?> revocationToken : relatedRevocationTokens) {
                if (bestSignatureTime == null || bestSignatureTime.before(revocationToken.getThisUpdate())) {
                    found = true;
                    break;
                }
                if (revocationToken.getNextUpdate() == null || earliestNextUpdate != null && !earliestNextUpdate.after(revocationToken.getNextUpdate())) continue;
                earliestNextUpdate = revocationToken.getNextUpdate();
            }
            if (found) continue;
            if (!this.certificateVerifier.isCheckRevocationForUntrustedChains() && !this.containsTrustAnchor(certificates)) {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, "Revocation data is skipped for untrusted certificate chain!");
            } else if (Utils.isCollectionEmpty(relatedRevocationTokens) || bestSignatureTime == null) {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, "No revocation data found for certificate!");
            } else if (earliestNextUpdate != null) {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, String.format("No revocation data found after the best signature time [%s]! The nextUpdate available after : [%s]", DSSUtils.formatDateToRFC(bestSignatureTime), DSSUtils.formatDateToRFC(earliestNextUpdate)));
            } else {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, String.format("No revocation data found after the best signature time [%s]!", DSSUtils.formatDateToRFC(bestSignatureTime)));
            }
            if (!(status instanceof RevocationFreshnessStatus)) continue;
            if (Utils.isCollectionNotEmpty(relatedRevocationTokens) && earliestNextUpdate == null && (lowestPOETime = this.getLowestPOETime((Token)certificateToken)) != null) {
                earliestNextUpdate = new Date(lowestPOETime.getTime() + 1000L);
            }
            if (earliestNextUpdate == null) continue;
            ((RevocationFreshnessStatus)status).addTokenAndRevocationNextUpdateTime((Token)certificateToken, earliestNextUpdate);
        }
    }

    @Override
    public boolean checkAllPOECoveredByRevocationData() {
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            Date lastCertUsageDate = this.lastTimestampCertChainDates.get(firstChainCertificate);
            if (lastCertUsageDate == null) continue;
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), lastCertUsageDate, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revocation data is missing for one or more POE(s).");
            this.certificateVerifier.getAlertOnUncoveredPOE().alert((Object)status);
        }
        return success;
    }

    @Override
    public boolean checkAllTimestampsValid() {
        TokenStatus status = new TokenStatus();
        for (TimestampToken timestampToken : this.processedTimestamps) {
            if (timestampToken.isSignatureIntact() && timestampToken.isMessageImprintDataFound() && timestampToken.isMessageImprintDataIntact()) continue;
            status.addRelatedTokenAndErrorMessage(timestampToken, "Signature is not intact!");
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Broken timestamp(s) detected.");
            this.certificateVerifier.getAlertOnInvalidTimestamp().alert((Object)status);
        }
        return success;
    }

    @Override
    public boolean checkCertificateNotRevoked(CertificateToken certificateToken) {
        TokenStatus status = new TokenStatus();
        this.checkCertificateIsNotRevokedRecursively(certificateToken, this.poeTimes.get(certificateToken.getDSSIdAsString()), status);
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revoked/Suspended certificate(s) detected.");
            this.certificateVerifier.getAlertOnRevokedCertificate().alert((Object)status);
        }
        return success;
    }

    @Override
    @Deprecated
    public boolean checkCertificatesNotRevoked(AdvancedSignature signature) {
        TokenStatus status = new TokenStatus();
        boolean success = this.checkSignatureCertificatesNotRevoked(signature, status);
        if (!success) {
            status.setMessage("Revoked/Suspended certificate(s) detected.");
            this.certificateVerifier.getAlertOnRevokedCertificate().alert((Object)status);
        }
        return success;
    }

    @Override
    public boolean checkAllSignatureCertificatesNotRevoked() {
        if (Utils.isCollectionEmpty(this.processedSignatures)) {
            return true;
        }
        TokenStatus status = new TokenStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkSignatureCertificatesNotRevoked(signature, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revoked/Suspended certificate(s) detected.");
            this.certificateVerifier.getAlertOnRevokedCertificate().alert((Object)status);
        }
        return success;
    }

    private boolean checkSignatureCertificatesNotRevoked(AdvancedSignature signature, TokenStatus status) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            this.checkCertificateIsNotRevokedRecursively(signingCertificate, this.poeTimes.get(signature.getId()), status);
        }
        return status.isEmpty();
    }

    private boolean checkCertificateIsNotRevokedRecursively(CertificateToken certificateToken, List<POE> poeTimes) {
        return this.checkCertificateIsNotRevokedRecursively(certificateToken, poeTimes, null);
    }

    private boolean checkCertificateIsNotRevokedRecursively(CertificateToken certificateToken, List<POE> poeTimes, TokenStatus status) {
        CertificateToken issuer;
        List<RevocationToken<?>> relatedRevocationTokens;
        if (this.isSelfSignedOrTrusted(certificateToken)) {
            return true;
        }
        if (!this.isRevocationDataNotRequired(certificateToken) && Utils.isCollectionNotEmpty(relatedRevocationTokens = this.getRelatedRevocationTokens(certificateToken))) {
            for (RevocationToken<?> revocationToken : relatedRevocationTokens) {
                if ((!revocationToken.getStatus().isRevoked() || this.hasPOEBeforeRevocationDate(revocationToken.getRevocationDate(), poeTimes)) && revocationToken.getStatus().isKnown()) continue;
                if (status != null) {
                    status.addRelatedTokenAndErrorMessage((Token)certificateToken, "Certificate is revoked/suspended!");
                }
                return false;
            }
        }
        if ((issuer = this.getIssuer((Token)certificateToken)) != null) {
            return this.checkCertificateIsNotRevokedRecursively(issuer, poeTimes, status);
        }
        return true;
    }

    private boolean hasPOEBeforeRevocationDate(Date revocationDate, List<POE> poeTimes) {
        if (Utils.isCollectionNotEmpty(poeTimes)) {
            for (POE poe : poeTimes) {
                if (!this.verifyPOE(poe) || !poe.getTime().before(revocationDate)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRevocationDataNotRequired(CertificateToken certToken) {
        return this.getRevocationDataVerifier().isRevocationDataSkip(certToken);
    }

    private boolean isSelfSignedOrTrusted(CertificateToken certToken) {
        return certToken.isSelfSigned() || this.isTrusted(certToken);
    }

    private List<RevocationToken<?>> getRelatedRevocationTokens(CertificateToken certificateToken) {
        ArrayList result = new ArrayList();
        for (RevocationToken<?> revocationToken : this.processedRevocations) {
            if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateId())) continue;
            result.add(revocationToken);
        }
        return result;
    }

    private boolean isRevocationDataRefreshNeeded(CertificateToken certToken, Collection<RevocationToken<?>> revocations) {
        Date lastTimestampUsageTime;
        Context context = null;
        Date refreshNeededAfterTime = this.bestSignatureTimeCertChainDates.get(certToken);
        if (refreshNeededAfterTime != null) {
            context = Context.SIGNATURE;
        }
        if ((lastTimestampUsageTime = this.lastTimestampCertChainDates.get(certToken)) != null && context == null) {
            context = Context.TIMESTAMP;
        }
        if (refreshNeededAfterTime == null) {
            refreshNeededAfterTime = this.getLowestPOETime((Token)certToken);
            if (context == null) {
                context = Context.REVOCATION;
            }
        }
        boolean freshRevocationDataFound = false;
        for (RevocationToken<?> revocationToken : revocations) {
            List<CertificateToken> certificateTokenChain = this.toCertificateTokenChain(this.getCertChain(revocationToken));
            if (Utils.isCollectionEmpty(certificateTokenChain)) {
                LOG.debug("Certificate chain is not found for a revocation data '{}'!", (Object)revocationToken.getDSSIdAsString());
                continue;
            }
            CertificateToken issuerCertificateToken = certificateTokenChain.iterator().next();
            if (!this.isRevocationFresh(revocationToken, refreshNeededAfterTime, context) || !this.isRevocationIssuedAfterLastTimestampUsage(revocationToken, lastTimestampUsageTime) || RevocationReason.CERTIFICATE_HOLD == revocationToken.getReason() || !this.isRevocationAcceptable(revocationToken, issuerCertificateToken) || !this.hasValidPOE(revocationToken, certToken, issuerCertificateToken)) continue;
            freshRevocationDataFound = true;
            break;
        }
        if (!freshRevocationDataFound) {
            LOG.debug("Revocation data refresh is needed");
            return true;
        }
        return false;
    }

    private Date getLowestPOETime(Token token) {
        Date lowestPOE = null;
        List<POE> poeList = this.poeTimes.get(token.getDSSIdAsString());
        if (Utils.isCollectionEmpty(poeList)) {
            throw new IllegalStateException("POE shall be defined before accessing the 'poeTimes' list!");
        }
        for (POE poe : poeList) {
            Date poeTime = poe.getTime();
            if (lowestPOE != null && !poeTime.before(lowestPOE)) continue;
            lowestPOE = poeTime;
        }
        return lowestPOE;
    }

    private boolean isRevocationFresh(RevocationToken<?> revocationToken, Date refreshNeededAfterTime, Context context) {
        return this.getRevocationDataVerifier().isRevocationDataFresh(revocationToken, refreshNeededAfterTime, context);
    }

    private boolean isRevocationIssuedAfterLastTimestampUsage(RevocationToken<?> revocationToken, Date lastTimestampUsage) {
        return this.getRevocationDataVerifier().isRevocationDataAfterLastCertificateUsage(revocationToken, lastTimestampUsage);
    }

    private boolean isRevocationAcceptable(RevocationToken<?> revocation, CertificateToken issuerCertificateToken) {
        return this.getRevocationDataVerifier().isAcceptable(revocation, issuerCertificateToken);
    }

    private boolean hasValidPOE(RevocationToken<?> revocation, CertificateToken relatedCertToken, CertificateToken issuerCertToken) {
        if (revocation.getNextUpdate() != null && !this.hasPOEAfterProductionAndBeforeNextUpdate(revocation)) {
            LOG.debug("There is no POE for the revocation '{}' after its production time and before the nextUpdate! Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)relatedCertToken.getDSSIdAsString());
            return false;
        }
        if (issuerCertToken != null && !this.isTrusted(issuerCertToken) && !this.hasPOEInTheValidityRange(issuerCertToken)) {
            LOG.debug("There is no POE for the revocation issuer '{}' for revocation '{}' within its validity range! Certificate: {}", new Object[]{issuerCertToken.getDSSIdAsString(), revocation.getDSSIdAsString(), relatedCertToken.getDSSIdAsString()});
            return false;
        }
        LOG.debug("The revocation '{}' has a valid POE. Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)relatedCertToken.getDSSIdAsString());
        return true;
    }

    private boolean hasPOEAfterProductionAndBeforeNextUpdate(RevocationToken<?> revocation) {
        List<POE> poeTimeList = this.poeTimes.get(revocation.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!this.isConsistentAtTime(revocation, poeTime.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPOEInTheValidityRange(CertificateToken certificateToken) {
        List<POE> poeTimeList = this.poeTimes.get(certificateToken.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!certificateToken.isValidOn(poeTime.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isConsistentAtTime(RevocationToken<?> revocationToken, Date date) {
        Date productionDate = revocationToken.getProductionDate();
        Date nextUpdate = revocationToken.getNextUpdate();
        return date.compareTo(productionDate) >= 0 && date.compareTo(nextUpdate) <= 0;
    }

    @Override
    @Deprecated
    public boolean checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(AdvancedSignature signature) {
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        boolean success = this.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signature, status);
        if (!success) {
            status.setMessage("Fresh revocation data is missing for one or more certificate(s).");
            this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime().alert((Object)status);
        }
        return success;
    }

    @Override
    public boolean checkAllSignatureCertificateHaveFreshRevocationData() {
        if (Utils.isCollectionEmpty(this.processedSignatures)) {
            return true;
        }
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signature, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Fresh revocation data is missing for one or more certificate(s).");
            this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime().alert((Object)status);
        }
        return success;
    }

    private boolean checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(AdvancedSignature signature, RevocationFreshnessStatus status) {
        CertificateToken signingCertificateToken = signature.getSigningCertificateToken();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            if (!firstChainCertificate.equals((Object)signingCertificateToken)) continue;
            Date bestSignatureTime = this.getEarliestTimestampTime();
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), bestSignatureTime, status);
        }
        return status.isEmpty();
    }

    private Date getEarliestTimestampTime() {
        Date earliestDate = null;
        for (TimestampToken timestamp : this.getProcessedTimestamps()) {
            if (!timestamp.getTimeStampType().coversSignature()) continue;
            Date timestampTime = timestamp.getCreationDate();
            if (earliestDate != null && !timestampTime.before(earliestDate)) continue;
            earliestDate = timestampTime;
        }
        return earliestDate;
    }

    @Override
    @Deprecated
    public boolean checkSignatureNotExpired(AdvancedSignature signature) {
        SignatureStatus status = new SignatureStatus();
        boolean success = this.checkSignatureNotExpired(signature, status);
        if (!success) {
            status.setMessage("Expired signature found.");
            this.certificateVerifier.getAlertOnExpiredCertificate().alert((Object)status);
        }
        return success;
    }

    @Override
    public boolean checkAllSignaturesNotExpired() {
        if (Utils.isCollectionEmpty(this.processedSignatures)) {
            return true;
        }
        SignatureStatus status = new SignatureStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkSignatureNotExpired(signature, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Expired signature found.");
            this.certificateVerifier.getAlertOnExpiredCertificate().alert((Object)status);
        }
        return success;
    }

    private boolean checkSignatureNotExpired(AdvancedSignature signature, SignatureStatus status) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            boolean signatureNotExpired = this.verifyCertificateTokenHasPOERecursively(signingCertificate, this.poeTimes.get(signature.getId()));
            if (!signatureNotExpired) {
                status.addRelatedTokenAndErrorMessage(signature, String.format("The signing certificate has expired and there is no POE during its validity range : [%s - %s]!", DSSUtils.formatDateToRFC(signingCertificate.getNotBefore()), DSSUtils.formatDateToRFC(signingCertificate.getNotAfter())));
            }
            return signatureNotExpired;
        }
        return true;
    }

    private boolean verifyCertificateTokenHasPOERecursively(CertificateToken certificateToken, List<POE> poeTimeList) {
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!certificateToken.isValidOn(poeTime.getTime()) || !this.verifyPOE(poeTime)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean verifyPOE(POE poe) {
        TimestampToken timestampToken = poe.getTimestampToken();
        if (timestampToken != null) {
            CertificateToken issuerCertificateToken = this.getIssuer(timestampToken);
            List<POE> timestampPOEs = this.poeTimes.get(timestampToken.getDSSIdAsString());
            return issuerCertificateToken != null && timestampToken.isValid() && this.verifyCertificateTokenHasPOERecursively(issuerCertificateToken, timestampPOEs) && this.checkCertificateIsNotRevokedRecursively(issuerCertificateToken, timestampPOEs);
        }
        return true;
    }

    @Override
    public Set<AdvancedSignature> getProcessedSignatures() {
        return Collections.unmodifiableSet(this.processedSignatures);
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Set<RevocationToken<?>> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    @Override
    public Set<EvidenceRecord> getProcessedEvidenceRecords() {
        return Collections.unmodifiableSet(this.processedEvidenceRecords);
    }

    private <T extends Token> boolean isTrusted(T token) {
        return token instanceof CertificateToken && this.trustedCertSources.isTrusted((CertificateToken)token);
    }

    @Override
    public ValidationData getValidationData(AdvancedSignature signature) {
        return this.getValidationData(signature.getSigningCertificateToken());
    }

    @Override
    public ValidationData getValidationData(TimestampToken timestampToken) {
        return this.getValidationData(this.getIssuer(timestampToken));
    }

    private ValidationData getValidationData(CertificateToken certificateToken) {
        ValidationData validationData = new ValidationData();
        if (certificateToken != null) {
            this.populateValidationDataRecursively((Token)certificateToken, validationData);
        }
        return validationData;
    }

    private void populateValidationDataRecursively(Token token, ValidationData validationData) {
        boolean added = validationData.addToken(token);
        if (added) {
            CertificateToken issuerToken;
            if (token instanceof CertificateToken) {
                List<RevocationToken<?>> revocationTokens = this.getRelatedRevocationTokens((CertificateToken)token);
                for (RevocationToken<?> revocationToken : revocationTokens) {
                    this.populateValidationDataRecursively(revocationToken, validationData);
                }
            }
            if ((issuerToken = this.getIssuer(token)) != null) {
                this.populateValidationDataRecursively((Token)issuerToken, validationData);
            }
        }
    }

    private static class POE {
        private final Date time;
        private TimestampToken timestampToken;

        public POE(Date time) {
            this.time = time;
        }

        public POE(TimestampToken timestampToken) {
            this.timestampToken = timestampToken;
            this.time = timestampToken.getCreationDate();
        }

        public Date getTime() {
            return this.time;
        }

        public TimestampToken getTimestampToken() {
            return this.timestampToken;
        }
    }
}

