/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.timestamp;

import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import java.util.ArrayList;
import java.util.List;

public class DetachedTimestampSource
extends AbstractTimestampSource {
    private final ListCertificateSource certificateSource = new ListCertificateSource();
    private final ListRevocationSource<CRL> crlSource = new ListRevocationSource();
    private final ListRevocationSource<OCSP> ocspSource = new ListRevocationSource();
    private final List<TimestampToken> detachedTimestamps = new ArrayList<TimestampToken>();
    private final List<EvidenceRecord> detachedEvidenceRecords = new ArrayList<EvidenceRecord>();

    public DetachedTimestampSource() {
    }

    public DetachedTimestampSource(TimestampToken timestampToken) {
        this.detachedTimestamps.add(timestampToken);
    }

    public List<TimestampToken> getDetachedTimestamps() {
        return this.detachedTimestamps;
    }

    public void addExternalTimestamp(TimestampToken timestamp) {
        this.processExternalTimestamp(timestamp);
        this.detachedTimestamps.add(timestamp);
    }

    private void processExternalTimestamp(TimestampToken externalTimestamp) {
        this.populateSources(externalTimestamp);
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getManifestReferences(externalTimestamp));
    }

    private List<TimestampedReference> getManifestReferences(TimestampToken externalTimestamp) {
        ArrayList<TimestampedReference> result = new ArrayList<TimestampedReference>();
        ManifestFile manifestFile = externalTimestamp.getManifestFile();
        if (manifestFile != null) {
            for (TimestampToken timestampToken : this.detachedTimestamps) {
                if (!manifestFile.isDocumentCovered(timestampToken.getFileName())) continue;
                this.addReferences(result, this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource));
            }
        }
        return result;
    }

    public void addExternalEvidenceRecord(EvidenceRecord evidenceRecord) {
        this.processExternalEvidenceRecord(evidenceRecord);
        this.detachedEvidenceRecords.add(evidenceRecord);
    }

    private void processExternalEvidenceRecord(EvidenceRecord evidenceRecord) {
        this.addEncapsulatedReferencesFromTimestamps(evidenceRecord, this.getDetachedTimestamps());
        this.processEvidenceRecordTimestamps(evidenceRecord);
        this.processEmbeddedEvidenceRecords(evidenceRecord);
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            this.populateSources(timestampToken);
        }
    }

    private void populateSources(TimestampToken timestampToken) {
        this.certificateSource.add(timestampToken.getCertificateSource());
        this.crlSource.add(timestampToken.getCRLSource());
        this.ocspSource.add(timestampToken.getOCSPSource());
    }

    private void addEncapsulatedReferencesFromTimestamps(EvidenceRecord evidenceRecord, List<TimestampToken> timestampTokens) {
        for (TimestampToken timestampToken : timestampTokens) {
            if (!this.isCoveredTimestamp(evidenceRecord, timestampToken)) continue;
            this.addReferences(evidenceRecord.getTimestampedReferences(), this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource));
        }
    }

    private boolean isCoveredTimestamp(EvidenceRecord evidenceRecord, TimestampToken timestampToken) {
        ManifestFile manifestFile = evidenceRecord.getManifestFile();
        if (manifestFile != null) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (timestampToken.getFileName() == null || !timestampToken.getFileName().equals(manifestEntry.getUri())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

