/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.TokenIssuerSelector;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.utils.Utils;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIACertificateSource
extends CommonCertificateSource {
    private static final long serialVersionUID = -2604947158902474169L;
    private static final Logger LOG = LoggerFactory.getLogger(AIACertificateSource.class);
    private final CertificateToken certificate;
    private final AIASource aiaSource;

    public AIACertificateSource(CertificateToken certificate, AIASource aiaSource) {
        Objects.requireNonNull(certificate, "The certificate cannot be null");
        Objects.requireNonNull(aiaSource, "The aiaSource cannot be null");
        this.certificate = certificate;
        this.aiaSource = aiaSource;
    }

    public CertificateToken getIssuerFromAIA() {
        LOG.info("Retrieving {} certificate's issuer using AIA.", (Object)this.certificate.getAbbreviation());
        try {
            Set<CertificateToken> candidates = this.aiaSource.getCertificatesByAIA(this.certificate);
            if (Utils.isCollectionNotEmpty(candidates)) {
                CertificateToken bridgedIssuer = this.findBestBridgeCertificate(candidates);
                if (bridgedIssuer != null) {
                    this.addCertificate(bridgedIssuer);
                    return bridgedIssuer;
                }
                for (CertificateToken candidate : candidates) {
                    this.addCertificate(candidate);
                }
                CertificateToken issuer = new TokenIssuerSelector((Token)this.certificate, candidates).getIssuer();
                if (issuer == null) {
                    LOG.warn("The retrieved certificate(s) using AIA do not sign the certificate with Id : {}.", (Object)this.certificate.getDSSIdAsString());
                }
                return issuer;
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred on attempt to retrieve certificate's CA issuers : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private CertificateToken findBestBridgeCertificate(Collection<CertificateToken> candidates) {
        if (Utils.collectionSize(candidates) <= 1) {
            return null;
        }
        PublicKey commonPublicKey = null;
        CertificateToken bestMatch = null;
        for (CertificateToken candidate : candidates) {
            PublicKey candidatePublicKey = candidate.getPublicKey();
            if (commonPublicKey == null) {
                if (!this.certificate.isSignedBy(candidate)) {
                    return null;
                }
                commonPublicKey = candidatePublicKey;
                if (bestMatch == null) {
                    bestMatch = candidate;
                }
            } else if (!candidatePublicKey.equals(commonPublicKey)) {
                return null;
            }
            if (this.certificate.getIssuerX500Principal().equals(candidate.getSubject().getPrincipal())) {
                bestMatch = candidate;
            }
            if (!candidate.isValidOn(this.certificate.getCreationDate())) continue;
            bestMatch = candidate;
            break;
        }
        return bestMatch;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.AIA;
    }
}

