/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSASN1Utils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSASN1Utils.class);

    private DSSASN1Utils() {
    }

    public static <T extends ASN1Primitive> T toASN1Primitive(byte[] bytes) {
        try {
            return (T)ASN1Primitive.fromByteArray((byte[])bytes);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot convert binaries to ASN1Primitive : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static boolean isDEROctetStringNull(DEROctetString derOctetString) {
        byte[] derOctetStringBytes = derOctetString.getOctets();
        Object asn1Null = DSSASN1Utils.toASN1Primitive(derOctetStringBytes);
        return DERNull.INSTANCE.equals(asn1Null);
    }

    public static byte[] getDEREncoded(ASN1Encodable asn1Encodable) {
        return DSSASN1Utils.getEncoded(asn1Encodable, "DER");
    }

    public static byte[] getDLEncoded(ASN1Encodable asn1Encodable) {
        return DSSASN1Utils.getEncoded(asn1Encodable, "DL");
    }

    public static byte[] getBEREncoded(ASN1Encodable asn1Encodable) {
        return DSSASN1Utils.getEncoded(asn1Encodable, "BER");
    }

    private static byte[] getEncoded(ASN1Encodable asn1Encodable, String encoding) {
        try {
            return asn1Encodable.toASN1Primitive().getEncoded(encoding);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to encode to %s. Reason : %s", encoding, e.getMessage()), (Throwable)e);
        }
    }

    public static byte[] getEncoded(BasicOCSPResp basicOCSPResp) {
        try {
            BasicOCSPResponse basicOCSPResponse = BasicOCSPResponse.getInstance((Object)basicOCSPResp.getEncoded());
            return DSSASN1Utils.getDEREncoded((ASN1Encodable)basicOCSPResponse);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot retrieve DER encoded binaries of BasicOCSPResp : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static Date toDate(ASN1GeneralizedTime asn1Date) {
        try {
            return asn1Date.getDate();
        }
        catch (ParseException e) {
            throw new DSSException(String.format("Cannot parse Date : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static String toString(ASN1OctetString value) {
        return new String(value.getOctets());
    }

    public static byte[] getEncoded(TimeStampToken timeStampToken) {
        return DSSASN1Utils.getEncoded(timeStampToken.toCMSSignedData());
    }

    public static byte[] getEncoded(CMSSignedData cmsSignedData) {
        try {
            return cmsSignedData.getEncoded();
        }
        catch (IOException e) {
            throw new DSSException("Unable to encode to DER", (Throwable)e);
        }
    }

    public static byte[] getDEREncoded(TimeStampToken timeStampToken) {
        return DSSASN1Utils.getDEREncoded(timeStampToken.toCMSSignedData());
    }

    public static byte[] getDEREncoded(CMSSignedData data) {
        return DSSASN1Utils.getDEREncoded((ASN1Encodable)data.toASN1Structure());
    }

    public static byte[] getDEREncoded(TimestampBinary timestampBinary) {
        return DSSASN1Utils.getDEREncoded(timestampBinary.getBytes());
    }

    public static byte[] getDEREncoded(byte[] bytes) {
        try {
            return DSSASN1Utils.getDEREncoded((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])bytes));
        }
        catch (IOException e) {
            throw new DSSException("Unable to encode to DER", (Throwable)e);
        }
    }

    public static byte[] getDLEncoded(byte[] bytes) {
        try {
            return DSSASN1Utils.getDLEncoded((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])bytes));
        }
        catch (IOException e) {
            throw new DSSException("Unable to encode to DL", (Throwable)e);
        }
    }

    public static ASN1Sequence getAsn1SequenceFromDerOctetString(byte[] bytes) {
        return DSSASN1Utils.getASN1Sequence(DSSASN1Utils.getDEROctetStringContent(bytes));
    }

    private static ASN1Sequence getASN1Sequence(byte[] bytes) {
        ASN1Sequence aSN1Sequence;
        ASN1InputStream input = new ASN1InputStream(bytes);
        try {
            aSN1Sequence = (ASN1Sequence)input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Unable to retrieve the ASN1Sequence", (Throwable)e);
            }
        }
        input.close();
        return aSN1Sequence;
    }

    public static ASN1Integer getAsn1IntegerFromDerOctetString(byte[] bytes) {
        return DSSASN1Utils.getASN1Integer(DSSASN1Utils.getDEROctetStringContent(bytes));
    }

    private static ASN1Integer getASN1Integer(byte[] bytes) {
        ASN1Integer aSN1Integer;
        ASN1InputStream input = new ASN1InputStream(bytes);
        try {
            aSN1Integer = (ASN1Integer)input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Unable to retrieve the ASN1Integer", (Throwable)e);
            }
        }
        input.close();
        return aSN1Integer;
    }

    private static byte[] getDEROctetStringContent(byte[] bytes) {
        byte[] byArray;
        ASN1InputStream input = new ASN1InputStream(bytes);
        try {
            DEROctetString s = (DEROctetString)input.readObject();
            byArray = s.getOctets();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Unable to retrieve the DEROctetString content", (Throwable)e);
            }
        }
        input.close();
        return byArray;
    }

    public static ASN1Encodable getAsn1Encodable(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.getAttrValues().size() == 1) {
            return attribute.getAttrValues().getObjectAt(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.warn("Only one value is allowed within attribute set! Found {} : {}.", (Object)attribute.getAttrValues().size(), (Object)Utils.toHex((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute)));
        } else {
            LOG.warn("Only one value is allowed within attribute set! Found {}.", (Object)attribute.getAttrValues().size());
        }
        return null;
    }

    public static byte[] getAsn1SignaturePolicyDigest(DigestAlgorithm digestAlgorithm, byte[] policyBytes) {
        ASN1Sequence asn1Seq = (ASN1Sequence)DSSASN1Utils.toASN1Primitive(policyBytes);
        ASN1Sequence signPolicyHashAlgObject = (ASN1Sequence)asn1Seq.getObjectAt(0);
        AlgorithmIdentifier signPolicyHashAlgIdentifier = AlgorithmIdentifier.getInstance((Object)signPolicyHashAlgObject);
        ASN1Sequence signPolicyInfo = (ASN1Sequence)asn1Seq.getObjectAt(1);
        byte[] hashAlgorithmDEREncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)signPolicyHashAlgIdentifier);
        byte[] signPolicyInfoDEREncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)signPolicyInfo);
        return DSSUtils.digest(digestAlgorithm, hashAlgorithmDEREncoded, signPolicyInfoDEREncoded);
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(ASN1Sequence atsHashIndexValue) {
        if (atsHashIndexValue != null && atsHashIndexValue.size() > 3) {
            boolean algorithmIndex = false;
            ASN1Encodable asn1Encodable = atsHashIndexValue.getObjectAt(0);
            if (asn1Encodable instanceof ASN1Sequence) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable;
                return AlgorithmIdentifier.getInstance((Object)asn1Sequence);
            }
            if (asn1Encodable instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier derObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)asn1Encodable);
                return new AlgorithmIdentifier(derObjectIdentifier);
            }
        }
        return null;
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(DigestAlgorithm digestAlgorithm) {
        ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier(digestAlgorithm.getOid());
        return new AlgorithmIdentifier(asn1ObjectIdentifier, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static List<DEROctetString> getDEROctetStrings(ASN1Sequence asn1Sequence) {
        ArrayList<DEROctetString> derOctetStrings = new ArrayList<DEROctetString>();
        if (asn1Sequence != null) {
            derOctetStrings.addAll(Collections.list(asn1Sequence.getObjects()));
        }
        return derOctetStrings;
    }

    public static byte[] computeSkiFromCert(CertificateToken certificateToken) {
        return DSSASN1Utils.computeSkiFromCertPublicKey(certificateToken.getPublicKey());
    }

    public static byte[] computeSkiFromCertPublicKey(PublicKey publicKey) {
        try {
            DLSequence seq = (DLSequence)ASN1Primitive.fromByteArray((byte[])publicKey.getEncoded());
            DERBitString item = (DERBitString)seq.getObjectAt(1);
            return DSSUtils.digest(DigestAlgorithm.SHA1, item.getOctets());
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to compute ski from public key : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static boolean isSkiEqual(byte[] ski, CertificateToken certificateToken) {
        byte[] certSki = DSSASN1Utils.computeSkiFromCert(certificateToken);
        return Arrays.equals(certSki, ski);
    }

    public static X509CertificateHolder getX509CertificateHolder(CertificateToken certToken) {
        try {
            return new X509CertificateHolder(certToken.getEncoded());
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to instantiate a X509CertificateHolder : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static CertificateToken getCertificate(X509CertificateHolder x509CertificateHolder) {
        try {
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(DSSSecurityProvider.getSecurityProviderName());
            X509Certificate x509Certificate = converter.getCertificate(x509CertificateHolder);
            return new CertificateToken(x509Certificate);
        }
        catch (CertificateException e) {
            throw new DSSException(String.format("Unable to get a CertificateToken from X509CertificateHolder : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static SignerIdentifier toSignerIdentifier(SignerId signerId) {
        X500Principal issuerX500Principal = DSSASN1Utils.toX500Principal(signerId.getIssuer());
        return DSSASN1Utils.toSignerIdentifier(issuerX500Principal, signerId.getSerialNumber(), signerId.getSubjectKeyIdentifier());
    }

    public static X500Principal toX500Principal(X500Name x500Name) {
        if (x500Name == null) {
            return null;
        }
        try {
            return new X500Principal(x500Name.getEncoded());
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot extract X500Principal! Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static SignerIdentifier toSignerIdentifier(X500Principal issuerX500Principal, BigInteger serialNumber, byte[] ski) {
        SignerIdentifier signerIdentifier = new SignerIdentifier();
        signerIdentifier.setIssuerName(issuerX500Principal);
        signerIdentifier.setSerialNumber(serialNumber);
        signerIdentifier.setSki(ski);
        return signerIdentifier;
    }

    public static IssuerSerial getIssuerSerial(CertificateToken certToken) {
        X500Name issuerX500Name = DSSASN1Utils.getX509CertificateHolder(certToken).getIssuer();
        GeneralName generalName = new GeneralName(issuerX500Name);
        GeneralNames generalNames = new GeneralNames(generalName);
        BigInteger serialNumber = certToken.getCertificate().getSerialNumber();
        return new IssuerSerial(generalNames, serialNumber);
    }

    public static boolean x500PrincipalAreEquals(X500Principal firstX500Principal, X500Principal secondX500Principal) {
        if (firstX500Principal == null || secondX500Principal == null) {
            return false;
        }
        if (firstX500Principal.equals(secondX500Principal)) {
            return true;
        }
        Map<String, String> firstStringStringHashMap = DSSASN1Utils.get(firstX500Principal);
        Map<String, String> secondStringStringHashMap = DSSASN1Utils.get(secondX500Principal);
        return firstStringStringHashMap.equals(secondStringStringHashMap);
    }

    public static Map<String, String> get(X500Principal x500Principal) {
        ASN1Encodable[] asn1Encodables;
        HashMap<String, String> treeMap = new HashMap<String, String>();
        byte[] encoded = x500Principal.getEncoded();
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)encoded);
        for (ASN1Encodable asn1Encodable : asn1Encodables = asn1Sequence.toArray()) {
            DLSet dlSet = (DLSet)asn1Encodable;
            for (int ii = 0; ii < dlSet.size(); ++ii) {
                DLSequence dlSequence = (DLSequence)dlSet.getObjectAt(ii);
                if (dlSequence.size() != 2) {
                    throw new DSSException("The DLSequence must contains exactly 2 elements.");
                }
                ASN1Encodable asn1EncodableAttributeType = dlSequence.getObjectAt(0);
                String stringAttributeType = DSSASN1Utils.getString(asn1EncodableAttributeType);
                ASN1Encodable asn1EncodableAttributeValue = dlSequence.getObjectAt(1);
                String stringAttributeValue = DSSASN1Utils.getString(asn1EncodableAttributeValue);
                treeMap.put(stringAttributeType, stringAttributeValue);
            }
        }
        return treeMap;
    }

    public static String getString(ASN1Encodable attributeValue) {
        if (attributeValue == null) {
            LOG.warn("Null attribute has been provided!");
            return null;
        }
        try {
            return IETFUtils.valueToString((ASN1Encodable)attributeValue);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to handle attribute of class '{}' : {}", (Object)attributeValue.getClass().getName(), (Object)e.getMessage());
            } else {
                LOG.warn("Unable to handle attribute : {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    public static String extractAttributeFromX500Principal(ASN1ObjectIdentifier identifier, X500PrincipalHelper principal) {
        RDN[] rdns;
        X500Name x500Name = X500Name.getInstance((Object)principal.getEncoded());
        for (RDN rdn : rdns = x500Name.getRDNs(identifier)) {
            if (rdn.isMultiValued()) {
                AttributeTypeAndValue[] typesAndValues;
                for (AttributeTypeAndValue typeAndValue : typesAndValues = rdn.getTypesAndValues()) {
                    if (!identifier.equals((ASN1Primitive)typeAndValue.getType())) continue;
                    return typeAndValue.getValue().toString();
                }
                continue;
            }
            AttributeTypeAndValue typeAndValue = rdn.getFirst();
            if (!identifier.equals((ASN1Primitive)typeAndValue.getType())) continue;
            return typeAndValue.getValue().toString();
        }
        return null;
    }

    public static String getSubjectCommonName(CertificateToken cert) {
        return DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.CN, cert.getSubject());
    }

    public static String getHumanReadableName(CertificateToken cert) {
        return DSSASN1Utils.getHumanReadableName(cert.getSubject());
    }

    public static String getHumanReadableName(X500PrincipalHelper x500PrincipalHelper) {
        return DSSASN1Utils.firstNotNull(x500PrincipalHelper, BCStyle.CN, BCStyle.GIVENNAME, BCStyle.SURNAME, BCStyle.NAME, BCStyle.PSEUDONYM, BCStyle.O, BCStyle.OU);
    }

    private static String firstNotNull(X500PrincipalHelper x500PrincipalHelper, ASN1ObjectIdentifier ... oids) {
        for (ASN1ObjectIdentifier oid : oids) {
            String value = DSSASN1Utils.extractAttributeFromX500Principal(oid, x500PrincipalHelper);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Deprecated
    public static SignerInformation getFirstSignerInformation(CMSSignedData cms) {
        return DSSASN1Utils.getFirstSignerInformation(cms.getSignerInfos());
    }

    public static SignerInformation getFirstSignerInformation(SignerInformationStore signerInformationStore) {
        Collection signers = signerInformationStore.getSigners();
        if (signers.size() > 1) {
            LOG.warn("!!! The framework handles only one signer (SignerInformation) !!!");
        }
        return (SignerInformation)signers.iterator().next();
    }

    public static boolean isASN1SequenceTag(byte tagByte) {
        return 48 == tagByte;
    }

    public static Date getDate(ASN1Encodable encodable) {
        try {
            return Time.getInstance((Object)encodable).getDate();
        }
        catch (Exception e) {
            LOG.warn("Unable to retrieve the date {}", (Object)encodable, (Object)e);
            return null;
        }
    }

    @Deprecated
    public static List<String> getExtendedKeyUsage(CertificateToken certToken) {
        try {
            return certToken.getCertificate().getExtendedKeyUsage();
        }
        catch (CertificateParsingException e) {
            LOG.warn("Unable to retrieve ExtendedKeyUsage : {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public static IssuerSerial getIssuerSerial(byte[] binaries) {
        IssuerSerial issuerSerial;
        ASN1InputStream is = new ASN1InputStream(binaries);
        try {
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            issuerSerial = IssuerSerial.getInstance((Object)seq);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Unable to decode IssuerSerialV2 textContent '{}' : {}", new Object[]{Utils.toBase64((byte[])binaries), e.getMessage(), e});
                return null;
            }
        }
        is.close();
        return issuerSerial;
    }

    public static SignerIdentifier toSignerIdentifier(IssuerSerial issuerAndSerial) {
        if (issuerAndSerial == null) {
            return null;
        }
        try {
            ASN1Integer serialNumber;
            SignerIdentifier signerIdentifier = new SignerIdentifier();
            GeneralNames gnames = issuerAndSerial.getIssuer();
            if (gnames != null) {
                GeneralName[] names = gnames.getNames();
                if (names.length == 1) {
                    signerIdentifier.setIssuerName(new X500Principal(names[0].getName().toASN1Primitive().getEncoded("DER")));
                } else {
                    LOG.warn("More than one GeneralName");
                }
            }
            if ((serialNumber = issuerAndSerial.getSerial()) != null) {
                signerIdentifier.setSerialNumber(serialNumber.getValue());
            }
            return signerIdentifier;
        }
        catch (Exception e) {
            LOG.warn("Unable to read the IssuerSerial object", (Throwable)e);
            return null;
        }
    }

    public static Attribute[] getAsn1Attributes(AttributeTable attributeTable, ASN1ObjectIdentifier oid) {
        ASN1EncodableVector encodableVector = attributeTable.getAll(oid);
        if (encodableVector == null) {
            return new Attribute[0];
        }
        Attributes attributes = new Attributes(encodableVector);
        return attributes.getAttributes();
    }

    public static Date getTimeStampTokenGenerationTime(TimeStampToken timeStampToken) {
        if (timeStampToken != null) {
            return timeStampToken.getTimeStampInfo().getGenTime();
        }
        return null;
    }

    public static RevocationValues getRevocationValues(ASN1Encodable encodable) {
        if (encodable != null) {
            try {
                return RevocationValues.getInstance((Object)encodable);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse RevocationValues", (Throwable)e);
            }
        }
        return null;
    }

    public static CertificateRef getCertificateRef(OtherCertID otherCertId) {
        CertificateRef certRef = new CertificateRef();
        DigestAlgorithm digestAlgo = DigestAlgorithm.forOID((String)otherCertId.getAlgorithmHash().getAlgorithm().getId());
        certRef.setCertDigest(new Digest(digestAlgo, otherCertId.getCertHash()));
        certRef.setCertificateIdentifier(DSSASN1Utils.toSignerIdentifier(otherCertId.getIssuerSerial()));
        return certRef;
    }

    public static boolean isAsn1Encoded(byte[] binaries) {
        boolean bl;
        if (Utils.isArrayEmpty((byte[])binaries)) {
            return false;
        }
        ASN1InputStream is = new ASN1InputStream(binaries);
        try {
            bl = is.readObject() != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    public static boolean isAsn1EncodedSignatureValue(byte[] binaries) {
        boolean bl;
        ASN1InputStream is = new ASN1InputStream(binaries);
        try {
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            bl = seq != null && seq.size() == 2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    public static byte[] ensurePlainSignatureValue(EncryptionAlgorithm algorithm, byte[] signatureValue) {
        if ((EncryptionAlgorithm.ECDSA == algorithm || EncryptionAlgorithm.PLAIN_ECDSA == algorithm || EncryptionAlgorithm.DSA == algorithm) && DSSASN1Utils.isAsn1EncodedSignatureValue(signatureValue)) {
            return DSSASN1Utils.toPlainDSASignatureValue(signatureValue);
        }
        return signatureValue;
    }

    public static byte[] toPlainDSASignatureValue(byte[] asn1SignatureValue) {
        try {
            BigInteger order = DSSASN1Utils.getOrderFromSignatureValue(asn1SignatureValue);
            BigInteger[] values = StandardDSAEncoding.INSTANCE.decode(order, asn1SignatureValue);
            return PlainDSAEncoding.INSTANCE.encode(order, values[0], values[1]);
        }
        catch (Exception e) {
            throw new DSSException("Unable to convert to plain : " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] toStandardDSASignatureValue(byte[] signatureValue) {
        try {
            BigInteger order = DSSASN1Utils.getOrderFromSignatureValue(signatureValue);
            BigInteger[] values = PlainDSAEncoding.INSTANCE.decode(order, signatureValue);
            return StandardDSAEncoding.INSTANCE.encode(order, values[0], values[1]);
        }
        catch (Exception e) {
            throw new DSSException("Unable to convert to standard DSA : " + e.getMessage(), (Throwable)e);
        }
    }

    public static BigInteger getOrderFromSignatureValue(byte[] signatureValue) {
        try {
            BigInteger sValue;
            BigInteger rValue;
            if (DSSASN1Utils.isAsn1EncodedSignatureValue(signatureValue)) {
                ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])signatureValue);
                if (seq.size() != 2) {
                    throw new IllegalArgumentException("ASN1 Sequence size should be 2!");
                }
                rValue = ((ASN1Integer)seq.getObjectAt(0)).getValue();
                sValue = ((ASN1Integer)seq.getObjectAt(1)).getValue();
            } else {
                if (signatureValue.length % 2 != 0) {
                    throw new IllegalArgumentException("signatureValue binaries length shall be dividable by 2!");
                }
                int valueLength = signatureValue.length / 2;
                rValue = BigIntegers.fromUnsignedByteArray((byte[])signatureValue, (int)0, (int)valueLength);
                sValue = BigIntegers.fromUnsignedByteArray((byte[])signatureValue, (int)valueLength, (int)valueLength);
            }
            BigInteger max = rValue.max(sValue);
            return max.add(BigInteger.ONE);
        }
        catch (IOException e) {
            throw new DSSException("Unable to extract order from a signature value : " + e.getMessage(), (Throwable)e);
        }
    }

    public static int getSignatureValueBitLength(byte[] signatureValue) {
        try {
            BigInteger order = DSSASN1Utils.getOrderFromSignatureValue(signatureValue);
            return BigIntegers.getUnsignedByteLength((BigInteger)order) * 8;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to extract a signature value bit length : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static String getDirectoryStringValue(ASN1Encodable directoryStringInstance) {
        String postalAddress = null;
        try {
            DirectoryString directoryString = DirectoryString.getInstance((Object)directoryStringInstance);
            postalAddress = directoryString.getString();
        }
        catch (Exception e) {
            String errorMessage = "Unable to build a DirectoryString instance. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
        return postalAddress;
    }

    public static BasicOCSPResp toBasicOCSPResp(OCSPResponse ocspResponse) throws OCSPException {
        OCSPResp ocspResp = new OCSPResp(ocspResponse);
        return (BasicOCSPResp)ocspResp.getResponseObject();
    }

    public static BasicOCSPResp[] toBasicOCSPResps(OCSPResponse[] ocspResponses) {
        ArrayList<BasicOCSPResp> basicOCSPResps = new ArrayList<BasicOCSPResp>();
        for (OCSPResponse ocspRespons : ocspResponses) {
            try {
                basicOCSPResps.add(DSSASN1Utils.toBasicOCSPResp(ocspRespons));
            }
            catch (OCSPException e) {
                LOG.warn("Error while converting OCSPResponse to BasicOCSPResp : {}", (Object)e.getMessage());
                return null;
            }
        }
        return basicOCSPResps.toArray(new BasicOCSPResp[0]);
    }

    public static BasicOCSPResp[] toBasicOCSPResps(BasicOCSPResponse[] basicOCSPResponses) {
        ArrayList<BasicOCSPResp> basicOCSPResps = new ArrayList<BasicOCSPResp>();
        for (BasicOCSPResponse basicOCSPRespons : basicOCSPResponses) {
            basicOCSPResps.add(new BasicOCSPResp(basicOCSPRespons));
        }
        return basicOCSPResps.toArray(new BasicOCSPResp[0]);
    }

    public static ASN1Primitive buildSPDocSpecificationId(String oidOrUri) {
        Object spDocSpecification = DSSUtils.isOidCode(oidOrUri) ? new ASN1ObjectIdentifier(oidOrUri) : new DERIA5String(oidOrUri);
        return spDocSpecification;
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

