/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.extension.CertificateExtension;
import eu.europa.esig.dss.model.x509.extension.CertificateExtensions;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicies;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicy;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSPKUtils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.validation.TrustAnchorVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.x509.CertificateReorderer;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationDataVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationDataVerifier.class);
    private static final Collection<DigestAlgorithm> DEFAULT_DIGEST_ALGORITHMS;
    private static final Map<EncryptionAlgorithm, Integer> DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP;
    private static final Collection<String> DEFAULT_REVOCATION_SKIP_CERTIFICATE_EXTENSIONS;
    private static final Long DEFAULT_MAXIMUM_REVOCATION_FRESHNESS;
    @Deprecated
    private Collection<RevocationToken<?>> processedRevocations;
    private Collection<DigestAlgorithm> acceptableDigestAlgorithms;
    private Map<EncryptionAlgorithm, Integer> acceptableEncryptionAlgorithmKeyLength;
    private Collection<String> revocationSkipCertificateExtensions;
    private Collection<String> revocationSkipCertificatePolicies;
    private Long signatureMaximumRevocationFreshness;
    private Long timestampMaximumRevocationFreshness;
    private Long revocationMaximumRevocationFreshness;
    private boolean checkRevocationFreshnessNextUpdate;
    private boolean acceptTimestampCertificatesWithoutRevocation;
    private boolean acceptRevocationCertificatesWithoutRevocation;
    private TrustAnchorVerifier trustAnchorVerifier;
    private ValidationContext validationContext;

    protected RevocationDataVerifier() {
    }

    public static RevocationDataVerifier createEmptyRevocationDataVerifier() {
        return new RevocationDataVerifier();
    }

    public static RevocationDataVerifier createDefaultRevocationDataVerifier() {
        try {
            RevocationDataVerifier revocationDataVerifier = new RevocationDataVerifier();
            revocationDataVerifier.setAcceptableDigestAlgorithms(DEFAULT_DIGEST_ALGORITHMS);
            revocationDataVerifier.setAcceptableEncryptionAlgorithmKeyLength(DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP);
            revocationDataVerifier.setRevocationSkipCertificateExtensions(DEFAULT_REVOCATION_SKIP_CERTIFICATE_EXTENSIONS);
            revocationDataVerifier.setSignatureMaximumRevocationFreshness(DEFAULT_MAXIMUM_REVOCATION_FRESHNESS);
            revocationDataVerifier.setTimestampMaximumRevocationFreshness(DEFAULT_MAXIMUM_REVOCATION_FRESHNESS);
            revocationDataVerifier.setRevocationMaximumRevocationFreshness(DEFAULT_MAXIMUM_REVOCATION_FRESHNESS);
            return revocationDataVerifier;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to instantiate default RevocationDataVerifier. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    @Deprecated
    protected Collection<RevocationToken<?>> getProcessedRevocations() {
        return this.processedRevocations;
    }

    @Deprecated
    protected void setProcessedRevocations(Collection<RevocationToken<?>> processedRevocations) {
        this.processedRevocations = processedRevocations;
    }

    public void setAcceptableDigestAlgorithms(Collection<DigestAlgorithm> acceptableDigestAlgorithms) {
        Objects.requireNonNull(acceptableDigestAlgorithms, "Collection of DigestAlgorithms for acceptance cannot be null!");
        this.acceptableDigestAlgorithms = acceptableDigestAlgorithms;
    }

    public void setAcceptableEncryptionAlgorithmKeyLength(Map<EncryptionAlgorithm, Integer> acceptableEncryptionAlgorithmKeyLength) {
        Objects.requireNonNull(acceptableEncryptionAlgorithmKeyLength, "Map of Encryption Algorithms for acceptance cannot be null!");
        this.acceptableEncryptionAlgorithmKeyLength = acceptableEncryptionAlgorithmKeyLength;
    }

    public void setRevocationSkipCertificateExtensions(Collection<String> revocationSkipCertificateExtensions) {
        this.revocationSkipCertificateExtensions = revocationSkipCertificateExtensions;
    }

    public void setRevocationSkipCertificatePolicies(Collection<String> revocationSkipCertificatePolicies) {
        this.revocationSkipCertificatePolicies = revocationSkipCertificatePolicies;
    }

    public void setSignatureMaximumRevocationFreshness(Long signatureMaximumRevocationFreshness) {
        this.signatureMaximumRevocationFreshness = signatureMaximumRevocationFreshness;
    }

    public void setTimestampMaximumRevocationFreshness(Long timestampMaximumRevocationFreshness) {
        this.timestampMaximumRevocationFreshness = timestampMaximumRevocationFreshness;
    }

    public void setRevocationMaximumRevocationFreshness(Long revocationMaximumRevocationFreshness) {
        this.revocationMaximumRevocationFreshness = revocationMaximumRevocationFreshness;
    }

    public void setCheckRevocationFreshnessNextUpdate(boolean checkRevocationFreshnessNextUpdate) {
        this.checkRevocationFreshnessNextUpdate = checkRevocationFreshnessNextUpdate;
    }

    public void setAcceptTimestampCertificatesWithoutRevocation(boolean acceptTimestampCertificatesWithoutRevocation) {
        this.acceptTimestampCertificatesWithoutRevocation = acceptTimestampCertificatesWithoutRevocation;
    }

    public void setAcceptRevocationCertificatesWithoutRevocation(boolean acceptRevocationCertificatesWithoutRevocation) {
        this.acceptRevocationCertificatesWithoutRevocation = acceptRevocationCertificatesWithoutRevocation;
    }

    public TrustAnchorVerifier getTrustAnchorVerifier() {
        return this.trustAnchorVerifier;
    }

    public void setTrustAnchorVerifier(TrustAnchorVerifier trustAnchorVerifier) {
        this.trustAnchorVerifier = trustAnchorVerifier;
    }

    protected void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public boolean isAcceptable(RevocationToken<?> revocationToken) {
        return this.isAcceptable(revocationToken, new Date());
    }

    public boolean isAcceptable(RevocationToken<?> revocationToken, Date controlTime) {
        return this.isAcceptable(revocationToken, revocationToken.getIssuerCertificateToken(), controlTime);
    }

    public boolean isAcceptable(RevocationToken<?> revocationToken, CertificateToken issuerCertificateToken) {
        return this.isAcceptable(revocationToken, issuerCertificateToken, new Date());
    }

    public boolean isAcceptable(RevocationToken<?> revocationToken, CertificateToken issuerCertificateToken, Date controlTime) {
        return this.isAcceptable(revocationToken, issuerCertificateToken, Collections.emptyList(), controlTime);
    }

    public boolean isAcceptable(RevocationToken<?> revocationToken, CertificateToken issuerCertificateToken, List<CertificateToken> certificateChain, Date controlTime) {
        return this.isRevocationTokenValid(revocationToken) && this.isRevocationDataComplete(revocationToken) && this.isGoodIssuer(revocationToken, issuerCertificateToken, controlTime) && this.isCertificateChainValid(certificateChain, controlTime, Context.REVOCATION) && this.isConsistent(revocationToken) && this.isAcceptableSignatureAlgorithm(revocationToken, issuerCertificateToken);
    }

    protected boolean isRevocationTokenValid(RevocationToken<?> revocationToken) {
        if (!revocationToken.isValid()) {
            LOG.warn("The revocation token '{}' is not valid : {}!", (Object)revocationToken.getDSSIdAsString(), (Object)revocationToken.getInvalidityReason());
            return false;
        }
        return true;
    }

    protected boolean isRevocationDataComplete(RevocationToken<?> revocationToken) {
        if (revocationToken.getRelatedCertificate() == null) {
            LOG.warn("The revocation '{}' does not have a related certificate!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        if (revocationToken.getStatus() == null) {
            LOG.warn("The obtained revocation token '{}' does not contain the certificate status!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        if (revocationToken.getThisUpdate() == null) {
            LOG.warn("The obtained revocation token '{}' does not contain thisUpdate field!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    protected boolean isGoodIssuer(RevocationToken<?> revocationToken, CertificateToken issuerCertificateToken, Date controlTime) {
        if (issuerCertificateToken == null) {
            LOG.warn("The issuer certificate is not found for the obtained revocation '{}'!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        if (RevocationType.OCSP.equals((Object)revocationToken.getRevocationType()) && !DSSRevocationUtils.checkIssuerValidAtRevocationProductionTime(revocationToken, issuerCertificateToken)) {
            LOG.warn("The revocation token '{}' has been produced outside the issuer certificate's validity range!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        return this.isCertificateValid(issuerCertificateToken, revocationToken.getCertificates(), controlTime);
    }

    protected boolean isConsistent(RevocationToken<?> revocation) {
        CertificateToken certToken = revocation.getRelatedCertificate();
        if (!this.isRevocationIssuedAfterCertificateNotBefore(revocation, certToken)) {
            LOG.warn("The revocation '{}' has been produced before the start of the validity of the certificate '{}'!", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
            return false;
        }
        if (!this.doesRevocationKnowCertificate(revocation, certToken)) {
            LOG.warn("The revocation '{}' was not issued during the validity period of the certificate! Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
            return false;
        }
        LOG.debug("The revocation '{}' is consistent. Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
        return true;
    }

    private boolean isRevocationIssuedAfterCertificateNotBefore(RevocationToken<?> revocationToken, CertificateToken certificateToken) {
        return certificateToken.getNotBefore().compareTo(revocationToken.getThisUpdate()) <= 0;
    }

    private boolean doesRevocationKnowCertificate(RevocationToken<?> revocationToken, CertificateToken certificateToken) {
        return this.revocationInformationAssured(revocationToken, certificateToken) || this.certHashMatch(revocationToken);
    }

    private boolean revocationInformationAssured(RevocationToken<?> revocationToken, CertificateToken certificateToken) {
        Date archiveCutOff;
        Date notAfterRevoc = revocationToken.getThisUpdate();
        Date certNotAfter = certificateToken.getNotAfter();
        Date expiredCertsOnCRL = revocationToken.getExpiredCertsOnCRL();
        if (expiredCertsOnCRL != null) {
            notAfterRevoc = expiredCertsOnCRL;
        }
        if ((archiveCutOff = revocationToken.getArchiveCutOff()) != null) {
            notAfterRevoc = archiveCutOff;
        }
        return certNotAfter.compareTo(notAfterRevoc) >= 0;
    }

    private boolean certHashMatch(RevocationToken<?> revocationToken) {
        return revocationToken.isCertHashPresent() && revocationToken.isCertHashMatch();
    }

    protected boolean isAcceptableSignatureAlgorithm(RevocationToken<?> revocationToken, CertificateToken issuerCertificateToken) {
        int publicKeySize;
        if (Utils.isCollectionEmpty(this.acceptableDigestAlgorithms)) {
            LOG.info("No acceptable digest algorithms defined!");
            return false;
        }
        if (Utils.isMapEmpty(this.acceptableEncryptionAlgorithmKeyLength)) {
            LOG.info("No acceptable encryption algorithms defined!");
            return false;
        }
        SignatureAlgorithm signatureAlgorithm = revocationToken.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            LOG.warn("Signature algorithm was not identified for an obtained revocation token '{}'!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        if (!this.acceptableDigestAlgorithms.contains(signatureAlgorithm.getDigestAlgorithm())) {
            LOG.warn("The used DigestAlgorithm {} is not acceptable for revocation token '{}'!", (Object)signatureAlgorithm.getDigestAlgorithm(), (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        Integer encryptionAlgorithmMinKeySize = this.acceptableEncryptionAlgorithmKeyLength.get(signatureAlgorithm.getEncryptionAlgorithm());
        if (encryptionAlgorithmMinKeySize == null) {
            LOG.warn("The EncryptionAlgorithm {} is not acceptable for revocation token '{}'!", (Object)signatureAlgorithm.getEncryptionAlgorithm(), (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        int n = publicKeySize = issuerCertificateToken != null ? DSSPKUtils.getPublicKeySize(issuerCertificateToken.getPublicKey()) : -1;
        if (publicKeySize <= 0) {
            LOG.warn("Key size used to sign revocation token '{}' cannot be identified!", (Object)revocationToken.getDSSIdAsString());
            return false;
        }
        if (publicKeySize < encryptionAlgorithmMinKeySize) {
            LOG.warn("The key size '{}' used to sign revocation token '{}' is smaller than minimal acceptable value '{}'!", new Object[]{publicKeySize, revocationToken.getDSSIdAsString(), encryptionAlgorithmMinKeySize});
            return false;
        }
        return true;
    }

    public boolean isRevocationDataSkip(CertificateToken certificateToken) {
        return this.isRevocationDataSkip(certificateToken, new Date());
    }

    public boolean isRevocationDataSkip(CertificateToken certificateToken, Date controlTime) {
        if (this.isTrustedAtTime(certificateToken, controlTime)) {
            return true;
        }
        if (certificateToken.isSelfSigned()) {
            return true;
        }
        if (Utils.isCollectionEmpty(this.revocationSkipCertificateExtensions)) {
            return false;
        }
        CertificateExtensions certificateExtensions = CertificateExtensionsUtils.getCertificateExtensions(certificateToken);
        List allCertificateExtensions = certificateExtensions.getAllCertificateExtensions();
        if (Utils.isCollectionNotEmpty((Collection)allCertificateExtensions) && Utils.containsAny((Collection)allCertificateExtensions.stream().map(CertificateExtension::getOid).collect(Collectors.toSet()), this.revocationSkipCertificateExtensions)) {
            return true;
        }
        if (Utils.isCollectionEmpty(this.revocationSkipCertificatePolicies)) {
            return false;
        }
        CertificatePolicies certificatePolicies = certificateExtensions.getCertificatePolicies();
        return certificatePolicies != null && Utils.isCollectionNotEmpty((Collection)certificatePolicies.getPolicyList()) && Utils.containsAny((Collection)certificatePolicies.getPolicyList().stream().map(CertificatePolicy::getOid).collect(Collectors.toSet()), this.revocationSkipCertificatePolicies);
    }

    protected boolean isTrustedAtTime(CertificateToken certificateToken, Date controlTime) {
        TrustAnchorVerifier currentTrustAnchorVerifier = this.getTrustAnchorVerifier();
        if (currentTrustAnchorVerifier == null) {
            LOG.warn("TrustAnchorVerifier is not defined! None of the certificates will be considered as a trust anchor.");
            return false;
        }
        return currentTrustAnchorVerifier.isTrustedAtTime(certificateToken, controlTime, Context.REVOCATION);
    }

    public boolean isRevocationDataFresh(RevocationToken<?> revocationToken, Date validationTime, Context context) {
        Long maximumRevocationFreshness = this.getMaximumRevocationFreshness(context);
        if (maximumRevocationFreshness == null) {
            return this.isRevocationThisUpdateAfterValidationTimeNullConstraint(revocationToken, validationTime);
        }
        return this.isRevocationThisUpdateAfterValidationTime(revocationToken, validationTime, maximumRevocationFreshness);
    }

    protected boolean isRevocationThisUpdateAfterValidationTime(RevocationToken<?> revocationToken, Date validationTime, long maximumRevocationFreshness) {
        long validationDateTime = validationTime.getTime();
        long limit = validationDateTime - maximumRevocationFreshness;
        Date thisUpdate = revocationToken.getThisUpdate();
        return thisUpdate != null && thisUpdate.after(new Date(limit));
    }

    protected boolean isRevocationThisUpdateAfterValidationTimeNullConstraint(RevocationToken<?> revocationToken, Date validationTime) {
        if (!this.checkRevocationFreshnessNextUpdate) {
            return true;
        }
        Date nextUpdate = revocationToken.getNextUpdate();
        if (nextUpdate == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No NextUpdate for revocation data with id '{}'. Revocation Freshness check failed.", (Object)revocationToken.getDSSIdAsString());
            }
            return false;
        }
        long limit = this.getDifference(nextUpdate, revocationToken.getThisUpdate());
        return this.isRevocationThisUpdateAfterValidationTime(revocationToken, validationTime, limit);
    }

    private long getDifference(Date nextUpdate, Date thisUpdate) {
        long nextUpdateTime = nextUpdate == null ? 0L : nextUpdate.getTime();
        long thisUpdateTime = thisUpdate == null ? 0L : thisUpdate.getTime();
        return nextUpdateTime - thisUpdateTime;
    }

    private Long getMaximumRevocationFreshness(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: 
            case CERTIFICATE: {
                return this.signatureMaximumRevocationFreshness;
            }
            case TIMESTAMP: 
            case EVIDENCE_RECORD: {
                return this.timestampMaximumRevocationFreshness;
            }
            case REVOCATION: {
                return this.revocationMaximumRevocationFreshness;
            }
        }
        throw new UnsupportedOperationException(String.format("The provided validation context '%s' is not supported!", context));
    }

    public boolean checkCertificateNotRevoked(RevocationToken<?> revocationToken, Date controlTime) {
        return revocationToken.getStatus().isKnown() && (!revocationToken.getStatus().isRevoked() || controlTime.before(revocationToken.getRevocationDate()));
    }

    public boolean isAfterThisUpdateAndBeforeNextUpdate(RevocationToken<?> revocationToken, Date date) {
        Date thisUpdate = revocationToken.getThisUpdate();
        Date nextUpdate = revocationToken.getNextUpdate();
        return thisUpdate != null && date.compareTo(thisUpdate) >= 0 && (nextUpdate == null || date.compareTo(nextUpdate) <= 0);
    }

    public boolean isCertificateChainValid(List<CertificateToken> certificateTokenChain, Date controlTime, Context context) {
        if (this.isAcceptCertificatesWithoutRevocation(context)) {
            return true;
        }
        for (CertificateToken certificateToken : certificateTokenChain) {
            if (certificateToken.isSelfSigned() || this.isTrustedAtTime(certificateToken, controlTime)) break;
            if (!certificateToken.isValid()) {
                LOG.warn("The certificate '{}' is cryptographically invalid!", (Object)certificateToken.getDSSIdAsString());
                return false;
            }
            if (this.isCertificateValid(certificateToken, certificateTokenChain, controlTime)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptCertificatesWithoutRevocation(Context context) {
        return Context.TIMESTAMP == context && this.acceptTimestampCertificatesWithoutRevocation || Context.REVOCATION == context && this.acceptRevocationCertificatesWithoutRevocation;
    }

    @Deprecated
    protected boolean isCertificateValid(CertificateToken certificateToken, Date controlTime) {
        return this.isCertificateValid(certificateToken, Collections.emptyList(), controlTime);
    }

    protected boolean isCertificateValid(CertificateToken certificateToken, Collection<CertificateToken> certificateChain, Date controlTime) {
        if (!this.isRevocationDataSkip(certificateToken, controlTime)) {
            if (!this.hasRevocationAccessPoints(certificateToken)) {
                LOG.warn("The certificate '{}' requires a revocation data, which is not acceptable due its configuration (no revocation access location points)!", (Object)certificateToken.getDSSIdAsString());
                return false;
            }
            if (!this.isCertificateNotRevoked(certificateToken, certificateChain, controlTime)) {
                LOG.warn("The certificate '{}' does not contain a valid revocation data information!", (Object)certificateToken.getDSSIdAsString());
                return false;
            }
        }
        return true;
    }

    private boolean hasRevocationAccessPoints(CertificateToken certificateToken) {
        return Utils.isCollectionNotEmpty(CertificateExtensionsUtils.getCRLAccessUrls(certificateToken)) || Utils.isCollectionNotEmpty(CertificateExtensionsUtils.getOCSPAccessUrls(certificateToken));
    }

    @Deprecated
    protected boolean isCertificateNotRevoked(CertificateToken certificateToken, Date controlTime) {
        return this.isCertificateNotRevoked(certificateToken, Collections.emptyList(), controlTime);
    }

    protected boolean isCertificateNotRevoked(CertificateToken certificateToken, Collection<CertificateToken> certificateChain, Date controlTime) {
        this.populateValidationContext(certificateChain);
        List<RevocationToken<?>> revocationData = this.getRelatedRevocationTokens(certificateToken);
        if (Utils.isCollectionNotEmpty(revocationData)) {
            for (RevocationToken<?> revocationToken : revocationData) {
                if (this.isSelfIssuedRevocation(certificateToken, revocationToken) || !this.isAcceptable(revocationToken, controlTime) || !this.checkCertificateNotRevoked(revocationToken, controlTime)) continue;
                return true;
            }
        }
        LOG.warn("The certificate '{}' is not known to be not revoked!", (Object)certificateToken.getDSSIdAsString());
        return false;
    }

    protected boolean isSelfIssuedRevocation(CertificateToken certificateToken, RevocationToken<?> revocationData) {
        List<CertificateToken> certificateChain;
        if (certificateToken.equals((Object)revocationData.getIssuerCertificateToken())) {
            LOG.warn("Revocation data '{}' has been issued by the concerned certificate '{}'!", (Object)revocationData.getDSSIdAsString(), (Object)certificateToken.getDSSIdAsString());
            return true;
        }
        if (Utils.isCollectionNotEmpty(revocationData.getCertificates()) && (certificateChain = new CertificateReorderer(revocationData.getIssuerCertificateToken(), revocationData.getCertificates()).getOrderedCertificates()).contains(certificateToken)) {
            LOG.warn("The concerned certificate '{}' found at the revocation '{}' certificate chain!", (Object)certificateToken.getDSSIdAsString(), (Object)revocationData.getDSSIdAsString());
            return true;
        }
        return false;
    }

    private void populateValidationContext(Collection<CertificateToken> certificateChain) {
        if (this.validationContext != null) {
            for (CertificateToken certificateToken : certificateChain) {
                this.validationContext.addCertificateTokenForVerification(certificateToken);
            }
        }
    }

    private List<RevocationToken<?>> getRelatedRevocationTokens(CertificateToken certificateToken) {
        if (this.validationContext == null && Utils.isCollectionEmpty(this.processedRevocations)) {
            LOG.warn("ValidationContext is not defined! Unable to retrieve revocation data for certificate.");
            return Collections.emptyList();
        }
        ArrayList revocationData = new ArrayList();
        if (this.validationContext != null) {
            revocationData.addAll(this.validationContext.getRevocationData(certificateToken));
        }
        if (Utils.isCollectionNotEmpty(this.processedRevocations)) {
            revocationData.addAll(this.processedRevocations);
        }
        if (Utils.isCollectionEmpty(revocationData)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (RevocationToken revocationToken : revocationData) {
            if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateId())) continue;
            result.add(revocationToken);
        }
        return result;
    }

    static {
        DEFAULT_MAXIMUM_REVOCATION_FRESHNESS = 0L;
        DEFAULT_DIGEST_ALGORITHMS = Arrays.asList(DigestAlgorithm.SHA224, DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512, DigestAlgorithm.SHA3_256, DigestAlgorithm.SHA3_384, DigestAlgorithm.SHA3_512);
        DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP = new EnumMap<EncryptionAlgorithm, Integer>(EncryptionAlgorithm.class);
        DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP.put(EncryptionAlgorithm.DSA, 2048);
        DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP.put(EncryptionAlgorithm.RSA, 1900);
        DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP.put(EncryptionAlgorithm.RSASSA_PSS, 1900);
        DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP.put(EncryptionAlgorithm.ECDSA, 256);
        DEFAULT_ENCRYPTION_ALGORITHMS_KEY_LENGTH_MAP.put(EncryptionAlgorithm.PLAIN_ECDSA, 256);
        DEFAULT_REVOCATION_SKIP_CERTIFICATE_EXTENSIONS = Arrays.asList(OID.id_etsi_ext_valassured_ST_certs.getId(), OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId(), Extension.noRevAvail.getId());
    }
}

