/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.RevocationDataLoadingStrategy;
import eu.europa.esig.dss.spi.validation.RevocationDataLoadingStrategyFactory;
import eu.europa.esig.dss.spi.validation.RevocationDataVerifier;
import eu.europa.esig.dss.spi.validation.TimestampTokenVerifier;
import eu.europa.esig.dss.spi.validation.TrustAnchorVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.status.RevocationFreshnessStatus;
import eu.europa.esig.dss.spi.validation.status.SignatureStatus;
import eu.europa.esig.dss.spi.validation.status.TokenStatus;
import eu.europa.esig.dss.spi.x509.AlternateUrlsSourceAdapter;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateReorderer;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.TokenIssuerSelector;
import eu.europa.esig.dss.spi.x509.TrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.aia.AIACertificateSource;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampTokenComparator;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<AdvancedSignature> processedSignatures = new LinkedHashSet<AdvancedSignature>();
    private final Set<CertificateToken> processedCertificates = new LinkedHashSet<CertificateToken>();
    private final Set<RevocationToken<?>> processedRevocations = new LinkedHashSet();
    private final Set<TimestampToken> processedTimestamps = new LinkedHashSet<TimestampToken>();
    private final Set<EvidenceRecord> processedEvidenceRecords = new LinkedHashSet<EvidenceRecord>();
    private CertificateVerifier certificateVerifier;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private final Map<CertificateToken, List<AdvancedSignature>> certificateSignaturesUsage = new HashMap<CertificateToken, List<AdvancedSignature>>();
    private final Map<CertificateToken, List<Date>> timestampCertChainDates = new HashMap<CertificateToken, List<Date>>();
    private final Map<String, List<POE>> poeTimes = new HashMap<String, List<POE>>();
    private final Map<Token, CertificateToken> tokenIssuerMap = new HashMap<Token, CertificateToken>();
    private final Map<Token, Set<CertificateToken>> certificateChildrenMap = new HashMap<Token, Set<CertificateToken>>();
    private final ListCertificateSource documentCertificateSource = new ListCertificateSource();
    private final ListRevocationSource<CRL> documentCRLSource = new ListRevocationSource();
    private final ListRevocationSource<OCSP> documentOCSPSource = new ListRevocationSource();
    private final ListCertificateSource aiaCertificateSources = new ListCertificateSource();
    private final ListCertificateSource revocationCertificateSources = new ListCertificateSource();
    private AIASource aiaSource;
    private RevocationSource<OCSP> remoteOCSPSource;
    private RevocationSource<CRL> remoteCRLSource;
    private RevocationDataLoadingStrategyFactory revocationDataLoadingStrategyFactory;
    private RevocationDataVerifier revocationDataVerifier;
    private boolean revocationFallback;
    private TimestampTokenVerifier timestampTokenVerifier;
    private TrustAnchorVerifier trustAnchorVerifier;
    private ListCertificateSource trustedCertSources;
    private ListCertificateSource adjunctCertSources;
    private boolean checkRevocationForUntrustedChains;
    protected Date currentTime;

    public SignatureValidationContext() {
        this(new Date());
    }

    public SignatureValidationContext(Date validationTime) {
        this.currentTime = validationTime;
    }

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null!");
        this.certificateVerifier = certificateVerifier;
        this.remoteCRLSource = certificateVerifier.getCrlSource();
        this.remoteOCSPSource = certificateVerifier.getOcspSource();
        this.aiaSource = certificateVerifier.getAIASource();
        this.adjunctCertSources = certificateVerifier.getAdjunctCertSources();
        this.trustedCertSources = certificateVerifier.getTrustedCertSources();
        this.checkRevocationForUntrustedChains = certificateVerifier.isCheckRevocationForUntrustedChains();
        this.revocationDataLoadingStrategyFactory = certificateVerifier.getRevocationDataLoadingStrategyFactory();
        this.revocationDataVerifier = certificateVerifier.getRevocationDataVerifier();
        this.revocationFallback = certificateVerifier.isRevocationFallback();
        this.timestampTokenVerifier = certificateVerifier.getTimestampTokenVerifier();
        this.trustAnchorVerifier = certificateVerifier.getTrustAnchorVerifier();
    }

    protected CertificateVerifier getCertificateVerifier() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier shall be initialized! Please use #initialize(CertificateVerifier) method.");
        return this.certificateVerifier;
    }

    private RevocationDataVerifier getRevocationDataVerifier() {
        if (this.revocationDataVerifier == null) {
            this.revocationDataVerifier = RevocationDataVerifier.createDefaultRevocationDataVerifier();
        }
        if (this.revocationDataVerifier.getTrustAnchorVerifier() == null) {
            this.revocationDataVerifier.setTrustAnchorVerifier(this.getTrustAnchorVerifier());
        }
        this.revocationDataVerifier.setValidationContext(this);
        return this.revocationDataVerifier;
    }

    private TimestampTokenVerifier getTimestampTokenVerifier() {
        if (this.timestampTokenVerifier == null) {
            this.timestampTokenVerifier = TimestampTokenVerifier.createDefaultTimestampTokenVerifier();
        }
        if (this.timestampTokenVerifier.getTrustAnchorVerifier() == null) {
            this.timestampTokenVerifier.setTrustAnchorVerifier(this.getTrustAnchorVerifier());
        }
        if (this.timestampTokenVerifier.getRevocationDataVerifier() == null) {
            this.timestampTokenVerifier.setRevocationDataVerifier(this.getRevocationDataVerifier());
        }
        return this.timestampTokenVerifier;
    }

    private TrustAnchorVerifier getTrustAnchorVerifier() {
        if (this.trustAnchorVerifier == null) {
            this.trustAnchorVerifier = TrustAnchorVerifier.createDefaultTrustAnchorVerifier();
        }
        if (this.trustAnchorVerifier.getTrustedCertificateSource() == null) {
            this.trustAnchorVerifier.setTrustedCertificateSource(this.trustedCertSources);
        }
        return this.trustAnchorVerifier;
    }

    @Override
    public void addSignatureForVerification(AdvancedSignature signature) {
        if (signature == null) {
            return;
        }
        this.addDocumentCertificateSource(signature.getCertificateSource());
        this.addDocumentCRLSource(signature.getCRLSource());
        this.addDocumentOCSPSource(signature.getOCSPSource());
        this.registerPOE(signature.getId(), this.currentTime);
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            this.addCertificateTokenForVerification(signingCertificate);
        } else {
            List<CertificateValidity> certificateValidities = signature.getCandidatesForSigningCertificate().getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    this.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
        }
        List<TimestampToken> timestamps = signature.getAllTimestamps();
        this.prepareTimestamps(timestamps);
        List<EvidenceRecord> allEvidenceRecords = signature.getAllEvidenceRecords();
        this.prepareEvidenceRecords(allEvidenceRecords);
        this.registerCertChainUsage(signature);
        boolean added = this.processedSignatures.add(signature);
        if (LOG.isTraceEnabled()) {
            if (added) {
                LOG.trace("AdvancedSignature added to processedSignatures: {} ", this.processedSignatures);
            } else {
                LOG.trace("AdvancedSignature already present processedSignatures: {} ", this.processedSignatures);
            }
        }
        List<AdvancedSignature> counterSignatures = signature.getCounterSignatures();
        this.prepareCounterSignatures(counterSignatures);
    }

    @Override
    public void addDocumentCertificateSource(CertificateSource certificateSource) {
        this.addCertificateSource(this.documentCertificateSource, certificateSource);
    }

    @Override
    public void addDocumentCertificateSource(ListCertificateSource listCertificateSource) {
        for (CertificateSource certificateSource : listCertificateSource.getSources()) {
            this.addDocumentCertificateSource(certificateSource);
        }
    }

    private void addCertificateSource(ListCertificateSource listCertificateSource, CertificateSource certificateSourceToAdd) {
        if (listCertificateSource.add(certificateSourceToAdd)) {
            ListCertificateSource allCertificateSources = this.getAllCertificateSources();
            for (CertificateToken certificateToken : certificateSourceToAdd.getCertificates()) {
                this.addEquivalentCertificates(certificateToken, allCertificateSources);
            }
        }
    }

    private void addEquivalentCertificates(CertificateToken certificateToken, CertificateSource certificateSource) {
        Set<CertificateToken> equivalentCertificates = certificateSource.getByEntityKey(certificateToken.getEntityKey());
        for (CertificateToken equivalentCertificate : equivalentCertificates) {
            if (certificateToken.getDSSIdAsString().equals(equivalentCertificate.getDSSIdAsString())) continue;
            this.addCertificateTokenForVerification(equivalentCertificate);
        }
    }

    @Override
    public void addDocumentCRLSource(OfflineRevocationSource<CRL> crlSource) {
        this.documentCRLSource.add(crlSource);
    }

    @Override
    public void addDocumentCRLSource(ListRevocationSource<CRL> crlSource) {
        this.documentCRLSource.addAll(crlSource);
    }

    @Override
    public void addDocumentOCSPSource(OfflineRevocationSource<OCSP> ocspSource) {
        this.documentOCSPSource.add(ocspSource);
    }

    @Override
    public void addDocumentOCSPSource(ListRevocationSource<OCSP> ocspSource) {
        this.documentOCSPSource.addAll(ocspSource);
    }

    private void prepareTimestamps(List<TimestampToken> timestampTokens) {
        if (Utils.isCollectionNotEmpty(timestampTokens)) {
            for (TimestampToken timestampToken : timestampTokens) {
                this.addTimestampTokenForVerification(timestampToken);
            }
        }
    }

    private void prepareEvidenceRecords(List<EvidenceRecord> evidenceRecords) {
        if (Utils.isCollectionNotEmpty(evidenceRecords)) {
            for (EvidenceRecord evidenceRecord : evidenceRecords) {
                this.addEvidenceRecordForVerification(evidenceRecord);
            }
        }
    }

    private void registerCertChainUsage(AdvancedSignature signature) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            List<CertificateToken> certificateChain = this.toCertificateTokenChain(this.getCertChain((Token)signingCertificate));
            for (CertificateToken cert : certificateChain) {
                List certUsageSignatures = this.certificateSignaturesUsage.computeIfAbsent(cert, k -> new ArrayList());
                if (certUsageSignatures.contains(signature)) continue;
                certUsageSignatures.add(signature);
            }
        }
    }

    private void prepareCounterSignatures(List<AdvancedSignature> counterSignatures) {
        if (Utils.isCollectionNotEmpty(counterSignatures)) {
            for (AdvancedSignature counterSignature : counterSignatures) {
                this.addSignatureForVerification(counterSignature);
            }
        }
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            RevocationToken<?> revocationToken = this.getNotYetVerifiedRevocationToken();
            if (revocationToken != null) {
                return revocationToken;
            }
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    private RevocationToken<?> getNotYetVerifiedRevocationToken() {
        if (Utils.isCollectionEmpty(this.processedRevocations)) {
            return null;
        }
        ArrayList revocationTokens = new ArrayList(this.processedRevocations);
        for (RevocationToken revocationToken : revocationTokens) {
            if (this.isYetVerified(revocationToken)) continue;
            return revocationToken;
        }
        return null;
    }

    private TimestampToken getNotYetVerifiedTimestamp() {
        if (Utils.isCollectionEmpty(this.processedTimestamps)) {
            return null;
        }
        ArrayList<TimestampToken> sortedTimestampTokens = new ArrayList<TimestampToken>(this.processedTimestamps);
        sortedTimestampTokens.sort(new TimestampTokenComparator());
        Collections.reverse(sortedTimestampTokens);
        for (TimestampToken timestampToken : sortedTimestampTokens) {
            if (this.isYetVerified(timestampToken)) continue;
            return timestampToken;
        }
        return null;
    }

    private Token getNotYetVerifiedTokenFromChain(List<Token> certChain) {
        for (Token token : certChain) {
            if (this.isYetVerified(token)) continue;
            return token;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isYetVerified(Token token) {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            Boolean processed = this.tokensToProcess.get(token);
            if (!Boolean.TRUE.equals(processed)) {
                this.tokensToProcess.put(token, true);
                return false;
            }
            return true;
        }
    }

    private Map<CertificateToken, List<CertificateToken>> getOrderedCertificateChains() {
        CertificateReorderer order = new CertificateReorderer(this.processedCertificates);
        return order.getOrderedCertificateChains();
    }

    private List<Token> getCertChain(Token token) {
        LinkedList<Token> chain = new LinkedList<Token>();
        Token issuerCertificateToken = token;
        do {
            chain.add(issuerCertificateToken);
        } while ((issuerCertificateToken = this.getIssuer(issuerCertificateToken, this.getTokenCertificateSource(token))) != null && !chain.contains(issuerCertificateToken));
        return chain;
    }

    private CertificateSource getTokenCertificateSource(Token token) {
        if (token instanceof OCSPToken) {
            return ((OCSPToken)token).getCertificateSource();
        }
        if (token instanceof TimestampToken) {
            return ((TimestampToken)token).getCertificateSource();
        }
        return null;
    }

    private List<CertificateToken> getCertificateTokenChain(Token token) {
        LinkedList<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
        for (Token chainItem : this.getCertChain(token)) {
            if (!(chainItem instanceof CertificateToken)) continue;
            certificateChain.add((CertificateToken)chainItem);
        }
        return certificateChain;
    }

    private CertificateToken getIssuer(Token token) {
        return this.getIssuer(token, null);
    }

    private CertificateToken getIssuer(Token token, CertificateSource certificateSource) {
        CertificateToken issuerCertificateToken = this.getIssuerFromProcessedCertificates(token);
        if (issuerCertificateToken != null) {
            if (certificateSource != null) {
                this.addEquivalentCertificates(issuerCertificateToken, certificateSource);
            }
            return issuerCertificateToken;
        }
        Set<CertificateToken> candidates = Collections.emptySet();
        if (!this.tokenIssuerMap.containsKey(token)) {
            if (certificateSource == null) {
                certificateSource = this.getTokenCertificateSource(token);
            }
            if (certificateSource != null) {
                candidates = this.getIssuersFromSource(token, certificateSource);
            }
            if (Utils.isCollectionEmpty(candidates)) {
                candidates = this.getIssuersFromSources(token, this.documentCertificateSource);
            }
        }
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = this.getIssuersFromSources(token, allCertificateSources);
        }
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = new HashSet();
            candidates.addAll(this.processedCertificates);
            candidates.addAll(this.documentCertificateSource.getCertificates());
        }
        if ((issuerCertificateToken = new TokenIssuerSelector(token, candidates = this.ensureCandidatesFromProcessedCertificates(candidates)).getIssuer()) == null && this.aiaSource != null && token instanceof CertificateToken && !this.tokenIssuerMap.containsKey(token)) {
            AIACertificateSource aiaCertificateSource = new AIACertificateSource((CertificateToken)token, this.aiaSource);
            issuerCertificateToken = aiaCertificateSource.getIssuerFromAIA();
            this.addCertificateSource(this.aiaCertificateSources, aiaCertificateSource);
        }
        if (issuerCertificateToken == null && token instanceof OCSPToken) {
            issuerCertificateToken = this.getOCSPIssuer((OCSPToken)token, allCertificateSources);
        }
        if (issuerCertificateToken == null && token instanceof TimestampToken) {
            issuerCertificateToken = this.getTSACertificate((TimestampToken)token, allCertificateSources);
        }
        if (issuerCertificateToken != null) {
            this.addCertificateTokenForVerification(issuerCertificateToken);
        }
        this.addToCacheMap(token, issuerCertificateToken);
        return issuerCertificateToken;
    }

    private Set<CertificateToken> ensureCandidatesFromProcessedCertificates(Set<CertificateToken> candidates) {
        if (Utils.isCollectionEmpty(candidates)) {
            return Collections.emptySet();
        }
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateToken certificateToken : candidates) {
            for (CertificateToken processedCertificate : this.processedCertificates) {
                if (!certificateToken.equals((Object)processedCertificate)) continue;
                certificateToken = processedCertificate;
                break;
            }
            result.add(certificateToken);
        }
        return result;
    }

    private void addToCacheMap(Token token, CertificateToken issuerCertificateToken) {
        this.tokenIssuerMap.put(token, issuerCertificateToken);
        if (token instanceof CertificateToken) {
            Set<CertificateToken> childrenCertificates = this.certificateChildrenMap.get(issuerCertificateToken);
            if (Utils.isCollectionEmpty(childrenCertificates)) {
                childrenCertificates = new HashSet<CertificateToken>();
                this.certificateChildrenMap.put((Token)issuerCertificateToken, childrenCertificates);
            }
            childrenCertificates.add((CertificateToken)token);
        }
    }

    private CertificateToken getIssuerFromProcessedCertificates(Token token) {
        CertificateToken issuerCertificateToken = this.tokenIssuerMap.get(token);
        if (issuerCertificateToken != null && (token.getPublicKeyOfTheSigner() != null || token.isSignedBy(issuerCertificateToken))) {
            return issuerCertificateToken;
        }
        return null;
    }

    @Override
    public ListCertificateSource getAllCertificateSources() {
        ListCertificateSource allCertificateSources = new ListCertificateSource();
        allCertificateSources.addAll(this.documentCertificateSource);
        allCertificateSources.addAll(this.revocationCertificateSources);
        allCertificateSources.addAll(this.aiaCertificateSources);
        allCertificateSources.addAll(this.adjunctCertSources);
        allCertificateSources.addAll(this.trustedCertSources);
        return allCertificateSources;
    }

    @Override
    public ListCertificateSource getDocumentCertificateSource() {
        return this.documentCertificateSource;
    }

    @Override
    public ListRevocationSource<CRL> getDocumentCRLSource() {
        return this.documentCRLSource;
    }

    @Override
    public ListRevocationSource<OCSP> getDocumentOCSPSource() {
        return this.documentOCSPSource;
    }

    private Set<CertificateToken> getIssuersFromSources(Token token, ListCertificateSource allCertificateSources) {
        if (token.getIssuerEntityKey() != null) {
            EntityIdentifier entityKey = token.getIssuerEntityKey();
            return allCertificateSources.getByEntityKey(entityKey);
        }
        if (token.getPublicKeyOfTheSigner() != null) {
            return allCertificateSources.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return allCertificateSources.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private Set<CertificateToken> getIssuersFromSource(Token token, CertificateSource certificateSource) {
        if (token.getIssuerEntityKey() != null) {
            EntityIdentifier entityKey = token.getIssuerEntityKey();
            return certificateSource.getByEntityKey(entityKey);
        }
        if (token.getPublicKeyOfTheSigner() != null) {
            return certificateSource.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return certificateSource.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private CertificateToken getOCSPIssuer(OCSPToken token, ListCertificateSource allCertificateSources) {
        CertificateRef signingCertificateRef;
        ResponderId responderId;
        Set<CertificateRef> signingCertificateRefs = token.getCertificateSource().getAllCertificateRefs();
        if (Utils.collectionSize(signingCertificateRefs) == 1 && (responderId = (signingCertificateRef = signingCertificateRefs.iterator().next()).getResponderId()) != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            if (responderId.getSki() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySki(responderId.getSki()));
            }
            if (responderId.getX500Principal() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySubject(new X500PrincipalHelper(responderId.getX500Principal())));
            }
            return new TokenIssuerSelector(token, issuerCandidates).getIssuer();
        }
        LOG.warn("Signing certificate is not found for an OCSPToken with id '{}'.", (Object)token.getDSSIdAsString());
        return null;
    }

    private CertificateToken getTSACertificate(TimestampToken timestamp, ListCertificateSource allCertificateSources) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = timestamp.getCandidatesForSigningCertificate();
        CertificateValidity theBestCandidate = candidatesForSigningCertificate.getTheBestCandidate();
        if (theBestCandidate != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            CertificateToken timestampSigner = theBestCandidate.getCertificateToken();
            if (timestampSigner == null) {
                issuerCandidates.addAll(allCertificateSources.getBySignerIdentifier(theBestCandidate.getSignerInfo()));
            } else {
                issuerCandidates.add(timestampSigner);
            }
            return new TokenIssuerSelector(timestamp, issuerCandidates).getIssuer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                this.registerPOE(token.getDSSIdAsString(), this.currentTime);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokenForVerification(RevocationToken<?> revocationToken) {
        if (this.addTokenForVerification(revocationToken)) {
            CertificateToken issuerCertificateToken;
            RevocationCertificateSource revocationCertificateSource = revocationToken.getCertificateSource();
            if (revocationCertificateSource != null) {
                this.addCertificateSource(this.revocationCertificateSources, revocationCertificateSource);
            }
            if ((issuerCertificateToken = revocationToken.getIssuerCertificateToken()) != null) {
                this.addCertificateTokenForVerification(issuerCertificateToken);
            }
            boolean added = this.processedRevocations.add(revocationToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("RevocationToken added to processedRevocations: {} ", revocationToken);
                } else {
                    LOG.trace("RevocationToken already present processedRevocations: {} ", revocationToken);
                }
            }
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification((Token)certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedCertificates: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedCertificates: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            this.addDocumentCertificateSource(timestampToken.getCertificateSource());
            this.addDocumentCRLSource(timestampToken.getCRLSource());
            this.addDocumentOCSPSource(timestampToken.getOCSPSource());
            List<CertificateValidity> certificateValidities = timestampToken.getCandidatesForSigningCertificate().getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    this.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
            this.registerTimestampUsageDate(timestampToken);
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedTimestamps: {} ", this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedTimestamps: {} ", this.processedTimestamps);
                }
            }
        }
    }

    private void registerTimestampUsageDate(TimestampToken timestampToken) {
        CertificateToken tsaCertificate = this.getTSACertificate(timestampToken, this.getAllCertificateSources());
        if (tsaCertificate == null) {
            LOG.warn("No Timestamp Certificate found. Chain is skipped.");
            return;
        }
        List<CertificateToken> tsaCertificateChain = this.toCertificateTokenChain(this.getCertChain(timestampToken));
        Date usageDate = timestampToken.getCreationDate();
        for (CertificateToken cert : tsaCertificateChain) {
            List timestampCertChainUsageTimes = this.timestampCertChainDates.computeIfAbsent(cert, k -> new ArrayList());
            if (timestampCertChainUsageTimes.contains(usageDate)) continue;
            timestampCertChainUsageTimes.add(usageDate);
        }
    }

    private void registerTimestampPOE(TimestampToken timestampToken) {
        if (this.isTimestampValid(timestampToken)) {
            LOG.debug("Extracting POE from timestamp : {}", (Object)timestampToken.getDSSIdAsString());
            for (TimestampedReference timestampedReference : timestampToken.getTimestampedReferences()) {
                this.registerPOE(timestampedReference.getObjectId(), timestampToken);
            }
        }
    }

    protected boolean isTimestampValid(TimestampToken timestampToken) {
        List<CertificateToken> certificateTokenChain = this.getCertificateTokenChain(timestampToken);
        Date lowestPOETime = this.getLowestPOETime(timestampToken);
        return this.getTimestampTokenVerifier().isAcceptable(timestampToken, certificateTokenChain, lowestPOETime);
    }

    private void registerPOE(String tokenId, TimestampToken timestampToken) {
        List<POE> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<POE>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(new POE(timestampToken));
    }

    private void registerPOE(String tokenId, Date poeTime) {
        List<POE> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<POE>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(new POE(poeTime));
    }

    private List<CertificateToken> toCertificateTokenChain(List<Token> tokens) {
        LinkedList<CertificateToken> chain = new LinkedList<CertificateToken>();
        for (Token token : tokens) {
            if (!(token instanceof CertificateToken)) continue;
            chain.add((CertificateToken)token);
        }
        return chain;
    }

    @Override
    public void addEvidenceRecordForVerification(EvidenceRecord evidenceRecord) {
        this.addDocumentCertificateSource(evidenceRecord.getCertificateSource());
        this.addDocumentCRLSource(evidenceRecord.getCRLSource());
        this.addDocumentOCSPSource(evidenceRecord.getOCSPSource());
        this.prepareTimestamps(evidenceRecord.getTimestamps());
        boolean added = this.processedEvidenceRecords.add(evidenceRecord);
        if (LOG.isTraceEnabled()) {
            if (added) {
                LOG.trace("EvidenceRecord added to processedEvidenceRecords: {} ", this.processedSignatures);
            } else {
                LOG.trace("EvidenceRecord already present processedEvidenceRecords: {} ", this.processedSignatures);
            }
        }
    }

    @Override
    public void validate() {
        TimestampToken timestampToken = this.getNotYetVerifiedTimestamp();
        while (timestampToken != null) {
            this.validateTimestamp(timestampToken);
            timestampToken = this.getNotYetVerifiedTimestamp();
        }
        Token token = this.getNotYetVerifiedToken();
        while (token != null) {
            this.validateToken(token);
            token = this.getNotYetVerifiedToken();
        }
    }

    private void validateTimestamp(TimestampToken timestampToken) {
        List<Token> certChain = this.getCertChain(timestampToken);
        Token token = this.getNotYetVerifiedTokenFromChain(certChain);
        while (token != null) {
            this.validateToken(token);
            token = this.getNotYetVerifiedTokenFromChain(certChain);
        }
        this.registerTimestampPOE(timestampToken);
    }

    private void validateToken(Token token) {
        Token certChainToken;
        List<Token> certChain = this.getCertChain(token);
        if (Utils.collectionSize(certChain) > 1 && (certChainToken = this.getNotYetVerifiedTokenFromChain(certChain)) != null) {
            this.validateToken(certChainToken);
        }
        if (token instanceof CertificateToken) {
            this.findRevocationData((CertificateToken)token, certChain);
        }
    }

    private void validateTokenIfNeeded(Token token) {
        this.addTokenForVerification(token);
        if (!this.isYetVerified(token)) {
            this.validateToken(token);
        }
    }

    private Set<RevocationToken<?>> findRevocationData(CertificateToken certToken, List<Token> certChain) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for : {}", (Object)certToken.getDSSIdAsString());
        }
        if (this.isRevocationDataNotRequired(certToken, this.getLowestPOETime((Token)certToken))) {
            LOG.debug("Revocation data is not required for certificate : {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptySet();
        }
        CertificateToken issuerToken = this.getIssuer((Token)certToken);
        if (issuerToken == null) {
            LOG.warn("Issuer not found for certificate {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptySet();
        }
        HashSet revocations = new HashSet();
        List<RevocationToken<CRL>> crlTokens = this.documentCRLSource.getRevocationTokens(certToken, issuerToken);
        for (RevocationToken<CRL> revocationToken : crlTokens) {
            revocations.add(revocationToken);
            this.addRevocationTokenForVerification(revocationToken);
        }
        List<RevocationToken<OCSP>> ocspTokens = this.documentOCSPSource.getRevocationTokens(certToken, issuerToken);
        for (RevocationToken<OCSP> revocationToken : ocspTokens) {
            revocations.add(revocationToken);
            this.addRevocationTokenForVerification(revocationToken);
            this.addDocumentCertificateSource(revocationToken.getCertificateSource());
        }
        revocations.addAll(this.getRelatedRevocationTokens(certToken));
        if ((this.remoteOCSPSource != null || this.remoteCRLSource != null) && (Utils.isCollectionEmpty(revocations) || this.isRevocationDataRefreshNeeded(certToken, revocations))) {
            LOG.debug("The signature does not contain relative revocation data.");
            if (this.checkRevocationForUntrustedChains || this.containsTrustAnchor(certChain)) {
                LOG.trace("Revocation update is in progress for certificate : {}", (Object)certToken.getDSSIdAsString());
                CertificateToken certificateToken = (CertificateToken)this.getFirstTrustAnchor(certChain);
                RevocationToken<?> revocationToken = this.getRevocationToken(certToken, issuerToken, certificateToken);
                if (revocationToken != null && !revocations.contains(revocationToken)) {
                    LOG.debug("Obtained a new revocation data : {}, for certificate : {}", (Object)revocationToken.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
                    revocations.add(revocationToken);
                    this.addRevocationTokenForVerification(revocationToken);
                    this.linkRevocationToOtherCertificates(revocationToken, certToken, issuerToken);
                }
            } else {
                LOG.warn("External revocation check is skipped for untrusted certificate : {}", (Object)certToken.getDSSIdAsString());
            }
        }
        if (revocations.isEmpty()) {
            LOG.warn("No revocation found for the certificate {}", (Object)certToken.getDSSIdAsString());
        }
        return revocations;
    }

    @Override
    public List<RevocationToken<?>> getRevocationData(CertificateToken certificateToken) {
        this.validateTokenIfNeeded((Token)certificateToken);
        ArrayList result = new ArrayList();
        for (RevocationToken<?> revocationToken : this.processedRevocations) {
            if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateId())) continue;
            result.add(revocationToken);
        }
        return result;
    }

    private <T extends Token> boolean containsTrustAnchor(List<T> certChain) {
        return this.getFirstTrustAnchor(certChain) != null;
    }

    private <T extends Token> Token getFirstTrustAnchor(List<T> certChain) {
        if (Utils.isCollectionNotEmpty(certChain)) {
            for (Token token : certChain) {
                if (!this.isTrustedAtUsageTime(token)) continue;
                return token;
            }
        }
        return null;
    }

    private <T extends Token> boolean containsTrustAnchorAtTime(List<T> certChain, Date controlTime) {
        if (Utils.isCollectionNotEmpty(certChain)) {
            for (Token token : certChain) {
                if (!this.isTrustedAtTime(token, controlTime)) continue;
                return true;
            }
        }
        return false;
    }

    private void linkRevocationToOtherCertificates(RevocationToken<?> revocationToken, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        if (revocationToken instanceof CRLToken) {
            CRLToken crlToken = (CRLToken)revocationToken;
            Set<CertificateToken> certificateTokens = this.certificateChildrenMap.get(issuerCertificateToken);
            for (CertificateToken childCertificate : certificateTokens) {
                if (certificateToken == childCertificate) continue;
                CRLToken newCRLToken = new CRLToken(childCertificate, crlToken.getCrlValidity());
                newCRLToken.setExternalOrigin(crlToken.getExternalOrigin());
                newCRLToken.setSourceURL(crlToken.getSourceURL());
                this.addRevocationTokenForVerification(newCRLToken);
            }
        }
    }

    private RevocationToken<?> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificate, CertificateToken trustAnchor) {
        RevocationSource<CRL> currentCRLSource;
        RevocationSource<OCSP> currentOCSPSource;
        if (!this.trustedCertSources.isEmpty() && trustAnchor != null) {
            LOG.trace("Initializing a revocation verifier for a trusted chain...");
            currentOCSPSource = this.instantiateOCSPWithTrustServices(trustAnchor);
            currentCRLSource = this.instantiateCRLWithTrustServices(trustAnchor);
        } else {
            LOG.trace("Initializing a revocation verifier for not trusted chain...");
            currentOCSPSource = this.remoteOCSPSource;
            currentCRLSource = this.remoteCRLSource;
        }
        RevocationDataLoadingStrategy revocationDataLoadingStrategy = this.revocationDataLoadingStrategyFactory.create();
        revocationDataLoadingStrategy.setCrlSource(currentCRLSource);
        revocationDataLoadingStrategy.setOcspSource(currentOCSPSource);
        revocationDataLoadingStrategy.setRevocationDataVerifier(this.getRevocationDataVerifier());
        revocationDataLoadingStrategy.setFallbackEnabled(this.revocationFallback);
        return revocationDataLoadingStrategy.getRevocationToken(certificateToken, issuerCertificate);
    }

    private RevocationSource<OCSP> instantiateOCSPWithTrustServices(CertificateToken trustAnchor) {
        List<String> alternativeOCSPUrls = this.getAlternativeOCSPUrls(trustAnchor);
        if (Utils.isCollectionNotEmpty(alternativeOCSPUrls) && this.remoteOCSPSource instanceof RevocationSourceAlternateUrlsSupport) {
            return new AlternateUrlsSourceAdapter<OCSP>((RevocationSourceAlternateUrlsSupport)this.remoteOCSPSource, alternativeOCSPUrls);
        }
        return this.remoteOCSPSource;
    }

    private RevocationSource<CRL> instantiateCRLWithTrustServices(CertificateToken trustAnchor) {
        List<String> alternativeCRLUrls = this.getAlternativeCRLUrls(trustAnchor);
        if (Utils.isCollectionNotEmpty(alternativeCRLUrls) && this.remoteCRLSource instanceof RevocationSourceAlternateUrlsSupport) {
            return new AlternateUrlsSourceAdapter<CRL>((RevocationSourceAlternateUrlsSupport)this.remoteCRLSource, alternativeCRLUrls);
        }
        return this.remoteCRLSource;
    }

    private List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeOCSPUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof TrustedCertificateSource)) continue;
            TrustedCertificateSource trustedCertSource = (TrustedCertificateSource)certificateSource;
            alternativeOCSPUrls.addAll(trustedCertSource.getAlternativeOCSPUrls(trustAnchor));
        }
        return alternativeOCSPUrls;
    }

    private List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeCRLUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof TrustedCertificateSource)) continue;
            TrustedCertificateSource trustedCertSource = (TrustedCertificateSource)certificateSource;
            alternativeCRLUrls.addAll(trustedCertSource.getAlternativeCRLUrls(trustAnchor));
        }
        return alternativeCRLUrls;
    }

    @Override
    public boolean checkAllRequiredRevocationDataPresent() {
        return this.allRequiredRevocationDataPresent().isEmpty();
    }

    protected TokenStatus allRequiredRevocationDataPresent() {
        TokenStatus status = new TokenStatus();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (List<CertificateToken> orderedCertChain : orderedCertificateChains.values()) {
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(orderedCertChain, null, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revocation data is missing for one or more certificate(s).");
        }
        return status;
    }

    private void checkRevocationForCertificateChainAgainstBestSignatureTime(List<CertificateToken> certificates, Date bestSignatureTime, TokenStatus status) {
        for (CertificateToken certificateToken : certificates) {
            Date lowestPOETime;
            if (this.isSelfSignedOrTrustedAtTime(certificateToken, bestSignatureTime)) break;
            if (this.isRevocationDataNotRequired(certificateToken, bestSignatureTime)) continue;
            boolean found = false;
            Date earliestNextUpdate = null;
            List<RevocationToken<?>> relatedRevocationTokens = this.getRelatedRevocationTokens(certificateToken);
            for (RevocationToken<?> revocationToken : relatedRevocationTokens) {
                if (bestSignatureTime == null || bestSignatureTime.before(revocationToken.getThisUpdate())) {
                    found = true;
                    break;
                }
                if (revocationToken.getNextUpdate() == null || earliestNextUpdate != null && !earliestNextUpdate.after(revocationToken.getNextUpdate()) || !this.currentTime.before(revocationToken.getNextUpdate())) continue;
                earliestNextUpdate = revocationToken.getNextUpdate();
            }
            if (found) continue;
            if (!this.getCertificateVerifier().isCheckRevocationForUntrustedChains() && !this.containsTrustAnchorAtTime(certificates, bestSignatureTime)) {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, "Revocation data is skipped for untrusted certificate chain!");
            } else if (Utils.isCollectionEmpty(relatedRevocationTokens) || bestSignatureTime == null) {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, "No revocation data found for certificate!");
            } else if (earliestNextUpdate != null) {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, String.format("No revocation data found after the best signature time [%s]! The nextUpdate available after : [%s]", DSSUtils.formatDateToRFC(bestSignatureTime), DSSUtils.formatDateToRFC(earliestNextUpdate)));
            } else {
                status.addRelatedTokenAndErrorMessage((Token)certificateToken, String.format("No revocation data found after the best signature time [%s]!", DSSUtils.formatDateToRFC(bestSignatureTime)));
            }
            if (!(status instanceof RevocationFreshnessStatus)) continue;
            if (Utils.isCollectionNotEmpty(relatedRevocationTokens) && this.noNextUpdateDefined(relatedRevocationTokens) && earliestNextUpdate == null && (lowestPOETime = this.getLowestPOETime((Token)certificateToken)) != null) {
                earliestNextUpdate = new Date(lowestPOETime.getTime() + 1000L);
            }
            if (earliestNextUpdate == null) continue;
            ((RevocationFreshnessStatus)status).addTokenAndRevocationNextUpdateTime((Token)certificateToken, earliestNextUpdate);
        }
    }

    private boolean noNextUpdateDefined(List<RevocationToken<?>> relatedRevocationTokens) {
        return relatedRevocationTokens.stream().noneMatch(revocationToken -> revocationToken.getNextUpdate() != null);
    }

    @Override
    public boolean checkAllPOECoveredByRevocationData() {
        return this.allPOECoveredByRevocationData().isEmpty();
    }

    protected RevocationFreshnessStatus allPOECoveredByRevocationData() {
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            Date lastCertUsageDate = this.getLatestTimestampUsageDate(firstChainCertificate);
            if (lastCertUsageDate == null) continue;
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), lastCertUsageDate, status);
        }
        if (!status.isEmpty()) {
            status.setMessage("Revocation data is missing for one or more POE(s).");
        }
        return status;
    }

    @Override
    public boolean checkAllTimestampsValid() {
        return this.allTimestampsValid().isEmpty();
    }

    protected TokenStatus allTimestampsValid() {
        TokenStatus status = new TokenStatus();
        for (TimestampToken timestampToken : this.processedTimestamps) {
            if (timestampToken.isSignatureIntact() && timestampToken.isMessageImprintDataFound() && timestampToken.isMessageImprintDataIntact()) continue;
            status.addRelatedTokenAndErrorMessage(timestampToken, "Signature is not intact!");
        }
        if (!status.isEmpty()) {
            status.setMessage("Broken timestamp(s) detected.");
        }
        return status;
    }

    @Override
    public boolean checkCertificateNotRevoked(CertificateToken certificateToken) {
        return this.certificateNotRevoked(certificateToken).isEmpty();
    }

    protected TokenStatus certificateNotRevoked(CertificateToken certificateToken) {
        TokenStatus status = new TokenStatus();
        this.checkCertificateIsNotRevokedRecursively(certificateToken, this.poeTimes.get(certificateToken.getDSSIdAsString()), status);
        if (!status.isEmpty()) {
            status.setMessage("Revoked/Suspended certificate(s) detected.");
        }
        return status;
    }

    @Override
    public boolean checkAllSignatureCertificatesNotRevoked() {
        return this.allSignatureCertificatesNotRevoked().isEmpty();
    }

    protected TokenStatus allSignatureCertificatesNotRevoked() {
        TokenStatus status = new TokenStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkSignatureCertificatesNotRevoked(signature, status);
        }
        if (!status.isEmpty()) {
            status.setMessage("Revoked/Suspended certificate(s) detected.");
        }
        return status;
    }

    private void checkSignatureCertificatesNotRevoked(AdvancedSignature signature, TokenStatus status) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            this.checkCertificateIsNotRevokedRecursively(signingCertificate, this.poeTimes.get(signature.getId()), status);
        }
    }

    private boolean checkCertificateIsNotRevokedRecursively(CertificateToken certificateToken, List<POE> poeTimes, TokenStatus status) {
        CertificateToken issuer;
        List<RevocationToken<?>> relatedRevocationTokens;
        Date lowestPOETime = this.getLowestPOETime(poeTimes);
        if (this.isSelfSignedOrTrustedAtTime(certificateToken, lowestPOETime)) {
            return true;
        }
        if (!this.isRevocationDataNotRequired(certificateToken, lowestPOETime) && Utils.isCollectionNotEmpty(relatedRevocationTokens = this.getRelatedRevocationTokens(certificateToken))) {
            for (RevocationToken<?> revocationToken : relatedRevocationTokens) {
                if (this.getRevocationDataVerifier().checkCertificateNotRevoked(revocationToken, lowestPOETime)) continue;
                if (status != null) {
                    status.addRelatedTokenAndErrorMessage((Token)certificateToken, "Certificate is revoked/suspended!");
                }
                return false;
            }
        }
        if ((issuer = this.getIssuer((Token)certificateToken)) != null) {
            return this.checkCertificateIsNotRevokedRecursively(issuer, poeTimes, status);
        }
        return true;
    }

    private boolean isRevocationDataNotRequired(CertificateToken certToken, Date controlTime) {
        return this.getRevocationDataVerifier().isRevocationDataSkip(certToken, controlTime);
    }

    private boolean isSelfSignedOrTrustedAtTime(CertificateToken certToken, Date controlTime) {
        return this.isSelfSigned(certToken) || this.isTrustedAtTime(certToken, controlTime);
    }

    private boolean isSelfSigned(CertificateToken certToken) {
        return certToken.isSelfSigned();
    }

    private List<RevocationToken<?>> getRelatedRevocationTokens(CertificateToken certificateToken) {
        return this.getRevocationData(certificateToken);
    }

    private boolean isRevocationDataRefreshNeeded(CertificateToken certToken, Collection<RevocationToken<?>> revocations) {
        Date lastTimestampUsageTime;
        Context context = null;
        Date refreshNeededAfterTime = this.getLatestBestSignatureTime(certToken);
        if (refreshNeededAfterTime != null) {
            context = Context.SIGNATURE;
        }
        if ((lastTimestampUsageTime = this.getLatestTimestampUsageDate(certToken)) != null && context == null) {
            context = Context.TIMESTAMP;
        }
        if (refreshNeededAfterTime == null) {
            refreshNeededAfterTime = this.getLowestPOETime((Token)certToken);
            if (context == null) {
                context = Context.REVOCATION;
            }
        }
        boolean freshRevocationDataFound = false;
        for (RevocationToken<?> revocationToken : revocations) {
            List<CertificateToken> certificateTokenChain = this.toCertificateTokenChain(this.getCertChain(revocationToken));
            if (Utils.isCollectionEmpty(certificateTokenChain)) {
                LOG.debug("Certificate chain is not found for a revocation data '{}'!", (Object)revocationToken.getDSSIdAsString());
                continue;
            }
            CertificateToken issuerCertificateToken = certificateTokenChain.iterator().next();
            if (!this.isRevocationFresh(revocationToken, refreshNeededAfterTime, context) || !this.isRevocationIssuedAfterLastTimestampUsage(revocationToken, lastTimestampUsageTime, context) || RevocationReason.CERTIFICATE_HOLD == revocationToken.getReason() || !this.isRevocationAcceptable(revocationToken, issuerCertificateToken, this.getLowestPOETime((Token)issuerCertificateToken)) || !this.hasValidPOE(revocationToken, certToken, issuerCertificateToken)) continue;
            freshRevocationDataFound = true;
            break;
        }
        if (!freshRevocationDataFound) {
            LOG.debug("Revocation data refresh is needed");
            return true;
        }
        return false;
    }

    private Date getLatestBestSignatureTime(CertificateToken certificateToken) {
        Date latestPOETime = null;
        for (Date bestSignatureTime : this.getBestSignatureTimes(certificateToken)) {
            if (latestPOETime != null && !bestSignatureTime.after(latestPOETime)) continue;
            latestPOETime = bestSignatureTime;
        }
        return latestPOETime;
    }

    private List<Date> getBestSignatureTimes(CertificateToken certificateToken) {
        List<AdvancedSignature> signatures = this.certificateSignaturesUsage.get(certificateToken);
        if (Utils.isCollectionEmpty(signatures)) {
            return Collections.emptyList();
        }
        ArrayList<Date> bestSignatureTimes = new ArrayList<Date>();
        for (AdvancedSignature signature : signatures) {
            Date poeTime = this.getLowestPOETime(this.poeTimes.get(signature.getId()));
            if (poeTime == null) continue;
            bestSignatureTimes.add(poeTime);
        }
        return bestSignatureTimes;
    }

    private Date getLatestTimestampUsageDate(CertificateToken certificateToken) {
        return this.getLatestTime(this.timestampCertChainDates.get(certificateToken));
    }

    private Date getLatestTime(List<Date> dates) {
        if (Utils.isCollectionNotEmpty(dates)) {
            Date latestTime = null;
            for (Date date : dates) {
                if (latestTime != null && !date.after(latestTime)) continue;
                latestTime = date;
            }
            return latestTime;
        }
        return null;
    }

    private Date getLowestPOETime(Token token) {
        return this.getLowestPOETime(this.poeTimes.get(token.getDSSIdAsString()));
    }

    private Date getLowestPOETime(List<POE> poeList) {
        return this.getLowestPOE(poeList).getTime();
    }

    private POE getLowestPOE(List<POE> poeList) {
        if (Utils.isCollectionEmpty(poeList)) {
            throw new IllegalStateException("POE shall be defined before accessing the 'poeTimes' list!");
        }
        Iterator<POE> it = poeList.iterator();
        POE lowestPOE = it.next();
        while (it.hasNext()) {
            POE poe = it.next();
            if (!poe.getTime().before(lowestPOE.getTime())) continue;
            lowestPOE = poe;
        }
        return lowestPOE;
    }

    private boolean isRevocationFresh(RevocationToken<?> revocationToken, Date refreshNeededAfterTime, Context context) {
        return this.getRevocationDataVerifier().isRevocationDataFresh(revocationToken, refreshNeededAfterTime, context);
    }

    private boolean isRevocationIssuedAfterLastTimestampUsage(RevocationToken<?> revocationToken, Date lastTimestampUsage, Context context) {
        if (lastTimestampUsage == null) {
            return true;
        }
        return this.getRevocationDataVerifier().isRevocationDataFresh(revocationToken, lastTimestampUsage, context);
    }

    private boolean isRevocationAcceptable(RevocationToken<?> revocation, CertificateToken issuerCertificateToken, Date controlTime) {
        return this.getRevocationDataVerifier().isAcceptable(revocation, issuerCertificateToken, this.getCertificateTokenChain((Token)issuerCertificateToken), controlTime);
    }

    private boolean hasValidPOE(RevocationToken<?> revocation, CertificateToken relatedCertToken, CertificateToken issuerCertToken) {
        if (revocation.getNextUpdate() != null && !this.hasPOEAfterThisUpdateAndBeforeNextUpdate(revocation)) {
            LOG.debug("There is no POE for the revocation '{}' after its production time and before the nextUpdate! Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)relatedCertToken.getDSSIdAsString());
            return false;
        }
        if (issuerCertToken != null && !this.isTrustedAtUsageTime(issuerCertToken, Context.REVOCATION) && !this.hasPOEInTheValidityRange(issuerCertToken)) {
            LOG.debug("There is no POE for the revocation issuer '{}' for revocation '{}' within its validity range! Certificate: {}", new Object[]{issuerCertToken.getDSSIdAsString(), revocation.getDSSIdAsString(), relatedCertToken.getDSSIdAsString()});
            return false;
        }
        LOG.debug("The revocation '{}' has a valid POE. Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)relatedCertToken.getDSSIdAsString());
        return true;
    }

    private boolean hasPOEAfterThisUpdateAndBeforeNextUpdate(RevocationToken<?> revocation) {
        List<POE> poeTimeList = this.poeTimes.get(revocation.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!this.getRevocationDataVerifier().isAfterThisUpdateAndBeforeNextUpdate(revocation, poeTime.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPOEInTheValidityRange(CertificateToken certificateToken) {
        List<POE> poeTimeList = this.poeTimes.get(certificateToken.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!certificateToken.isValidOn(poeTime.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkAllSignatureCertificateHaveFreshRevocationData() {
        return this.allSignatureCertificateHaveFreshRevocationData().isEmpty();
    }

    protected RevocationFreshnessStatus allSignatureCertificateHaveFreshRevocationData() {
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signature, status);
        }
        if (!status.isEmpty()) {
            status.setMessage("Fresh revocation data is missing for one or more certificate(s).");
        }
        return status;
    }

    private void checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(AdvancedSignature signature, RevocationFreshnessStatus status) {
        CertificateToken signingCertificateToken = signature.getSigningCertificateToken();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            if (!firstChainCertificate.equals((Object)signingCertificateToken)) continue;
            Date bestSignatureTime = this.getEarliestTimestampTime();
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), bestSignatureTime, status);
        }
    }

    private Date getEarliestTimestampTime() {
        Date earliestDate = null;
        for (TimestampToken timestamp : this.getProcessedTimestamps()) {
            if (!timestamp.getTimeStampType().coversSignature()) continue;
            Date timestampTime = timestamp.getCreationDate();
            if (earliestDate != null && !timestampTime.before(earliestDate)) continue;
            earliestDate = timestampTime;
        }
        return earliestDate;
    }

    @Override
    public boolean checkAllSignaturesNotExpired() {
        return this.allSignaturesNotExpired().isEmpty();
    }

    protected SignatureStatus allSignaturesNotExpired() {
        SignatureStatus status = new SignatureStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkSignatureNotExpired(signature, status);
        }
        if (!status.isEmpty()) {
            status.setMessage("Expired signature found.");
        }
        return status;
    }

    @Override
    public boolean checkCertificateNotExpired(CertificateToken certificateToken) {
        return this.certificateNotExpired(certificateToken).isEmpty();
    }

    protected TokenStatus certificateNotExpired(CertificateToken certificateToken) {
        TokenStatus status = new TokenStatus();
        this.checkCertificateNotExpired(certificateToken, status);
        if (!status.isEmpty()) {
            status.setMessage("Expired certificate found.");
        }
        return status;
    }

    private void checkSignatureNotExpired(AdvancedSignature signature, SignatureStatus status) {
        boolean signatureNotExpired;
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null && !(signatureNotExpired = this.verifyCertificateTokenNotExpired(signingCertificate, this.poeTimes.get(signature.getId())))) {
            status.addRelatedTokenAndErrorMessage(signature, String.format("The signing certificate has expired and there is no POE during its validity range : [%s - %s]!", DSSUtils.formatDateToRFC(signingCertificate.getNotBefore()), DSSUtils.formatDateToRFC(signingCertificate.getNotAfter())));
        }
    }

    private void checkCertificateNotExpired(CertificateToken certificateToken, TokenStatus status) {
        boolean certificateNotExpired = this.verifyCertificateTokenNotExpired(certificateToken, this.poeTimes.get(certificateToken.getDSSIdAsString()));
        if (!certificateNotExpired) {
            status.addRelatedTokenAndErrorMessage((Token)certificateToken, String.format("The signing certificate has expired and there is no POE during its validity range : [%s - %s]!", DSSUtils.formatDateToRFC(certificateToken.getNotBefore()), DSSUtils.formatDateToRFC(certificateToken.getNotAfter())));
        }
    }

    private boolean verifyCertificateTokenNotExpired(CertificateToken certificateToken, List<POE> poeTimeList) {
        if (Utils.isCollectionNotEmpty(poeTimeList) && certificateToken.getNotAfter() != null) {
            for (POE poeTime : poeTimeList) {
                if (poeTime.getTime() == null || poeTime.getTime().after(certificateToken.getNotAfter())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkAllSignaturesAreYetValid() {
        return this.allSignaturesAreYetValid().isEmpty();
    }

    protected SignatureStatus allSignaturesAreYetValid() {
        SignatureStatus status = new SignatureStatus();
        for (AdvancedSignature signature : this.processedSignatures) {
            this.checkSignatureIsYetValid(signature, status);
        }
        if (!status.isEmpty()) {
            status.setMessage("Not yet valid signature found.");
        }
        return status;
    }

    @Override
    public boolean checkCertificateIsYetValid(CertificateToken certificateToken) {
        return this.certificateNotExpired(certificateToken).isEmpty();
    }

    protected TokenStatus certificateIsYetValid(CertificateToken certificateToken) {
        TokenStatus status = new TokenStatus();
        this.checkCertificateIsYetValid(certificateToken, status);
        if (!status.isEmpty()) {
            status.setMessage("Not yet valid certificate found.");
        }
        return status;
    }

    private void checkSignatureIsYetValid(AdvancedSignature signature, SignatureStatus status) {
        boolean signatureNotExpired;
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null && !(signatureNotExpired = this.verifyCertificateTokenIsYetValid(signingCertificate, this.poeTimes.get(signature.getId())))) {
            status.addRelatedTokenAndErrorMessage(signature, String.format("The signing certificate with validity range [%s - %s] is not yet valid at signing time!", DSSUtils.formatDateToRFC(signingCertificate.getNotBefore()), DSSUtils.formatDateToRFC(signingCertificate.getNotAfter())));
        }
    }

    private void checkCertificateIsYetValid(CertificateToken certificateToken, TokenStatus status) {
        boolean certificateNotExpired = this.verifyCertificateTokenIsYetValid(certificateToken, this.poeTimes.get(certificateToken.getDSSIdAsString()));
        if (!certificateNotExpired) {
            status.addRelatedTokenAndErrorMessage((Token)certificateToken, String.format("The signing certificate with validity range [%s - %s] is not yet valid at signing time!", DSSUtils.formatDateToRFC(certificateToken.getNotBefore()), DSSUtils.formatDateToRFC(certificateToken.getNotAfter())));
        }
    }

    private boolean verifyCertificateTokenIsYetValid(CertificateToken certificateToken, List<POE> poeTimeList) {
        if (Utils.isCollectionNotEmpty(poeTimeList) && certificateToken.getNotAfter() != null) {
            for (POE poeTime : poeTimeList) {
                if (poeTime.getTime() == null || poeTime.getTime().before(certificateToken.getNotBefore())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<AdvancedSignature> getProcessedSignatures() {
        return Collections.unmodifiableSet(this.processedSignatures);
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Set<RevocationToken<?>> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    @Override
    public Set<EvidenceRecord> getProcessedEvidenceRecords() {
        return Collections.unmodifiableSet(this.processedEvidenceRecords);
    }

    private <T extends Token> boolean isTrustedAtUsageTime(T token) {
        return this.isTrustedAtUsageTime(token, null);
    }

    private <T extends Token> boolean isTrustedAtUsageTime(T token, Context context) {
        if (token instanceof CertificateToken) {
            List<Date> bestSignatureTimes = this.getBestSignatureTimes((CertificateToken)token);
            if (Utils.isCollectionNotEmpty(bestSignatureTimes)) {
                for (Date date : bestSignatureTimes) {
                    if (!this.isTrustedAtTime(token, date, context)) continue;
                    return true;
                }
            } else {
                Date lowestPOETime = this.getLowestPOETime(token);
                return this.isTrustedAtTime(token, lowestPOETime, context);
            }
        }
        return false;
    }

    private <T extends Token> boolean isTrustedAtTime(T token, Date controlTime) {
        return this.isTrustedAtTime(token, controlTime, null);
    }

    private <T extends Token> boolean isTrustedAtTime(T token, Date controlTime, Context context) {
        return token instanceof CertificateToken && this.getTrustAnchorVerifier().isTrustedAtTime((CertificateToken)token, controlTime, context);
    }

    @Override
    public ValidationData getValidationData(AdvancedSignature signature) {
        return this.getValidationData(signature.getSigningCertificateToken());
    }

    @Override
    public ValidationData getValidationData(TimestampToken timestampToken) {
        return this.getValidationData(this.getIssuer(timestampToken));
    }

    private ValidationData getValidationData(CertificateToken certificateToken) {
        ValidationData validationData = new ValidationData();
        if (certificateToken != null) {
            this.populateValidationDataRecursively((Token)certificateToken, validationData);
        }
        return validationData;
    }

    private void populateValidationDataRecursively(Token token, ValidationData validationData) {
        boolean added = validationData.addToken(token);
        if (added) {
            CertificateToken issuerToken;
            if (token instanceof CertificateToken) {
                List<RevocationToken<?>> revocationTokens = this.getRelatedRevocationTokens((CertificateToken)token);
                for (RevocationToken<?> revocationToken : revocationTokens) {
                    this.populateValidationDataRecursively(revocationToken, validationData);
                }
            }
            if ((issuerToken = this.getIssuer(token)) != null) {
                this.populateValidationDataRecursively((Token)issuerToken, validationData);
            }
        }
    }

    private static class POE {
        private final Date time;
        private TimestampToken timestampToken;

        public POE(Date time) {
            this.time = time;
        }

        public POE(TimestampToken timestampToken) {
            this.timestampToken = timestampToken;
            this.time = timestampToken.getCreationDate();
        }

        public Date getTime() {
            return this.time;
        }

        public TimestampToken getTimestampToken() {
            return this.timestampToken;
        }
    }
}

