/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.predicate.AllKeyEntryPredicate;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyStoreTokenConnection
extends AbstractSignatureTokenConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKeyStoreTokenConnection.class);
    private Predicate<DSSPrivateKeyEntry> keyEntryPredicate = new AllKeyEntryPredicate();

    protected AbstractKeyStoreTokenConnection() {
    }

    public void setKeyEntryPredicate(Predicate<DSSPrivateKeyEntry> keyEntryPredicate) {
        Objects.requireNonNull(keyEntryPredicate, "Key entry predicate cannot be null!");
        this.keyEntryPredicate = keyEntryPredicate;
    }

    protected abstract KeyStore getKeyStore() throws DSSException;

    protected abstract KeyStore.PasswordProtection getKeyProtectionParameter();

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                DSSPrivateKeyEntry dssPrivateKeyEntry = this.getDSSPrivateKeyEntry(keyStore, alias, this.getKeyProtectionParameter());
                if (dssPrivateKeyEntry == null || !this.keyEntryPredicate.test(dssPrivateKeyEntry)) continue;
                list.add(dssPrivateKeyEntry);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve keys from keystore", (Throwable)e);
        }
        return list;
    }

    public DSSPrivateKeyEntry getKey(String alias) {
        return this.getKey(alias, this.getKeyProtectionParameter());
    }

    public DSSPrivateKeyEntry getKey(String alias, KeyStore.PasswordProtection passwordProtection) {
        KeyStore keyStore = this.getKeyStore();
        return this.getDSSPrivateKeyEntry(keyStore, alias, passwordProtection);
    }

    private DSSPrivateKeyEntry getDSSPrivateKeyEntry(KeyStore keyStore, String alias, KeyStore.PasswordProtection passwordProtection) {
        try {
            if (keyStore.isKeyEntry(alias)) {
                KeyStore.Entry entry = keyStore.getEntry(alias, passwordProtection);
                if (entry instanceof KeyStore.PrivateKeyEntry) {
                    KeyStore.PrivateKeyEntry pke = (KeyStore.PrivateKeyEntry)entry;
                    return new KSPrivateKeyEntry(alias, pke);
                }
                LOG.warn("Skipped entry (unsupported class : {})", (Object)entry.getClass().getSimpleName());
            } else {
                LOG.debug("No related/supported key found for alias '{}'", (Object)alias);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve key from keystore", (Throwable)e);
        }
        return null;
    }
}

