/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.job;

import eu.europa.esig.dss.alert.Alert;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.tsl.alerts.TLValidationJobAlerter;
import eu.europa.esig.dss.tsl.cache.CacheCleaner;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessFactory;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.job.LOTLChangeApplier;
import eu.europa.esig.dss.tsl.job.TLSourceBuilder;
import eu.europa.esig.dss.tsl.runnable.LOTLAnalysis;
import eu.europa.esig.dss.tsl.runnable.LOTLWithPivotsAnalysis;
import eu.europa.esig.dss.tsl.runnable.TLAnalysis;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.source.TLSource;
import eu.europa.esig.dss.tsl.summary.ValidationJobSummaryBuilder;
import eu.europa.esig.dss.tsl.sync.AcceptAllStrategy;
import eu.europa.esig.dss.tsl.sync.SynchronizationStrategy;
import eu.europa.esig.dss.tsl.sync.TrustedListCertificateSourceSynchronizer;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLValidationJob {
    private static final Logger LOG = LoggerFactory.getLogger(TLValidationJob.class);
    private final CacheAccessFactory cacheAccessFactory = new CacheAccessFactory();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private TLSource[] trustedListSources;
    private LOTLSource[] listOfTrustedListSources;
    private DSSFileLoader offlineLoader;
    private DSSFileLoader onlineLoader;
    private CacheCleaner cacheCleaner;
    private TrustedListsCertificateSource trustedListCertificateSource;
    private SynchronizationStrategy synchronizationStrategy = new AcceptAllStrategy();
    private boolean debug = false;
    private List<Alert<LOTLInfo>> lotlAlerts;
    private List<Alert<TLInfo>> tlAlerts;

    public void setTrustedListSources(TLSource ... trustedListSources) {
        this.trustedListSources = trustedListSources;
    }

    public void setListOfTrustedListSources(LOTLSource ... listOfTrustedListSources) {
        this.listOfTrustedListSources = listOfTrustedListSources;
    }

    public void setExecutorService(ExecutorService executorService) {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
        this.executorService = executorService;
    }

    public void setOfflineDataLoader(DSSFileLoader offlineLoader) {
        this.offlineLoader = offlineLoader;
    }

    public void setOnlineDataLoader(DSSFileLoader onlineLoader) {
        this.onlineLoader = onlineLoader;
    }

    public void setCacheCleaner(CacheCleaner cacheCleaner) {
        this.cacheCleaner = cacheCleaner;
    }

    public void setTrustedListCertificateSource(TrustedListsCertificateSource trustedListCertificateSource) {
        this.trustedListCertificateSource = trustedListCertificateSource;
    }

    public void setSynchronizationStrategy(SynchronizationStrategy synchronizationStrategy) {
        Objects.requireNonNull(synchronizationStrategy, "The SynchronizationStrategy cannot be null");
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLOTLAlerts(List<Alert<LOTLInfo>> lotlAlerts) {
        this.lotlAlerts = lotlAlerts;
    }

    public void setTLAlerts(List<Alert<TLInfo>> tlAlerts) {
        this.tlAlerts = tlAlerts;
    }

    public synchronized TLValidationJobSummary getSummary() {
        return new ValidationJobSummaryBuilder(this.cacheAccessFactory.getReadOnlyCacheAccess(), this.trustedListSources, this.listOfTrustedListSources).build();
    }

    public synchronized void offlineRefresh() {
        Objects.requireNonNull(this.offlineLoader, "The offlineLoader must be defined!");
        LOG.info("Offline refresh is running...");
        this.refresh(this.offlineLoader);
        LOG.info("Offline refresh is DONE.");
    }

    public synchronized void onlineRefresh() {
        Objects.requireNonNull(this.onlineLoader, "The onlineLoader must be defined!");
        LOG.info("Online refresh is running...");
        this.refresh(this.onlineLoader);
        LOG.info("Online refresh is DONE.");
    }

    private void refresh(DSSFileLoader dssFileLoader) {
        ArrayList<TLSource> currentTLSources = new ArrayList<TLSource>();
        if (this.trustedListSources != null) {
            currentTLSources.addAll(Arrays.asList(this.trustedListSources));
        }
        if (Utils.isArrayNotEmpty((Object[])this.listOfTrustedListSources)) {
            List<LOTLSource> lotlList = Arrays.asList(this.listOfTrustedListSources);
            this.executeLOTLSourcesAnalysis(lotlList, dssFileLoader);
            currentTLSources.addAll(this.extractTlSources(lotlList));
        }
        this.executeTLSourcesAnalysis(currentTLSources, dssFileLoader);
        if (Utils.isCollectionNotEmpty(this.lotlAlerts) || Utils.isCollectionNotEmpty(this.tlAlerts)) {
            TLValidationJobSummary jobSummary = this.getSummary();
            TLValidationJobAlerter alerter = new TLValidationJobAlerter(this.lotlAlerts, this.tlAlerts);
            alerter.detectChanges(jobSummary);
        }
        if (this.debug) {
            LOG.info("Dump before synchronization");
            this.cacheAccessFactory.getDebugCacheAccess().dump();
        }
        this.synchronizeTLCertificateSource();
        this.executeCacheCleaner();
        if (this.debug) {
            LOG.info("Dump after synchronization");
            this.cacheAccessFactory.getDebugCacheAccess().dump();
        }
    }

    private void executeLOTLSourcesAnalysis(List<LOTLSource> lotlSources, DSSFileLoader dssFileLoader) {
        this.checkNoDuplicateUrls(lotlSources);
        int nbLOTLSources = lotlSources.size();
        LOG.info("Running analysis for {} LOTLSource(s)", (Object)nbLOTLSources);
        Map<CacheKey, ParsingCacheDTO> oldParsingValues = this.extractParsingCache(lotlSources);
        CountDownLatch latch = new CountDownLatch(nbLOTLSources);
        for (LOTLSource lotlSource : lotlSources) {
            CacheAccessByKey cacheAccess = this.cacheAccessFactory.getCacheAccess(lotlSource.getCacheKey());
            if (lotlSource.isPivotSupport()) {
                this.executorService.submit(new LOTLWithPivotsAnalysis(lotlSource, cacheAccess, dssFileLoader, this.cacheAccessFactory, latch));
                continue;
            }
            this.executorService.submit(new LOTLAnalysis(lotlSource, cacheAccess, dssFileLoader, latch));
        }
        try {
            latch.await();
            LOG.info("Analysis is DONE for {} LOTLSource(s)", (Object)nbLOTLSources);
        }
        catch (InterruptedException e) {
            LOG.error("Interruption in the LOTLSource process", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Map<CacheKey, ParsingCacheDTO> newParsingValues = this.extractParsingCache(lotlSources);
        LOTLChangeApplier lotlChangeApplier = new LOTLChangeApplier(this.cacheAccessFactory.getTLChangesCacheAccess(), oldParsingValues, newParsingValues);
        lotlChangeApplier.analyzeAndApply();
    }

    private List<TLSource> extractTlSources(List<LOTLSource> lotlList) {
        TLSourceBuilder tlSourceBuilder = new TLSourceBuilder(lotlList, this.extractParsingCache(lotlList));
        return tlSourceBuilder.build();
    }

    private Map<CacheKey, ParsingCacheDTO> extractParsingCache(List<LOTLSource> lotlSources) {
        ReadOnlyCacheAccess readOnlyCacheAccess = this.cacheAccessFactory.getReadOnlyCacheAccess();
        return lotlSources.stream().collect(Collectors.toMap(TLSource::getCacheKey, s -> readOnlyCacheAccess.getParsingCacheDTO(s.getCacheKey())));
    }

    private void executeTLSourcesAnalysis(List<TLSource> tlSources, DSSFileLoader dssFileLoader) {
        int nbTLSources = tlSources.size();
        if (nbTLSources == 0) {
            LOG.info("No TL to be analyzed");
            return;
        }
        this.checkNoDuplicateUrls(tlSources);
        LOG.info("Running analysis for {} TLSource(s)", (Object)nbTLSources);
        CountDownLatch latch = new CountDownLatch(nbTLSources);
        for (TLSource tlSource : tlSources) {
            CacheAccessByKey cacheAccess = this.cacheAccessFactory.getCacheAccess(tlSource.getCacheKey());
            this.executorService.submit(new TLAnalysis(tlSource, cacheAccess, dssFileLoader, latch));
        }
        try {
            latch.await();
            LOG.info("Analysis is DONE for {} TLSource(s)", (Object)nbTLSources);
        }
        catch (InterruptedException e) {
            LOG.error("Interruption in the TLAnalysis process", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void synchronizeTLCertificateSource() {
        if (this.trustedListCertificateSource == null) {
            LOG.warn("No TrustedListCertificateSource to be synchronized");
            return;
        }
        TrustedListCertificateSourceSynchronizer synchronizer = new TrustedListCertificateSourceSynchronizer(this.trustedListSources, this.listOfTrustedListSources, this.trustedListCertificateSource, this.synchronizationStrategy, this.cacheAccessFactory.getSynchronizerCacheAccess());
        synchronizer.sync();
    }

    private void executeCacheCleaner() {
        if (this.cacheCleaner == null) {
            LOG.debug("Cache cleaner is not defined");
            return;
        }
        LOG.info("Running CacheCleaner");
        Set<CacheKey> cacheKeys = this.cacheAccessFactory.getReadOnlyCacheAccess().getAllCacheKeys();
        for (CacheKey cacheKey : cacheKeys) {
            CacheAccessByKey cacheAccess = this.cacheAccessFactory.getCacheAccess(cacheKey);
            this.cacheCleaner.clean(cacheAccess);
        }
        LOG.info("CacheCleaner process is DONE");
    }

    private void checkNoDuplicateUrls(List<? extends TLSource> sources) {
        List allUrls = sources.stream().map(TLSource::getUrl).collect(Collectors.toList());
        HashSet uniqueUrls = new HashSet(allUrls);
        if (allUrls.size() > uniqueUrls.size()) {
            throw new DSSException(String.format("Duplicate urls found : %s", allUrls));
        }
    }
}

